/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal.command.navigation;

import java.util.Iterator;
import java.util.List;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.command.PostDeterminedEffectCommand;
import net.refractions.udig.project.command.UndoableCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.internal.render.ViewportModel;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;

public class NavComposite
extends UndoableComposite
implements NavCommand {
    ViewportModel model;

    public NavComposite(List navCommands) {
        super(navCommands);
    }

    @Override
    public void setViewportModel(ViewportModel model) {
        this.model = model;
        for (NavCommand command : this.commands) {
            command.setViewportModel(model);
        }
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        this.execute(monitor);
    }

    @Override
    public boolean execute(IProgressMonitor monitor) throws Exception {
        monitor.beginTask(this.getName(), 12 * this.commands.size());
        monitor.worked(2);
        boolean previousDeliver = this.model.eDeliver();
        this.model.eSetDeliver(false);
        boolean changedState = false;
        try {
            Iterator iter = this.commands.iterator();
            while (iter.hasNext()) {
                NavCommand command = (NavCommand)iter.next();
                if (!iter.hasNext()) {
                    this.model.eSetDeliver(previousDeliver);
                }
                command.setMap(this.getMap());
                command.setViewportModel(this.model);
                changedState |= this.runCommand(command, monitor);
            }
            monitor.done();
        }
        finally {
            this.model.eSetDeliver(previousDeliver);
        }
        return changedState;
    }

    private boolean runCommand(NavCommand command, IProgressMonitor monitor) throws Exception {
        boolean changed;
        SubProgressMonitor subProgressMonitor = new SubProgressMonitor(monitor, 10);
        if (command instanceof PostDeterminedEffectCommand) {
            changed = ((PostDeterminedEffectCommand)((Object)command)).execute((IProgressMonitor)subProgressMonitor);
        } else {
            command.run((IProgressMonitor)subProgressMonitor);
            changed = true;
        }
        subProgressMonitor.done();
        return changed;
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        boolean previousDeliver = this.model.eDeliver();
        this.model.eSetDeliver(false);
        try {
            UndoableCommand command;
            int i = this.finalizerCommands.size() - 1;
            while (i > -1) {
                command = (UndoableCommand)this.finalizerCommands.get(i);
                command.rollback(monitor);
                --i;
            }
            i = this.commands.size() - 1;
            while (i > -1) {
                if (i == 0) {
                    this.model.eSetDeliver(previousDeliver);
                }
                command = (UndoableCommand)this.commands.get(i);
                command.rollback(monitor);
                --i;
            }
        }
        finally {
            this.model.eSetDeliver(previousDeliver);
        }
    }
}

