/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal;

import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.project.BlackboardEvent;
import net.refractions.udig.project.IBlackboard;
import net.refractions.udig.project.IBlackboardListener;
import net.refractions.udig.project.internal.ProjectPlugin;

public class SimpleBlackboard
implements IBlackboard {
    Map<String, Object> map;
    CopyOnWriteArraySet<IBlackboardListener> listeners = new CopyOnWriteArraySet();

    public SimpleBlackboard() {
        this.map = new HashMap<String, Object>();
    }

    public SimpleBlackboard(Map<String, Object> map) {
        this.map = map;
    }

    @Override
    public Object get(String key) {
        return this.map.get(key);
    }

    @Override
    public void put(String key, Object value) {
        Object oldValue = this.map.put(key, value);
        BlackboardEvent event = new BlackboardEvent(this, key, oldValue, value);
        for (IBlackboardListener l : this.listeners) {
            try {
                l.blackBoardChanged(event);
            }
            catch (Exception e) {
                ProjectPlugin.log("", e);
            }
        }
    }

    @Override
    public Object remove(String key) {
        Object oldValue = this.map.remove(key);
        BlackboardEvent event = new BlackboardEvent(this, key, oldValue, null);
        for (IBlackboardListener l : this.listeners) {
            try {
                l.blackBoardChanged(event);
            }
            catch (Exception e) {
                ProjectPlugin.log("", e);
            }
        }
        return oldValue;
    }

    @Override
    public Float getFloat(String key) {
        Object value;
        if (this.map.containsKey(key) && (value = this.map.get(key)) instanceof Float) {
            return (Float)value;
        }
        return null;
    }

    @Override
    public Integer getInteger(String key) {
        Object value;
        if (this.map.containsKey(key) && (value = this.map.get(key)) instanceof Integer) {
            return (Integer)value;
        }
        return null;
    }

    @Override
    public String getString(String key) {
        Object value;
        if (this.map.containsKey(key) && (value = this.map.get(key)) instanceof String) {
            return (String)value;
        }
        return null;
    }

    @Override
    public void putFloat(String key, float value) {
        this.put(key, Float.valueOf(value));
    }

    @Override
    public void putInteger(String key, int value) {
        this.put(key, value);
    }

    @Override
    public void putString(String key, String value) {
        this.put(key, value);
    }

    @Override
    public void clear() {
        this.map.clear();
        for (IBlackboardListener l : this.listeners) {
            try {
                l.blackBoardCleared(this);
            }
            catch (Exception e) {
                ProjectPlugin.log("", e);
            }
        }
    }

    @Override
    public void flush() {
    }

    @Override
    public boolean contains(String key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean addListener(IBlackboardListener listener) {
        return this.listeners.add(listener);
    }

    @Override
    public boolean removeListener(IBlackboardListener listener) {
        return this.listeners.remove(listener);
    }

    @Override
    public void addAll(IBlackboard blackboard) {
        Set<String> keySet = blackboard.keySet();
        for (String key : keySet) {
            this.put(key, blackboard.get(key));
        }
    }

    @Override
    public Set<String> keySet() {
        return this.map.keySet();
    }
}

