/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.internal;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.catalog.ServiceParameterPersister;
import net.refractions.udig.catalog.URLUtils;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.impl.LayerImpl;
import net.refractions.udig.ui.ProgressManager;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IExportedPreferences;
import org.eclipse.core.runtime.preferences.IPreferencesService;
import org.eclipse.emf.ecore.resource.Resource;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CatalogRef {
    protected Layer layer;
    protected static final String ENCODING = "UTF-8";
    private static final String ERROR_SAVING = "Error saving";
    protected Map<ID, Map<String, Serializable>> connectionParams = Collections.synchronizedMap(new HashMap());
    private volatile boolean loaded = false;

    public CatalogRef(Layer layer) {
        this.layer = layer;
    }

    public CatalogRef() {
    }

    public String marshalConnectionParameters() {
        try {
            List<IGeoResource> resources = this.layer.getGeoResources();
            Preferences toSave = Platform.getPreferencesService().getRootNode().node("net.refractions.udig.project").node(this.layerIDToString());
            if (resources != LayerImpl.NULL) {
                this.connectionParams.clear();
                LayerCatalogRefPersister persister = new LayerCatalogRefPersister(this.connectionParams, this.getMapFile());
                persister.store(ProgressManager.instance().get(new Object[0]), toSave, resources);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Platform.getPreferencesService().exportPreferences((IEclipsePreferences)toSave, (OutputStream)out, null);
            toSave.clear();
            return URLEncoder.encode(out.toString(), ENCODING);
        }
        catch (Throwable t) {
            ProjectPlugin.log("Error saving parameters for layer: " + (this.layer == null ? "unkown id" : this.layer.getID()) + " this map cannot be sent to a collegue", t);
            return ERROR_SAVING;
        }
    }

    private File getMapFile() {
        Resource resource = this.layer.getMapInternal().eResource();
        if (resource != null) {
            return new File(resource.getURI().toFileString());
        }
        return null;
    }

    private String layerIDToString() throws UnsupportedEncodingException {
        if (this.layer != null && this.layer.getID() != null) {
            return URLEncoder.encode(this.layer.getID().toString(), ENCODING);
        }
        return "ID_" + System.currentTimeMillis();
    }

    public void parseResourceParameters(String string) {
        String decoded;
        if (string == null || string.length() == 0) {
            return;
        }
        try {
            decoded = URLDecoder.decode(string, ENCODING);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            decoded = string;
        }
        ByteArrayInputStream input = new ByteArrayInputStream(decoded.getBytes());
        try {
            IPreferencesService preferencesService = Platform.getPreferencesService();
            IExportedPreferences paramsNode = preferencesService.readPreferences((InputStream)input);
            LayerCatalogRefPersister persister = new LayerCatalogRefPersister(this.connectionParams, null);
            persister.restore(this.findParameterNode(paramsNode));
        }
        catch (Throwable e) {
            ProjectPlugin.log("CatalogRef#parseResourceParameters, couldn't load paramters", e);
        }
    }

    private Preferences findParameterNode(IExportedPreferences paramsNode) throws BackingStoreException {
        String[] name = paramsNode.childrenNames();
        Preferences plugin = paramsNode.node(name[0]);
        name = plugin.childrenNames();
        return plugin.node(name[0]);
    }

    public Layer getLayer() {
        return this.layer;
    }

    public void setLayer(Layer layer) {
        this.layer = layer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void load() {
        ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
        IServiceFactory serviceFactory = CatalogPlugin.getDefault().getServiceFactory();
        Map<ID, Map<String, Serializable>> map = this.connectionParams;
        synchronized (map) {
            for (Map.Entry<ID, Map<String, Serializable>> entry : this.connectionParams.entrySet()) {
                Map<String, Serializable> params = entry.getValue();
                boolean couldResolve = this.resolveURLs(params);
                if (!couldResolve) {
                    ProjectPlugin.log("Warning: couldn't find the layer's resources in the catalog and can't construct it because the current map does not have a Resource:" + this.layer.getID(), new Exception("Failure loading layer"));
                    continue;
                }
                List createdServices = serviceFactory.createService(params);
                this.updateLayerID(createdServices);
                if (this.serviceExistsInCatalog(createdServices, catalog)) continue;
                this.addServicesToCatalog(createdServices, catalog);
            }
        }
        this.loaded = true;
    }

    private void updateLayerID(List<IService> createdServices) {
        if (createdServices.isEmpty()) {
            return;
        }
        URL layerid = this.getLayer().getID();
        for (IService service : createdServices) {
            if (!URLUtils.urlEquals((URL)layerid, (URL)service.getIdentifier(), (boolean)true)) continue;
            return;
        }
        URL id = createdServices.get(0).getIdentifier();
        String serviceIdAsString = URLUtils.urlToString((URL)id, (boolean)false);
        String externalizedLayerID = layerid.toExternalForm();
        String[] segments = externalizedLayerID.split("#");
        if (segments.length < 2) {
            ProjectPlugin.log("Some service doesn't obey the convention where georesources must be the serviceid#subid. \n\nLayer id = " + layerid + "\n\nThe potential culprits are: " + createdServices);
            return;
        }
        try {
            this.layer.setID(new URL(String.valueOf(serviceIdAsString) + "#" + segments[1]));
        }
        catch (MalformedURLException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    private void addServicesToCatalog(List<IService> createdServices, ICatalog catalog) {
        for (IService service : createdServices) {
            catalog.add(service);
        }
    }

    private boolean serviceExistsInCatalog(List<IService> createdServices, ICatalog catalog) {
        boolean found = false;
        for (IService service : createdServices) {
            if (catalog.getById(IService.class, service.getID(), ProgressManager.instance().get(new Object[0])) != null) {
                found = true;
                continue;
            }
            catalog.add(service);
        }
        return found;
    }

    private boolean resolveURLs(Map<String, Serializable> params) {
        Set<Map.Entry<String, Serializable>> entries = params.entrySet();
        for (Map.Entry<String, Serializable> entry : entries) {
            File mapFile;
            String url;
            block4: {
                if (!(entry.getValue() instanceof URL)) continue;
                url = ((URL)entry.getValue()).toExternalForm();
                mapFile = this.getMapFile();
                if (mapFile != null) break block4;
                return false;
            }
            try {
                entry.setValue(URLUtils.constructURL((File)mapFile, (String)url));
            }
            catch (MalformedURLException e) {
                ProjectPlugin.log("Couldn't resolve the URL", e);
            }
        }
        return true;
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    private static class LayerCatalogRefPersister
    extends ServiceParameterPersister {
        private Map<ID, Map<String, Serializable>> allParams;

        public LayerCatalogRefPersister(Map<ID, Map<String, Serializable>> allParams, File mapFile) {
            super(CatalogPlugin.getDefault().getLocalCatalog(), CatalogPlugin.getDefault().getServiceFactory(), mapFile);
            this.allParams = allParams;
        }

        protected void locateService(ID id, Map<String, Serializable> map, Map<String, Serializable> properties, Map<ID, Map<String, Serializable>> resourcePropertyMap) {
            if (this.allParams.containsKey(id)) {
                ProjectPlugin.log("LayerCatalogRefPersister#locateService: duplicate resource ids when loading paramers");
            }
            this.allParams.put(id, map);
        }
    }
}

