/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.element.impl;

import java.io.IOException;
import java.util.List;
import net.refractions.udig.core.internal.ExtensionPointList;
import net.refractions.udig.project.IProject;
import net.refractions.udig.project.element.ElementFactory;
import net.refractions.udig.project.element.ElementPackage;
import net.refractions.udig.project.element.IGenericProjectElement;
import net.refractions.udig.project.element.ProjectElementAdapter;
import net.refractions.udig.project.element.impl.ProjectElementAdapterImpl;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.memento.UdigMemento;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.impl.EFactoryImpl;
import org.eclipse.emf.ecore.plugin.EcorePlugin;

public class ElementFactoryImpl
extends EFactoryImpl
implements ElementFactory {
    private static final String EXTENSION_POINT_ID_KEY = "@ElementFactoryImpl.ExtensionPointId.key@";

    public static ElementFactory init() {
        try {
            ElementFactory theElementFactory = (ElementFactory)EPackage.Registry.INSTANCE.getEFactory("http:///net/refractions/udig/project/element.ecore");
            if (theElementFactory != null) {
                return theElementFactory;
            }
        }
        catch (Exception exception) {
            EcorePlugin.INSTANCE.log((Object)exception);
        }
        return new ElementFactoryImpl();
    }

    public EObject create(EClass eClass) {
        switch (eClass.getClassifierID()) {
            case 0: {
                return this.createProjectElementAdapter();
            }
        }
        throw new IllegalArgumentException("The class '" + eClass.getName() + "' is not a valid classifier");
    }

    public Object createFromString(EDataType eDataType, String initialValue) {
        switch (eDataType.getClassifierID()) {
            case 1: {
                return this.createIGenericProjectElementFromString(eDataType, initialValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    public String convertToString(EDataType eDataType, Object instanceValue) {
        switch (eDataType.getClassifierID()) {
            case 1: {
                return this.convertIGenericProjectElementToString(eDataType, instanceValue);
            }
        }
        throw new IllegalArgumentException("The datatype '" + eDataType.getName() + "' is not a valid classifier");
    }

    @Override
    public ProjectElementAdapter createProjectElementAdapter() {
        ProjectElementAdapterImpl projectElementAdapter = new ProjectElementAdapterImpl();
        return projectElementAdapter;
    }

    public IGenericProjectElement createIGenericProjectElementFromString(EDataType eDataType, String initialValue) {
        try {
            UdigMemento memento = UdigMemento.readString(initialValue);
            IGenericProjectElement backingObject = this.createGenericProjectElement(IGenericProjectElement.class, memento.getString(EXTENSION_POINT_ID_KEY));
            backingObject.init(memento);
            return backingObject;
        }
        catch (IOException e) {
            ProjectPlugin.log("Error parsing memento data for IGenericProject Element", e);
            return null;
        }
    }

    public String convertIGenericProjectElementToString(EDataType eDataType, Object instanceValue) {
        IGenericProjectElement elem = (IGenericProjectElement)instanceValue;
        UdigMemento memento = new UdigMemento();
        elem.save(memento);
        memento.putString(EXTENSION_POINT_ID_KEY, elem.getExtensionId());
        return memento.toString();
    }

    @Override
    public ElementPackage getElementPackage() {
        return (ElementPackage)this.getEPackage();
    }

    @Deprecated
    public static ElementPackage getPackage() {
        return ElementPackage.eINSTANCE;
    }

    @Override
    public ProjectElementAdapter createProjectElementAdapter(IProject project, Class<? extends IGenericProjectElement> typeToCreate, String extensionId) {
        ProjectElementAdapter adapter = this.createProjectElementAdapter();
        IGenericProjectElement genericProjectElement = this.createGenericProjectElement(typeToCreate, extensionId);
        adapter.setBackingObject(genericProjectElement);
        ((Project)project).getElementsInternal().add(adapter);
        return adapter;
    }

    @Override
    public ProjectElementAdapter createProjectElementAdapter(IProject project, String elemName, Class<? extends IGenericProjectElement> typeToCreate, String extensionId) {
        ProjectElementAdapter adapter = this.createProjectElementAdapter();
        adapter.setName(elemName);
        IGenericProjectElement genericProjectElement = this.createGenericProjectElement(typeToCreate, extensionId);
        adapter.setBackingObject(genericProjectElement);
        ((Project)project).getElementsInternal().add(adapter);
        return adapter;
    }

    private <T extends IGenericProjectElement> T createGenericProjectElement(Class<T> typeToCreate, String extensionId) {
        List list = ExtensionPointList.getExtensionPointList((String)"net.refractions.udig.project.element");
        for (IConfigurationElement configurationElement : list) {
            String id = configurationElement.getAttribute("id");
            if (id == null || !id.equals(extensionId)) continue;
            try {
                Object obj = configurationElement.createExecutableExtension("class");
                if (typeToCreate.isAssignableFrom(obj.getClass())) {
                    ((IGenericProjectElement)obj).setExtensionId(extensionId);
                    return (T)((IGenericProjectElement)typeToCreate.cast(obj));
                }
                throw new IllegalArgumentException("The " + extensionId + " created an object of type: " + obj.getClass() + " which is not compatible with " + typeToCreate);
            }
            catch (CoreException e) {
                throw new RuntimeException("Error creating extension", e);
            }
        }
        throw new IllegalArgumentException(String.valueOf(extensionId) + " was not a valid extension id");
    }
}

