/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command.provider;

import java.io.IOException;
import net.refractions.udig.core.IBlockingProvider;
import net.refractions.udig.core.internal.FeatureUtils;
import net.refractions.udig.project.ILayer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.data.FeatureSource;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.factory.GeoTools;
import org.geotools.factory.Hints;
import org.geotools.feature.FeatureIterator;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.Id;

public class FIDFeatureProvider
implements IBlockingProvider<SimpleFeature> {
    private IBlockingProvider<ILayer> layerProvider;
    private String fid;
    private SimpleFeature feature;

    public FIDFeatureProvider(String fid2, IBlockingProvider<ILayer> layer2) {
        this.layerProvider = layer2;
        if (fid2 == null) {
            throw new NullPointerException("Fid must not be null");
        }
        this.fid = fid2;
    }

    public synchronized SimpleFeature get(IProgressMonitor monitor, Object ... params) {
        if (this.feature == null) {
            FilterFactory filterFactory = CommonFactoryFinder.getFilterFactory((Hints)GeoTools.getDefaultHints());
            Id fidFilter = filterFactory.id(FeatureUtils.stringToId((FilterFactory)filterFactory, (String)this.fid));
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            try {
                try {
                    monitor.beginTask("Get Feature", 100);
                    ILayer layer = (ILayer)this.layerProvider.get((IProgressMonitor)new SubProgressMonitor(monitor, 25), new Object[0]);
                    FeatureSource source = layer.getResource(FeatureSource.class, (IProgressMonitor)new SubProgressMonitor(monitor, 25));
                    FeatureIterator iter = source.getFeatures((Filter)fidFilter).features();
                    monitor.worked(25);
                    try {
                        if (iter.hasNext()) {
                            this.feature = (SimpleFeature)iter.next();
                        }
                        monitor.worked(25);
                    }
                    finally {
                        iter.close();
                    }
                }
                catch (IOException e) {
                    throw (RuntimeException)new RuntimeException().initCause(e);
                }
            }
            finally {
                monitor.done();
            }
        }
        return this.feature;
    }
}

