/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command.map;

import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.LayerLegendItem;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.viewers.IStructuredSelection;

public class LayerMoveDownCommand
extends AbstractCommand
implements UndoableMapCommand {
    private List<ILayer> selection;

    public LayerMoveDownCommand(ILayer layer) {
        this.selection = new ArrayList<ILayer>();
        this.selection.add(layer);
    }

    public LayerMoveDownCommand(IStructuredSelection structuredSelection) {
        this.selection = new ArrayList<ILayer>();
        if (structuredSelection.isEmpty()) {
            return;
        }
        for (Object item : structuredSelection) {
            if (item instanceof ILayer) {
                ILayer layer = (ILayer)item;
                this.selection.add(layer);
                continue;
            }
            if (!(item instanceof LayerLegendItem)) continue;
            LayerLegendItem layerItem = (LayerLegendItem)item;
            this.selection.add(layerItem.getLayer());
        }
    }

    public LayerMoveDownCommand(List<ILayer> selection) {
        this.selection = selection;
    }

    @Override
    public String getName() {
        return "Move Up";
    }

    @Override
    public void run(IProgressMonitor monitor) throws Exception {
        for (ILayer layer : this.selection) {
            this.getMap().lowerLayer((Layer)layer);
        }
    }

    @Override
    public void rollback(IProgressMonitor monitor) throws Exception {
        for (ILayer layer : this.selection) {
            this.getMap().raiseLayer((Layer)layer);
        }
    }
}

