/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command.map;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.AbstractCommand;
import net.refractions.udig.project.command.UndoableCommand;
import net.refractions.udig.project.internal.LayerLegendItem;
import net.refractions.udig.project.internal.Map;
import org.eclipse.jface.viewers.IStructuredSelection;

public abstract class AbstractLayerMoveCommand
extends AbstractCommand
implements UndoableCommand {
    private List<Integer> index;
    private List<ILayer> selection;

    public AbstractLayerMoveCommand(Map map, ILayer layer) {
        this.selection = new ArrayList<ILayer>();
        this.selection.add(layer);
        this.index = new ArrayList<Integer>();
        this.index.add(this.getIndex(map, layer));
    }

    public AbstractLayerMoveCommand(Map map, IStructuredSelection structuredSelection) {
        this.selection = new ArrayList<ILayer>();
        this.index = new ArrayList<Integer>();
        if (structuredSelection.isEmpty()) {
            return;
        }
        for (Object item : structuredSelection) {
            ILayer layer = null;
            if (item instanceof ILayer) {
                layer = (ILayer)item;
            } else if (item instanceof LayerLegendItem) {
                LayerLegendItem layerItem = (LayerLegendItem)item;
                layer = layerItem.getLayer();
            }
            if (layer == null) continue;
            this.selection.add(layer);
            this.index.add(this.getIndex(map, layer));
        }
    }

    public AbstractLayerMoveCommand(Map map, List<ILayer> selection) {
        this.selection = selection;
        this.index = new ArrayList<Integer>();
        Iterator<ILayer> iterator = selection.iterator();
        while (iterator.hasNext()) {
            ILayer iLayer;
            ILayer layer = iLayer = iterator.next();
            this.index.add(this.getIndex(map, layer));
        }
    }

    public List<ILayer> getSelection() {
        return this.selection;
    }

    public List<Integer> getIndex() {
        return this.index;
    }

    private Integer getIndex(Map map, ILayer layer) {
        return map.getLayersInternal().indexOf(layer);
    }
}

