/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command.factory;

import com.vividsolutions.jts.geom.Envelope;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.CompositeCommand;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableComposite;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.commands.selection.BBoxSelectionCommand;
import net.refractions.udig.project.internal.commands.selection.FIDSelectCommand;
import net.refractions.udig.project.internal.commands.selection.NoSelectCommand;
import net.refractions.udig.project.internal.commands.selection.SelectCommand;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.filter.Filter;

public class SelectionCommandFactory
extends net.refractions.udig.project.command.SelectionCommandFactory {
    private static final SelectionCommandFactory instance = new SelectionCommandFactory();

    public static SelectionCommandFactory getInstance() {
        return instance;
    }

    protected SelectionCommandFactory() {
    }

    @Override
    public UndoableMapCommand createBBoxSelectionCommand(Envelope bbox, int modifiers) {
        return new BBoxSelectionCommand(bbox, modifiers);
    }

    @Override
    public UndoableMapCommand createBBoxSelectionCommand(Envelope boundingBox) {
        return new BBoxSelectionCommand(boundingBox, 0);
    }

    @Override
    public UndoableMapCommand createNoSelectCommand() {
        return new NoSelectCommand();
    }

    @Override
    public UndoableMapCommand createFIDSelectCommand(ILayer layer, String fid) {
        return new FIDSelectCommand(layer, fid);
    }

    @Override
    public UndoableMapCommand createFIDSelectCommand(ILayer layer, SimpleFeature feature) {
        return new FIDSelectCommand(layer, feature.getID());
    }

    @Override
    public UndoableMapCommand createSelectCommand(ILayer layer, Filter filter) {
        return new SelectCommand(layer, filter);
    }

    @Override
    public MapCommand createCompositeCommand(List<? extends MapCommand> commands) {
        return new CompositeCommand(commands);
    }

    @Override
    public UndoableMapCommand createUndoableCompositeCommand(List<? extends UndoableMapCommand> commands) {
        return new UndoableComposite(commands);
    }

    public static /* bridge */ /* synthetic */ net.refractions.udig.project.command.SelectionCommandFactory getInstance() {
        return SelectionCommandFactory.getInstance();
    }
}

