/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command.factory;

import java.util.Collection;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.Interaction;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.commands.AddLayerCommand;
import net.refractions.udig.project.internal.commands.AddLayersCommand;
import net.refractions.udig.project.internal.commands.ChangeCRSCommand;
import net.refractions.udig.project.internal.commands.CreateMapCommand;
import net.refractions.udig.project.internal.commands.DeleteLayerCommand;
import net.refractions.udig.project.internal.commands.SetApplicabilityCommand;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BasicCommandFactory
extends net.refractions.udig.project.command.BasicCommandFactory {
    private static final BasicCommandFactory instance = new BasicCommandFactory();

    public static BasicCommandFactory getInstance() {
        return instance;
    }

    protected BasicCommandFactory() {
    }

    @Override
    public UndoableMapCommand createDeleteLayer(ILayer layer) {
        return new DeleteLayerCommand((Layer)layer);
    }

    @Override
    public UndoableMapCommand createAddLayer(ILayer layer) {
        return new AddLayerCommand((Layer)layer);
    }

    @Override
    public UndoableMapCommand createAddLayer(ILayer layer, int index) {
        return new AddLayerCommand((Layer)layer, index);
    }

    public UndoableMapCommand createAddManyLayers(Collection layers, int index) {
        return new AddLayersCommand(layers, index);
    }

    public UndoableMapCommand createAddManyLayers(Collection layers) {
        return new AddLayersCommand(layers);
    }

    @Override
    public UndoableMapCommand createChangeCRS(IMap map, CoordinateReferenceSystem crs) {
        return new ChangeCRSCommand((Map)map, crs);
    }

    public UndoableMapCommand createCreateMapCommand(String name, List<IGeoResource> layerResources, Project owner) {
        return new CreateMapCommand(name, layerResources, owner);
    }

    public UndoableMapCommand createCreateMapCommand(List<IGeoResource> layerResources, Project owner) {
        return new CreateMapCommand(null, layerResources, owner);
    }

    public UndoableMapCommand createCreateMapCommand(String name, List<IGeoResource> layerResources) {
        return new CreateMapCommand(name, layerResources, null);
    }

    public UndoableMapCommand createCreateMapCommand(List<IGeoResource> layerResources) {
        return new CreateMapCommand(null, layerResources, null);
    }

    public UndoableMapCommand createSetApplicabilityCommand(ILayer layer, Interaction applicabilityId, boolean newValue) {
        return new SetApplicabilityCommand(layer, applicabilityId, newValue);
    }

    public static /* bridge */ /* synthetic */ net.refractions.udig.project.command.BasicCommandFactory getInstance() {
        return BasicCommandFactory.getInstance();
    }
}

