/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.util.Arrays;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.internal.command.navigation.NavComposite;
import net.refractions.udig.project.internal.command.navigation.PanCommand;
import net.refractions.udig.project.internal.command.navigation.SetViewportBBoxCommand;
import net.refractions.udig.project.internal.command.navigation.SetViewportCenterCommand;
import net.refractions.udig.project.internal.command.navigation.SetViewportHeight;
import net.refractions.udig.project.internal.command.navigation.SetViewportWidth;
import net.refractions.udig.project.internal.command.navigation.ZoomCommand;
import net.refractions.udig.project.internal.command.navigation.ZoomExtentCommand;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class NavigationCommandFactory {
    private static final NavigationCommandFactory instance = new NavigationCommandFactory();

    public static NavigationCommandFactory getInstance() {
        return instance;
    }

    protected NavigationCommandFactory() {
    }

    public NavCommand createCompositeCommand(NavCommand[] commands) {
        return new NavComposite(Arrays.asList(commands));
    }

    public NavCommand createSetViewportBBoxCommand(Envelope newbbox) {
        return new SetViewportBBoxCommand(newbbox);
    }

    public NavCommand createZoomCommand(double zoomfactor) {
        return new ZoomCommand(zoomfactor);
    }

    public NavCommand createZoomExtentCommand() {
        return new ZoomExtentCommand();
    }

    public NavCommand createSetViewportCenterCommand(Coordinate center) {
        return new SetViewportCenterCommand(center);
    }

    public NavCommand createSetViewportHeight(double height) {
        return new SetViewportHeight(height);
    }

    public NavCommand createSetViewportWidth(double width) {
        return new SetViewportWidth(width);
    }

    public NavCommand createPanCommandUsingScreenCoords(int xpixels, int ypixels) {
        return new PanCommand(xpixels, ypixels);
    }

    public NavCommand createPanCommandUsingWorldCoords(double x, double y) {
        return new PanCommand(x, y);
    }

    public NavCommand createSetViewportBBoxCommand(Envelope bounds, CoordinateReferenceSystem crs) {
        return new SetViewportBBoxCommand(bounds, crs);
    }
}

