/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command;

import java.util.LinkedList;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CopyOnWriteArraySet;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.CommandListener;
import net.refractions.udig.project.command.CommandStack;
import net.refractions.udig.project.command.ErrorHandler;
import net.refractions.udig.project.command.NavCommand;
import net.refractions.udig.project.command.NavCommandStack;
import net.refractions.udig.project.command.PostDeterminedEffectCommand;
import net.refractions.udig.project.command.UndoableCommand;
import net.refractions.udig.project.internal.Messages;
import net.refractions.udig.project.internal.ProjectPlugin;
import net.refractions.udig.project.internal.commands.edit.RollbackCommand;
import net.refractions.udig.project.internal.commands.selection.CommitCommand;
import net.refractions.udig.ui.PlatformGIS;
import net.refractions.udig.ui.ProgressMonitorTaskNamer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialogWithToggle;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.preferences.ScopedPreferenceStore;

public class CommandManager
implements CommandStack,
NavCommandStack {
    private static final String TRACE_ID = "net.refractions.udig.project/debug/commands/manager/trace";
    private long timeout = -1L;
    Set<ErrorHandler> handlers = new CopyOnWriteArraySet<ErrorHandler>();
    Set<CommandListener> completionHandlers = new CopyOnWriteArraySet<CommandListener>();
    Executor commandExecutor;
    private final String managerName;

    public CommandManager(String managerName, ErrorHandler handler, CommandListener commandCompletionListener) {
        this.managerName = managerName;
        this.handlers.add(handler);
        if (commandCompletionListener != null) {
            this.completionHandlers.add(commandCompletionListener);
        }
    }

    public CommandManager(String managerName, ErrorHandler handler) {
        this(managerName, handler, null);
    }

    public CommandManager(String managerName, ErrorHandler handler, CommandListener commandCompletionListener, long timeout2) {
        this(managerName, handler, commandCompletionListener);
        this.timeout = timeout2;
    }

    public boolean execute(Command command, boolean async) {
        int type = 0;
        return this.doMakeRequest(command, async, type);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean doMakeRequest(Command command, boolean async, int type) {
        Request request = new Request(type, command, async, Display.getCurrent() != null);
        CommandManager commandManager = this;
        synchronized (commandManager) {
            if (this.commandExecutor == null) {
                this.commandExecutor = new Executor(this.managerName);
            }
        }
        this.commandExecutor.addRequest(request);
        if (request.isSync()) {
            block10: {
                try {
                    Display current = Display.getCurrent();
                    if (current != null) {
                        this.waitInDisplay(current, request);
                    } else {
                        this.waitOnRequest(request);
                    }
                    if (request.completed) break block10;
                    ProjectPlugin.trace(TRACE_ID, this.getClass(), "Request didn't complete", null);
                    this.commandExecutor.removeCommand(request);
                    return false;
                }
                catch (InterruptedException e) {
                    ProjectPlugin.log("Error running commands synchronously", e);
                    return false;
                }
            }
            ProjectPlugin.trace(TRACE_ID, this.getClass(), "Request completed", null);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long waitOnRequest(Request request) throws InterruptedException {
        ProjectPlugin.trace(TRACE_ID, this.getClass(), "synchronous command NOT in display thread\nTimout=" + this.timeout, null);
        long tries = 0L;
        while (this.mustWait(request, tries)) {
            tries += 500L;
            Request request2 = request;
            synchronized (request2) {
                request.wait(500L);
            }
        }
        return tries;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long waitInDisplay(Display current, Request request) throws InterruptedException {
        ProjectPlugin.trace(TRACE_ID, this.getClass(), "synchronous command IN display thread\nTimout=" + this.timeout, null);
        long start = System.currentTimeMillis();
        while (this.mustWait(request, System.currentTimeMillis() - start)) {
            if (current.readAndDispatch()) continue;
            if (!this.mustWait(request, System.currentTimeMillis() - start)) {
                return System.currentTimeMillis() - start;
            }
            Request request2 = request;
            synchronized (request2) {
                request.wait(300L);
            }
        }
        return System.currentTimeMillis() - start;
    }

    private boolean mustWait(Request request, long tries) {
        ProjectPlugin.trace(TRACE_ID, this.getClass(), "timeout :" + this.timeout + ", tries: " + tries + ", completed:" + request.completed, null);
        return !request.completed && (tries < this.timeout || this.timeout == -1L);
    }

    public void redo(boolean runAsync) {
        this.doMakeRequest(null, runAsync, 2);
    }

    public void undo(boolean runAsync) {
        this.doMakeRequest(null, runAsync, 1);
    }

    public void addErrorHandler(ErrorHandler handler) {
        this.handlers.add(handler);
    }

    public void removeErrorHandler(ErrorHandler handler) {
        this.handlers.remove(handler);
    }

    @Override
    public boolean canUndo() {
        Command c;
        if (this.commandExecutor == null) {
            return false;
        }
        return !this.commandExecutor.history.isEmpty() && (c = this.commandExecutor.history.peek()) instanceof UndoableCommand;
    }

    @Override
    public boolean canRedo() {
        return this.commandExecutor != null && !this.commandExecutor.undone.isEmpty();
    }

    @Override
    public boolean hasBackHistory() {
        return this.canUndo();
    }

    @Override
    public boolean hasForwardHistory() {
        return this.canRedo();
    }

    public boolean syncExecute(Command command) {
        return this.execute(command, false);
    }

    public int getMaxHistorySize() {
        return 20;
    }

    public boolean aSyncExecute(Command command) {
        return this.execute(command, true);
    }

    public class Executor
    extends Job {
        LinkedList<Command> history;
        LinkedList<Command> undone;
        Queue<Request> commands;
        IProgressMonitor progressMonitor;
        Request currentRequest;

        public Executor(String name) {
            super(name);
            this.history = new LinkedList();
            this.undone = new LinkedList();
            this.commands = new ConcurrentLinkedQueue<Request>();
            this.setSystem(false);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected IStatus run(IProgressMonitor monitor) {
            monitor.beginTask(Messages.CommandManager_ProgressMonitor, -1);
            while (!this.getThread().isInterrupted()) {
                Object object = this;
                synchronized (object) {
                    this.currentRequest = this.commands.poll();
                    if (this.currentRequest == null) {
                        return Status.OK_STATUS;
                    }
                }
                this.progressMonitor = new ProgressMonitorTaskNamer(monitor, 10);
                this.run(this.progressMonitor, this.currentRequest);
                if (!this.currentRequest.isSync()) continue;
                object = this.currentRequest;
                synchronized (object) {
                    this.currentRequest.notifyAll();
                }
            }
            return Status.OK_STATUS;
        }

        private void run(IProgressMonitor monitor, Request request) {
            switch (request.type) {
                case 0: {
                    this.execute(request.command, monitor);
                    break;
                }
                case 1: {
                    this.undo(monitor);
                    break;
                }
                case 2: {
                    this.redo(monitor);
                    break;
                }
                case 4: {
                    this.rerunCommands(monitor);
                }
            }
            request.completed = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addRequest(Request request) {
            if (this.getThread() == Thread.currentThread() || this.isDisplayThreadDeadlockDetected(request)) {
                this.run(this.progressMonitor, request);
            } else {
                Executor executor = this;
                synchronized (executor) {
                    this.commands.offer(request);
                    this.schedule();
                }
                Thread.yield();
            }
        }

        private boolean isDisplayThreadDeadlockDetected(Request request) {
            return Display.getCurrent() != null && this.currentRequest != null && this.currentRequest.requestByDisplay && this.currentRequest.isSync();
        }

        synchronized void removeCommand(Request request) {
            if (this.commands.remove(request)) {
                return;
            }
        }

        private void execute(Command command, IProgressMonitor monitor) {
            long time = System.currentTimeMillis();
            if (command.getName() != null) {
                monitor.beginTask(command.getName(), -1);
            }
            try {
                long l;
                boolean runCommand = this.openWarning(command);
                if (!runCommand) {
                    return;
                }
                if (command instanceof PostDeterminedEffectCommand) {
                    PostDeterminedEffectCommand c = (PostDeterminedEffectCommand)command;
                    if (c.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1000))) {
                        this.undone.clear();
                        this.addToHistory(command);
                    }
                } else {
                    command.run((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                    this.undone.clear();
                    this.addToHistory(command);
                }
                if (ProjectPlugin.isDebugging(CommandManager.TRACE_ID) && (l = System.currentTimeMillis() - time) > 100L) {
                    System.out.println(String.valueOf(command.toString()) + "--" + l);
                }
                if (this.history.size() > CommandManager.this.getMaxHistorySize()) {
                    this.history.removeFirst();
                }
                this.notifyOwner(command);
            }
            catch (Throwable e) {
                this.undone.clear();
                this.handleError(command, e);
            }
        }

        private void addToHistory(Command command) {
            if (this.history.size() > ProjectPlugin.getPlugin().getPreferenceStore().getInt("P_MAX_UNDO")) {
                this.history.removeFirst();
            }
            this.history.addLast(command);
        }

        private boolean openWarning(final Command command) {
            ScopedPreferenceStore preferenceStore;
            boolean[] runCommand = new boolean[1];
            if (!(command instanceof UndoableCommand) && ProjectPlugin.getPlugin().getUndoableCommandWarning()) {
                preferenceStore = ProjectPlugin.getPlugin().getPreferenceStore();
                if (!preferenceStore.getBoolean("P_WARN_IRREVERSIBLE_COMMAND")) {
                    return preferenceStore.getBoolean("P_IRREVERSIBLE_COMMAND_VALUE");
                }
            } else {
                return true;
            }
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable((IPreferenceStore)preferenceStore, runCommand){
                private final /* synthetic */ IPreferenceStore val$preferenceStore;
                private final /* synthetic */ boolean[] val$runCommand;
                {
                    this.val$preferenceStore = iPreferenceStore;
                    this.val$runCommand = blArray;
                }

                @Override
                public void run() {
                    String string = String.valueOf(Messages.CommandManager_warning) + command.getName();
                    string = command instanceof RollbackCommand || command instanceof CommitCommand ? String.valueOf(string) + "?" : String.valueOf(string) + Messages.CommandManager_warning2;
                    MessageDialogWithToggle dialog = MessageDialogWithToggle.openOkCancelConfirm((Shell)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (String)Messages.CommandManager_warningTitle, (String)string, (String)Messages.CommandManager_toggleMessage, (boolean)false, (IPreferenceStore)this.val$preferenceStore, (String)"P_WARN_IRREVERSIBLE_COMMAND");
                    boolean bl = this.val$runCommand[0] = dialog.getReturnCode() == 0;
                    if (dialog.getToggleState()) {
                        this.val$preferenceStore.setValue("P_IRREVERSIBLE_COMMAND_VALUE", this.val$runCommand[0]);
                    }
                }
            });
            return runCommand[0];
        }

        private void notifyOwner(Command command) {
            for (CommandListener listener : CommandManager.this.completionHandlers) {
                if (command instanceof NavCommand) {
                    listener.commandExecuted(1);
                    continue;
                }
                listener.commandExecuted(0);
            }
        }

        private void redo(IProgressMonitor monitor) {
            if (this.undone.isEmpty()) {
                return;
            }
            Command command = this.undone.removeLast();
            monitor.beginTask(String.valueOf(Messages.CommandManager_redo) + command.getName(), 1000);
            try {
                if (command instanceof PostDeterminedEffectCommand) {
                    PostDeterminedEffectCommand post = (PostDeterminedEffectCommand)command;
                    post.execute((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                } else {
                    command.run((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                }
                this.addToHistory(command);
                this.notifyOwner(command);
            }
            catch (Exception e) {
                this.handleError(command, e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void undo(IProgressMonitor monitor) {
            if (!this.commands.isEmpty()) {
                Executor executor = this;
                synchronized (executor) {
                    Request r = this.commands.peek();
                    if (r.type != 1) {
                        this.commands.remove(0);
                        Command c = r.command;
                        if (!(c instanceof UndoableCommand)) {
                            throw new RuntimeException("Undoing Commands (No Undoable Command) is not handled yet because it involves rolling back the current transaction and redoing all the commands in the stack");
                        }
                        return;
                    }
                }
            }
            if (!this.history.isEmpty()) {
                Command c = this.history.removeLast();
                if (c instanceof UndoableCommand) {
                    UndoableCommand command = (UndoableCommand)c;
                    monitor.beginTask(String.valueOf(Messages.CommandManager_undo) + command.getName(), 1000);
                    try {
                        command.rollback((IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                        this.addToUndone(command);
                    }
                    catch (Throwable e) {
                        this.handleRollbackError(command, e);
                    }
                } else {
                    throw new RuntimeException("Undoing Commands (No Undoable Command) is not handled yet because it involves rolling back the current transaction and redoing all the commands in the stack");
                }
                this.notifyOwner(c);
            }
        }

        private void addToUndone(UndoableCommand command) {
            if (this.undone.size() > ProjectPlugin.getPlugin().getPreferenceStore().getInt("P_MAX_UNDO")) {
                this.undone.removeFirst();
            }
            this.undone.add(command);
        }

        private void handleError(Command command, Throwable e) {
            for (ErrorHandler handler : CommandManager.this.handlers) {
                handler.handleError(command, e);
            }
        }

        private void handleRollbackError(UndoableCommand command, Throwable e) {
            for (ErrorHandler handler : CommandManager.this.handlers) {
                handler.handleRollbackError(command, e);
            }
        }

        public void rerunCommands(IProgressMonitor monitor) {
            LinkedList<Command> q = this.history;
            this.history = new LinkedList();
            for (Command command : q) {
                this.execute(command, monitor);
            }
        }
    }

    public static class Request {
        public static final int RUN = 0;
        public static final int UNDO = 1;
        public static final int REDO = 2;
        public static final int RERUN = 4;
        public final int type;
        public final boolean async;
        public final Command command;
        public volatile boolean completed;
        public final boolean requestByDisplay;

        public Request(int type, Command command, boolean async, boolean requestByDisplay2) {
            this.requestByDisplay = requestByDisplay2;
            this.command = command;
            this.type = type;
            this.async = async;
            this.completed = false;
        }

        public boolean isSync() {
            return !this.async;
        }
    }
}

