/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project.command;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.internal.Layer;
import net.refractions.udig.project.internal.Map;
import net.refractions.udig.project.internal.commands.AddLayerCommand;
import net.refractions.udig.project.internal.commands.ChangeCRSCommand;
import net.refractions.udig.project.internal.commands.DeleteLayerCommand;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BasicCommandFactory {
    private static final BasicCommandFactory instance = new BasicCommandFactory();

    public static BasicCommandFactory getInstance() {
        return instance;
    }

    protected BasicCommandFactory() {
    }

    public UndoableMapCommand createDeleteLayer(ILayer layer) {
        return new DeleteLayerCommand((Layer)layer);
    }

    public UndoableMapCommand createAddLayer(ILayer layer) {
        return new AddLayerCommand((Layer)layer);
    }

    public UndoableMapCommand createAddLayer(ILayer layer, int index) {
        return new AddLayerCommand((Layer)layer, index);
    }

    public UndoableMapCommand createChangeCRS(IMap map, CoordinateReferenceSystem crs) {
        return new ChangeCRSCommand((Map)map, crs);
    }
}

