/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project;

import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URL;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.internal.ProjectPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.ui.IMemento;

public abstract class StyleContent {
    public static StyleContent DEFAULT = new StyleContent("StyleContent.DEFAULT"){

        @Override
        public String toString() {
            return "StyleContent.DEFAULT";
        }

        @Override
        public void save(IMemento memento, Object value) {
            if (value instanceof String) {
                String text = (String)value;
                memento.putTextData(text);
            } else if (value instanceof Serializable) {
                try {
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    ObjectOutputStream store = new ObjectOutputStream(new BufferedOutputStream(bytes));
                    store.writeObject(value);
                    store.close();
                    memento.putString("object", new String(bytes.toByteArray()));
                    memento.putString("class", value.getClass().getName());
                }
                catch (Throwable t) {
                    ProjectPlugin.trace(StyleContent.class, "Unable to persist:" + value, t);
                }
            }
        }

        @Override
        public Object load(URL url, IProgressMonitor monitor) throws IOException {
            return null;
        }

        @Override
        public Object load(IMemento memento) {
            String text = memento.getTextData();
            if (text != null) {
                return text;
            }
            String type = memento.getString("class");
            if (type == null) {
                return null;
            }
            try {
                text = memento.getString("object");
                ByteArrayInputStream bytes = new ByteArrayInputStream(text.getBytes());
                ObjectInputStream restore = new ObjectInputStream(new BufferedInputStream(bytes));
                Object value = restore.readObject();
                restore.close();
                return value;
            }
            catch (Throwable t) {
                ProjectPlugin.trace(StyleContent.class, "Unable to restore " + type + ":" + t.getLocalizedMessage(), t);
                return null;
            }
        }

        @Override
        public Class<?> getStyleClass() {
            return null;
        }

        @Override
        public Object createDefaultStyle(IGeoResource resource, Color colour, IProgressMonitor monitor) throws IOException {
            return null;
        }
    };
    public static final String XPID = "net.refractions.udig.project.style";
    private final String id;

    public String getId() {
        return this.id;
    }

    public StyleContent(String id) {
        if (id == null) {
            throw new NullPointerException("You MUST supply an ID when creating a Style Content. It is used as the 'key' when storing things on the blackboard");
        }
        this.id = id;
    }

    public abstract Class<?> getStyleClass();

    public abstract void save(IMemento var1, Object var2);

    public abstract Object load(IMemento var1);

    public abstract Object load(URL var1, IProgressMonitor var2) throws IOException;

    public abstract Object createDefaultStyle(IGeoResource var1, Color var2, IProgressMonitor var3) throws IOException;

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.getClass().getName());
        buf.append("( ");
        if (this.id != null) {
            buf.append(this.id);
            buf.append(" ");
        }
        if (this.getStyleClass() != null) {
            buf.append(this.getStyleClass().getName());
            buf.append(" ");
        }
        buf.append(")");
        return buf.toString();
    }
}

