/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.project;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.UDIGAdaptableDecorator;
import net.refractions.udig.project.internal.Project;
import net.refractions.udig.project.internal.ProjectPlugin;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.geotools.feature.DecoratingFeature;
import org.opengis.feature.simple.SimpleFeature;

public class AdaptableFeature
extends DecoratingFeature
implements IAdaptable,
SimpleFeature,
UDIGAdaptableDecorator {
    private ILayer layer;

    public AdaptableFeature(SimpleFeature feature) {
        this(feature, null);
    }

    public AdaptableFeature(SimpleFeature feature, ILayer layer) {
        super(feature);
        this.layer = layer;
    }

    public Object getAdapter(Class adapter) {
        if (ILayer.class.isAssignableFrom(adapter)) {
            if (this.layer != null) {
                return this.layer;
            }
            for (Project project : ProjectPlugin.getPlugin().getProjectRegistry().getProjects()) {
                for (IMap current : project.getElements(IMap.class)) {
                    if (!this.containsThis(current)) continue;
                    return current.getEditManager().getEditLayer();
                }
            }
        }
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public boolean equals(Object obj) {
        if (obj instanceof AdaptableFeature) {
            return this.delegate.equals(((AdaptableFeature)obj).delegate);
        }
        return this.delegate.equals(obj);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    @Override
    public Object getObject() {
        return this.delegate;
    }

    private boolean containsThis(IMap map) {
        if (map.getEditManager() == null) {
            return false;
        }
        return map.getEditManager().getEditFeature() == this || map.getEditManager().getEditFeature() == this.delegate;
    }
}

