/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.db2;

import java.io.Serializable;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.refractions.udig.catalog.AbstractDataStoreServiceExtension;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.ServiceExtension;
import net.refractions.udig.catalog.db2.DB2Plugin;
import net.refractions.udig.catalog.db2.internal.Messages;
import net.refractions.udig.catalog.internal.db2.DB2Service;
import org.eclipse.core.runtime.Platform;
import org.geotools.data.DataAccessFactory;
import org.geotools.data.DataAccessFinder;
import org.geotools.data.DataStoreFactorySpi;
import org.geotools.data.db2.DB2NGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class DB2ServiceExtension
extends AbstractDataStoreServiceExtension
implements ServiceExtension {
    private static DB2NGDataStoreFactory factory = null;
    private static boolean avaialble = true;

    public static synchronized DB2NGDataStoreFactory getFactory() {
        if (avaialble && factory == null) {
            Iterator available = DataAccessFinder.getAvailableDataStores();
            while (available.hasNext()) {
                DataAccessFactory access = (DataAccessFactory)available.next();
                if (!(access instanceof DB2NGDataStoreFactory)) continue;
                factory = (DB2NGDataStoreFactory)access;
                break;
            }
            if (factory == null) {
                avaialble = false;
            }
        }
        return factory;
    }

    public IService createService(URL id, Map<String, Serializable> params) {
        block7: {
            try {
                if (DB2ServiceExtension.getFactory() != null && DB2ServiceExtension.getFactory().isAvailable()) break block7;
                return null;
            }
            catch (Exception unexpected) {
                if (Platform.inDevelopmentMode()) {
                    DB2Plugin.log("DB2ServiceExtension.canProcess errored out with: " + unexpected, unexpected);
                }
                return null;
            }
        }
        if (!DB2ServiceExtension.getFactory().canProcess(params)) {
            return null;
        }
        if (id == null) {
            id = this.paramsToUrl(params);
        }
        if (id == null) {
            return null;
        }
        return new DB2Service(id, params);
    }

    protected URL paramsToUrl(Map<String, Serializable> params) {
        URL dbUrl;
        block2: {
            dbUrl = null;
            try {
                Object host = DB2NGDataStoreFactory.HOST.lookUp(params);
                Object port = DB2NGDataStoreFactory.PORT.lookUp(params);
                Object db = DB2NGDataStoreFactory.DATABASE.lookUp(params);
                dbUrl = new URL("http://" + host + ".db2.jdbc:" + port + "/" + db);
            }
            catch (Exception e) {
                if (!Platform.inDevelopmentMode()) break block2;
                e.printStackTrace();
            }
        }
        return dbUrl;
    }

    public Map<String, Serializable> createParams(URL url) {
        if (!DB2ServiceExtension.isDB2URL(url)) {
            return null;
        }
        AbstractDataStoreServiceExtension.ParamInfo info = this.parseParamInfo(url);
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(DB2NGDataStoreFactory.DBTYPE.key, (Serializable)DB2NGDataStoreFactory.DBTYPE.sample);
        params.put(JDBCDataStoreFactory.HOST.key, (Serializable)((Object)info.host));
        params.put(JDBCDataStoreFactory.PORT.key, info.the_port);
        params.put(JDBCDataStoreFactory.DATABASE.key, (Serializable)((Object)info.the_database));
        params.put(JDBCDataStoreFactory.USER.key, (Serializable)((Object)info.username));
        params.put(JDBCDataStoreFactory.PASSWD.key, (Serializable)((Object)info.password));
        return params;
    }

    private static final boolean isDB2URL(URL url) {
        if (url == null) {
            return false;
        }
        return url.getProtocol().toLowerCase().equals("db2") || url.getProtocol().toLowerCase().equals("db2.jdbc") || url.getProtocol().toLowerCase().equals("jdbc.db2");
    }

    public String reasonForFailure(URL url) {
        if (url == null) {
            return Messages.DB2ServiceExtension_nullURL;
        }
        if (!DB2ServiceExtension.isDB2URL(url)) {
            return Messages.DB2ServiceExtension_notDB2URL;
        }
        return this.reasonForFailure(this.createParams(url));
    }

    protected DataStoreFactorySpi getDataStoreFactory() {
        return DB2ServiceExtension.getFactory();
    }
}

