/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.oracore;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.Serializable;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.jdbc.oracore.PickleContext;
import oracle.jdbc.oracore.TDSReader;
import oracle.jdbc.oracore.UnpickleContext;
import oracle.jdbc.oracore.Util;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

public abstract class OracleType
implements Serializable {
    static final long serialVersionUID = -6719430495533003861L;
    public static final int STYLE_ARRAY_LENGTH = 0;
    public static final int STYLE_DATUM = 1;
    public static final int STYLE_JAVA = 2;
    public static final int STYLE_RAWBYTE = 3;
    public static final int STYLE_INT = 4;
    public static final int STYLE_DOUBLE = 5;
    public static final int STYLE_FLOAT = 6;
    public static final int STYLE_LONG = 7;
    public static final int STYLE_SHORT = 8;
    public static final int STYLE_SKIP = 9;
    static final int FORMAT_ADT_ATTR = 1;
    static final int FORMAT_COLL_ELEM = 2;
    static final int FORMAT_COLL_ELEM_NO_INDICATOR = 3;
    int nullOffset = 0;
    int ldsOffset = 0;
    int sizeForLds = 0;
    int alignForLds;
    int typeCode;
    int dbTypeCode;
    static final int KOPMAP_FLOAT = 2;
    static final int KOPMAP_SB4 = 4;
    static final int KOPMAP_PTR = 5;
    static final int KOPMAP_ORLD = 11;
    static final int KOPMAP_ORLN = 12;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jan_25_01:27:32_PST_2006";

    public OracleType() {
    }

    public OracleType(int n) {
        this();
        this.typeCode = n;
    }

    public boolean isInHierarchyOf(OracleType oracleType) throws SQLException {
        return false;
    }

    public boolean isInHierarchyOf(StructDescriptor structDescriptor) throws SQLException {
        return false;
    }

    public boolean isObjectType() {
        return false;
    }

    public TypeDescriptor getTypeDescriptor() {
        return null;
    }

    public abstract Datum toDatum(Object var1, OracleConnection var2) throws SQLException;

    public Datum[] toDatumArray(Object object, OracleConnection oracleConnection, long l, int n) throws SQLException {
        Datum[] datumArray = null;
        if (object != null) {
            if (object instanceof Object[]) {
                Object[] objectArray = (Object[])object;
                int n2 = (int)(n == -1 ? (long)objectArray.length : Math.min((long)objectArray.length - l + 1L, (long)n));
                datumArray = new Datum[n2];
                for (int i = 0; i < n2; ++i) {
                    datumArray[i] = this.toDatum(objectArray[(int)l + i - 1], oracleConnection);
                }
            } else {
                DatabaseError.throwSqlException(59, object);
            }
        }
        return datumArray;
    }

    public void setTypeCode(int n) {
        this.typeCode = n;
    }

    public int getTypeCode() throws SQLException {
        return this.typeCode;
    }

    public void setDBTypeCode(int n) {
        this.dbTypeCode = n;
    }

    public int getDBTypeCode() throws SQLException {
        return this.dbTypeCode;
    }

    public void parseTDSrec(TDSReader tDSReader) throws SQLException {
        this.nullOffset = tDSReader.nullOffset++;
        this.ldsOffset = tDSReader.ldsOffset++;
    }

    public int getSizeLDS(byte[] byArray) {
        if (this.sizeForLds == 0) {
            this.sizeForLds = Util.fdoGetSize(byArray, 5);
            this.alignForLds = Util.fdoGetAlign(byArray, 5);
        }
        return this.sizeForLds;
    }

    public int getAlignLDS(byte[] byArray) {
        if (this.sizeForLds == 0) {
            this.sizeForLds = Util.fdoGetSize(byArray, 5);
            this.alignForLds = Util.fdoGetAlign(byArray, 5);
        }
        return this.alignForLds;
    }

    protected abstract Object unpickle80rec(UnpickleContext var1, int var2, int var3, Map var4) throws SQLException;

    protected Object unpickle81rec(PickleContext pickleContext, int n, Map map) throws SQLException {
        if (n == 9) {
            pickleContext.skipDataValue();
            return null;
        }
        byte[] byArray = pickleContext.readDataValue();
        return this.toObject(byArray, n, map);
    }

    protected Object unpickle81rec(PickleContext pickleContext, byte by, int n, Map map) throws SQLException {
        if (n == 9) {
            pickleContext.skipDataValue();
            return null;
        }
        byte[] byArray = pickleContext.readDataValue(by);
        return this.toObject(byArray, n, map);
    }

    protected Datum unpickle81datumAsNull(PickleContext pickleContext, byte by, byte by2) throws SQLException {
        DatabaseError.throwSqlException(1);
        return null;
    }

    protected Object toObject(byte[] byArray, int n, Map map) throws SQLException {
        return null;
    }

    protected int pickle81(PickleContext pickleContext, Datum datum) throws SQLException {
        int n = pickleContext.writeLength((int)datum.getLength());
        return n += pickleContext.writeData(datum.shareBytes());
    }

    void writeSerializedFields(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.nullOffset);
        objectOutputStream.writeInt(this.ldsOffset);
        objectOutputStream.writeInt(this.sizeForLds);
        objectOutputStream.writeInt(this.alignForLds);
        objectOutputStream.writeInt(this.typeCode);
        objectOutputStream.writeInt(this.dbTypeCode);
    }

    void readSerializedFields(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.nullOffset = objectInputStream.readInt();
        this.ldsOffset = objectInputStream.readInt();
        this.sizeForLds = objectInputStream.readInt();
        this.alignForLds = objectInputStream.readInt();
        this.typeCode = objectInputStream.readInt();
        this.dbTypeCode = objectInputStream.readInt();
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeInt(this.nullOffset);
        objectOutputStream.writeInt(this.ldsOffset);
        objectOutputStream.writeInt(this.sizeForLds);
        objectOutputStream.writeInt(this.alignForLds);
        objectOutputStream.writeInt(this.typeCode);
        objectOutputStream.writeInt(this.dbTypeCode);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.nullOffset = objectInputStream.readInt();
        this.ldsOffset = objectInputStream.readInt();
        this.sizeForLds = objectInputStream.readInt();
        this.alignForLds = objectInputStream.readInt();
        this.typeCode = objectInputStream.readInt();
        this.dbTypeCode = objectInputStream.readInt();
    }

    public void setConnection(OracleConnection oracleConnection) throws SQLException {
    }

    public boolean isNCHAR() throws SQLException {
        return false;
    }

    public int getPrecision() throws SQLException {
        return 0;
    }

    public int getScale() throws SQLException {
        return 0;
    }

    public void initMetadataRecursively() throws SQLException {
    }

    public void initNamesRecursively() throws SQLException {
    }

    public void initChildNamesRecursively(Map map) throws SQLException {
    }

    public void cacheDescriptor() throws SQLException {
    }

    public void setNames(String string, String string2) throws SQLException {
    }

    public String toXMLString() throws SQLException {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        this.printXMLHeader(printWriter);
        this.printXML(printWriter, 0);
        return stringWriter.toString();
    }

    public void printXML(PrintStream printStream) throws SQLException {
        PrintWriter printWriter = new PrintWriter(printStream, true);
        this.printXMLHeader(printWriter);
        this.printXML(printWriter, 0);
    }

    void printXMLHeader(PrintWriter printWriter) throws SQLException {
        printWriter.println("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
    }

    public void printXML(PrintWriter printWriter, int n) throws SQLException {
        for (int i = 0; i < n; ++i) {
            printWriter.print("  ");
        }
        printWriter.println("<OracleType typecode=\"" + this.typeCode + "\"" + " hashCode=\"" + this.hashCode() + "\" " + " ldsOffset=\"" + this.ldsOffset + "\"" + " sizeForLds=\"" + this.sizeForLds + "\"" + " alignForLds=\"" + this.alignForLds + "\"" + " />");
    }
}

