/*
 * Decompiled with CFR 0.152.
 */
package oracle.jdbc.driver;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.SQLWarning;
import java.sql.Savepoint;
import java.sql.Statement;
import java.util.Calendar;
import java.util.Enumeration;
import java.util.GregorianCalendar;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import javax.transaction.xa.XAResource;
import oracle.jdbc.OracleOCIFailover;
import oracle.jdbc.OracleSavepoint;
import oracle.jdbc.driver.ArrayDataResultSet;
import oracle.jdbc.driver.ArrayLocatorResultSet;
import oracle.jdbc.driver.AutoKeyInfo;
import oracle.jdbc.driver.ByteArrayKey;
import oracle.jdbc.driver.DBConversion;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.driver.LRUStatementCache;
import oracle.jdbc.driver.LogicalConnection;
import oracle.jdbc.driver.OracleCallableStatement;
import oracle.jdbc.driver.OracleCloseCallback;
import oracle.jdbc.driver.OracleConnection;
import oracle.jdbc.driver.OracleDatabaseMetaData;
import oracle.jdbc.driver.OracleDriver;
import oracle.jdbc.driver.OracleDriverExtension;
import oracle.jdbc.driver.OraclePreparedStatement;
import oracle.jdbc.driver.OracleSql;
import oracle.jdbc.driver.OracleStatement;
import oracle.jdbc.driver.OracleTimeout;
import oracle.jdbc.driver.ResultSetUtil;
import oracle.jdbc.driver.StructMetaData;
import oracle.jdbc.oracore.OracleTypeADT;
import oracle.jdbc.oracore.OracleTypeCLOB;
import oracle.jdbc.oracore.Util;
import oracle.jdbc.pool.OracleConnectionCacheCallback;
import oracle.jdbc.pool.OracleDataSource;
import oracle.jdbc.pool.OraclePooledConnection;
import oracle.sql.ARRAY;
import oracle.sql.ArrayDescriptor;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.BfileDBAccess;
import oracle.sql.BlobDBAccess;
import oracle.sql.CLOB;
import oracle.sql.CharacterSet;
import oracle.sql.ClobDBAccess;
import oracle.sql.CustomDatum;
import oracle.sql.Datum;
import oracle.sql.StructDescriptor;
import oracle.sql.TypeDescriptor;

abstract class PhysicalConnection
extends OracleConnection {
    char[][] charOutput = new char[1][];
    byte[][] byteOutput = new byte[1][];
    short[][] shortOutput = new short[1][];
    String url;
    String user;
    String savedUser;
    String database;
    boolean autoCommitSet;
    String protocol;
    int streamChunkSize = 16384;
    public int protocolId = -3;
    OracleTimeout timeout;
    boolean spawnNewThreadToCancel = false;
    DBConversion conversion;
    boolean xaWantsError;
    boolean usingXA;
    int txnMode = 0;
    byte[] fdo;
    Boolean bigEndian;
    OracleStatement statements;
    int lifecycle;
    static final int OPEN = 1;
    static final int CLOSING = 2;
    static final int CLOSED = 4;
    static final int ABORTED = 8;
    boolean clientIdSet = false;
    String clientId = null;
    int defaultBatch;
    int defaultRowPrefetch;
    boolean reportRemarks;
    boolean includeSynonyms = false;
    boolean restrictGetTables = false;
    boolean accumulateBatchResult = true;
    boolean j2ee13Compliant = false;
    int txnLevel;
    Map map;
    Map javaObjectMap;
    Hashtable descriptorCache;
    OracleStatement statementHoldingLine;
    oracle.jdbc.OracleDatabaseMetaData databaseMetaData = null;
    LogicalConnection logicalConnectionAttached;
    boolean isProxy = false;
    boolean useFetchSizeWithLongColumn = false;
    OracleSql sqlObj = null;
    SQLWarning sqlWarning = null;
    boolean readOnly = false;
    LRUStatementCache statementCache = null;
    boolean clearStatementMetaData = false;
    boolean processEscapes = true;
    boolean defaultAutoRefetch = true;
    OracleCloseCallback closeCallback = null;
    Object privateData = null;
    boolean defaultFixedString = false;
    boolean defaultNChar = false;
    Statement savepointStatement = null;
    static final int[] endToEndMaxLength = new int[4];
    boolean endToEndAnyChanged = false;
    final boolean[] endToEndHasChanged = new boolean[4];
    short endToEndECIDSequenceNumber = Short.MIN_VALUE;
    String[] endToEndValues = null;
    final boolean useDMSForEndToEnd = this.endToEndValues != null;
    oracle.jdbc.OracleConnection wrapper = null;
    Properties connectionProperties = null;
    boolean wellBehavedStatementReuse = false;
    int minVcsBindSize;
    int maxRawBytesSql;
    int maxRawBytesPlsql;
    int maxVcsCharsSql;
    int maxVcsBytesPlsql;
    OracleDriverExtension driverExtension;
    static final String uninitializedMarker = "";
    String databaseProductVersion = "";
    short versionNumber = (short)-1;
    boolean v8Compatible;
    boolean looseTimestampDateCheck = false;
    boolean isMemoryFreedOnEnteringCache = false;
    String ressourceManagerId = "0000";
    int namedTypeAccessorByteLen;
    int refTypeAccessorByteLen;
    boolean disableDefineColumnType = false;
    boolean convertNcharLiterals = true;
    CharacterSet setCHARCharSetObj;
    CharacterSet setCHARNCharSetObj;
    boolean plsqlCompilerWarnings = false;
    static final String DATABASE_NAME = "DATABASE_NAME";
    static final String SERVER_HOST = "SERVER_HOST";
    static final String INSTANCE_NAME = "INSTANCE_NAME";
    static final String SERVICE_NAME = "SERVICE_NAME";
    Hashtable clientData;
    String sessionTimeZone = null;
    Calendar dbTzCalendar = null;
    private static final String _Copyright_2004_Oracle_All_Rights_Reserved_;
    public static final boolean TRACE = false;
    public static final boolean PRIVATE_TRACE = false;
    public static final String BUILD_DATE = "Wed_Jan_25_01:27:35_PST_2006";

    PhysicalConnection() {
    }

    PhysicalConnection(String string, String string2, String string3, String string4, Properties properties, OracleDriverExtension oracleDriverExtension) throws SQLException {
        String string5;
        this.driverExtension = oracleDriverExtension;
        String string6 = null;
        if (properties != null) {
            string6 = (String)properties.get("protocol");
            String string7 = properties.getProperty("processEscapes");
            if (string7 != null && string7.equalsIgnoreCase("false")) {
                this.processEscapes = false;
            }
            if ((string5 = (String)properties.get("RessourceManagerId")) != null) {
                this.ressourceManagerId = string5;
            }
            this.connectionProperties = (Properties)properties.clone();
        }
        this.initialize(string, string2, string6, null, null, null, string4);
        this.initializePassword(string3);
        this.logicalConnectionAttached = null;
        try {
            String string8;
            this.needLine();
            this.logon();
            boolean bl = true;
            if (properties != null) {
                string5 = properties.getProperty("autoCommit");
                if (string5 != null && string5.equalsIgnoreCase("false")) {
                    bl = false;
                }
                if ((string5 = this.connectionProperties.getProperty("wellBehavedStatementReuse")) != null && string5.equalsIgnoreCase("true")) {
                    this.wellBehavedStatementReuse = true;
                }
            }
            this.setAutoCommit(bl);
            if (this.getVersionNumber() >= 10000) {
                this.minVcsBindSize = 4001;
                this.maxRawBytesSql = 2000;
                this.maxRawBytesPlsql = 32512;
                this.maxVcsCharsSql = 32766;
                this.maxVcsBytesPlsql = 32512;
            } else if (this.getVersionNumber() >= 9200) {
                this.minVcsBindSize = 4001;
                this.maxRawBytesSql = 2000;
                this.maxRawBytesPlsql = 32512;
                this.maxVcsCharsSql = 32766;
                this.maxVcsBytesPlsql = 32512;
            } else {
                this.minVcsBindSize = 4001;
                this.maxRawBytesSql = 2000;
                this.maxRawBytesPlsql = 2000;
                this.maxVcsCharsSql = 4000;
                this.maxVcsBytesPlsql = 4000;
            }
            String string9 = string5 = properties != null ? properties.getProperty("oracle.jdbc.V8Compatible") : null;
            if (string5 == null) {
                string5 = OracleDriver.getSystemPropertyV8Compatible();
            }
            if (string5 != null) {
                this.v8Compatible = string5.equalsIgnoreCase("true");
            }
            String string10 = string8 = properties != null ? properties.getProperty("oracle.jdbc.StreamChunkSize") : null;
            if (string8 != null) {
                this.streamChunkSize = Math.max(4096, Integer.parseInt(string8));
            }
            String string11 = string8 = properties != null ? properties.getProperty("oracle.jdbc.internal.permitBindDateDefineTimestampMismatch") : null;
            if (string8 != null && string8.equalsIgnoreCase("true")) {
                this.looseTimestampDateCheck = true;
            }
            string8 = properties != null ? properties.getProperty("oracle.jdbc.FreeMemoryOnEnterImplicitCache") : null;
            this.isMemoryFreedOnEnteringCache = string8 != null && string8.equalsIgnoreCase("true");
            this.initializeSetCHARCharSetObjs();
            this.spawnNewThreadToCancel = "true".equalsIgnoreCase(properties.getProperty("oracle.jdbc.spawnNewThreadToCancel"));
        }
        catch (SQLException sQLException) {
            try {
                this.logoff();
            }
            catch (SQLException sQLException2) {
                // empty catch block
            }
            throw sQLException;
        }
        this.txnMode = 0;
    }

    abstract void initializePassword(String var1) throws SQLException;

    public Properties getProperties() {
        return OracleDataSource.filterConnectionProperties(this.connectionProperties);
    }

    public synchronized Connection _getPC() {
        return null;
    }

    public synchronized oracle.jdbc.internal.OracleConnection getPhysicalConnection() {
        return this;
    }

    public synchronized boolean isLogicalConnection() {
        return false;
    }

    void initialize(String string, String string2, String string3, Hashtable hashtable, Map map, Map map2, String string4) throws SQLException {
        this.clearStatementMetaData = false;
        this.database = string4;
        this.url = string;
        this.user = string2 == null || string2.startsWith("\"") ? string2 : string2.toUpperCase();
        this.protocol = string3;
        this.defaultRowPrefetch = DEFAULT_ROW_PREFETCH;
        this.defaultBatch = 1;
        this.descriptorCache = hashtable != null ? hashtable : new Hashtable(10);
        this.map = map;
        this.javaObjectMap = map2 != null ? map2 : new Hashtable(10);
        this.lifecycle = 1;
        this.txnLevel = 2;
        this.xaWantsError = false;
        this.usingXA = false;
        this.clientIdSet = false;
    }

    void initializeSetCHARCharSetObjs() {
        this.setCHARNCharSetObj = this.conversion.getDriverNCharSetObj();
        this.setCHARCharSetObj = this.conversion.getDriverCharSetObj();
    }

    OracleTimeout getTimeout() throws SQLException {
        if (this.timeout == null) {
            this.timeout = OracleTimeout.newTimeout(this.url);
        }
        return this.timeout;
    }

    public synchronized Statement createStatement() throws SQLException {
        return this.createStatement(-1, -1);
    }

    public synchronized Statement createStatement(int n, int n2) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        OracleStatement oracleStatement = null;
        oracleStatement = this.driverExtension.allocateStatement(this, n, n2);
        return oracleStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string) throws SQLException {
        return this.prepareStatement(string, -1, -1);
    }

    public synchronized PreparedStatement prepareStatementWithKey(String string) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if (string == null) {
            return null;
        }
        if (!this.isStatementCacheInitialized()) {
            DatabaseError.throwSqlException(95);
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        oraclePreparedStatement = (OraclePreparedStatement)this.statementCache.searchExplicitCache(string);
        return oraclePreparedStatement;
    }

    public synchronized PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        if (string == null || string == uninitializedMarker) {
            DatabaseError.throwSqlException(104);
        }
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        OraclePreparedStatement oraclePreparedStatement = null;
        if (this.statementCache != null) {
            oraclePreparedStatement = (OraclePreparedStatement)this.statementCache.searchImplicitCache(string, 1, n != -1 || n2 != -1 ? ResultSetUtil.getRsetTypeCode(n, n2) : 1);
        }
        if (oraclePreparedStatement == null) {
            oraclePreparedStatement = this.driverExtension.allocatePreparedStatement(this, string, n, n2);
        }
        return oraclePreparedStatement;
    }

    public synchronized CallableStatement prepareCall(String string) throws SQLException {
        return this.prepareCall(string, -1, -1);
    }

    public synchronized CallableStatement prepareCall(String string, int n, int n2) throws SQLException {
        if (string == null || string == uninitializedMarker) {
            DatabaseError.throwSqlException(104);
        }
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        OracleCallableStatement oracleCallableStatement = null;
        if (this.statementCache != null) {
            oracleCallableStatement = (OracleCallableStatement)this.statementCache.searchImplicitCache(string, 2, n != -1 || n2 != -1 ? ResultSetUtil.getRsetTypeCode(n, n2) : 1);
        }
        if (oracleCallableStatement == null) {
            oracleCallableStatement = this.driverExtension.allocateCallableStatement(this, string, n, n2);
        }
        return oracleCallableStatement;
    }

    public synchronized CallableStatement prepareCallWithKey(String string) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if (string == null) {
            return null;
        }
        if (!this.isStatementCacheInitialized()) {
            DatabaseError.throwSqlException(95);
        }
        OracleCallableStatement oracleCallableStatement = null;
        oracleCallableStatement = (OracleCallableStatement)this.statementCache.searchExplicitCache(string);
        return oracleCallableStatement;
    }

    public String nativeSQL(String string) throws SQLException {
        if (this.sqlObj == null) {
            this.sqlObj = new OracleSql(this.conversion);
            this.sqlObj.isV8Compatible = this.v8Compatible;
        }
        this.sqlObj.initialize(string);
        String string2 = this.sqlObj.getSql(this.processEscapes, this.convertNcharLiterals);
        return string2;
    }

    public synchronized void setAutoCommit(boolean bl) throws SQLException {
        if (bl) {
            this.disallowGlobalTxnMode(116);
        }
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        this.needLine();
        this.doSetAutoCommit(bl);
        this.autoCommitSet = bl;
    }

    public boolean getAutoCommit() throws SQLException {
        return this.autoCommitSet;
    }

    public void cancel() throws SQLException {
        OracleStatement oracleStatement = this.statements;
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        while (oracleStatement != null) {
            try {
                oracleStatement.cancel();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
            oracleStatement = oracleStatement.next;
        }
    }

    public synchronized void commit() throws SQLException {
        this.disallowGlobalTxnMode(114);
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        OracleStatement oracleStatement = this.statements;
        while (oracleStatement != null) {
            if (!oracleStatement.closed) {
                oracleStatement.sendBatch();
            }
            oracleStatement = oracleStatement.next;
        }
        this.needLine();
        this.doCommit();
    }

    public synchronized void rollback() throws SQLException {
        this.disallowGlobalTxnMode(115);
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        this.needLine();
        this.doRollback();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws SQLException {
        if (this.lifecycle == 2 || this.lifecycle == 4) {
            return;
        }
        if (this.lifecycle == 1) {
            this.lifecycle = 2;
        }
        try {
            if (this.closeCallback != null) {
                this.closeCallback.beforeClose(this, this.privateData);
            }
            this.closeStatements(true);
            this.needLine();
            if (this.isProxy) {
                this.close(1);
            }
            this.logoff();
            this.cleanup();
            if (this.timeout != null) {
                this.timeout.close();
            }
            if (this.closeCallback != null) {
                this.closeCallback.afterClose(this.privateData);
            }
        }
        finally {
            this.lifecycle = 4;
        }
    }

    public void closeInternal(boolean bl) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    synchronized void closeLogicalConnection() throws SQLException {
        this.closeStatements(false);
        if (this.clientIdSet) {
            this.clearClientIdentifier(this.clientId);
        }
        this.logicalConnectionAttached = null;
    }

    public synchronized void close(Properties properties) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public synchronized void close(int n) throws SQLException {
        if ((n & 0x1000) != 0) {
            this.close();
            return;
        }
        if ((n & 1) != 0 && this.isProxy) {
            this.closeProxySession();
            this.isProxy = false;
        }
    }

    public void abort() throws SQLException {
        if (this.lifecycle == 4 || this.lifecycle == 8) {
            return;
        }
        this.lifecycle = 8;
        this.doAbort();
    }

    abstract void doAbort() throws SQLException;

    void closeProxySession() throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    public Properties getServerSessionInfo() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public synchronized void applyConnectionAttributes(Properties properties) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public synchronized Properties getConnectionAttributes() throws SQLException {
        DatabaseError.throwSqlException(152);
        return null;
    }

    public synchronized Properties getUnMatchedConnectionAttributes() throws SQLException {
        DatabaseError.throwSqlException(152);
        return null;
    }

    public synchronized void setAbandonedTimeoutEnabled(boolean bl) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public synchronized void registerConnectionCacheCallback(OracleConnectionCacheCallback oracleConnectionCacheCallback, Object object, int n) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public OracleConnectionCacheCallback getConnectionCacheCallbackObj() throws SQLException {
        DatabaseError.throwSqlException(152);
        return null;
    }

    public Object getConnectionCacheCallbackPrivObj() throws SQLException {
        DatabaseError.throwSqlException(152);
        return null;
    }

    public int getConnectionCacheCallbackFlag() throws SQLException {
        DatabaseError.throwSqlException(152);
        return 0;
    }

    public synchronized void setConnectionReleasePriority(int n) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public int getConnectionReleasePriority() throws SQLException {
        DatabaseError.throwSqlException(152);
        return 0;
    }

    public synchronized boolean isClosed() throws SQLException {
        return this.lifecycle != 1;
    }

    public synchronized boolean isProxySession() {
        return this.isProxy;
    }

    public synchronized void openProxySession(int n, Properties properties) throws SQLException {
        if (this.isProxy) {
            DatabaseError.throwSqlException(149);
        }
        String string = properties.getProperty("PROXY_USER_NAME");
        String string2 = properties.getProperty("PROXY_USER_PASSWORD");
        String string3 = properties.getProperty("PROXY_DISTINGUISHED_NAME");
        Object object = properties.get("PROXY_CERTIFICATE");
        if (n == 1) {
            if (string == null && string2 == null) {
                DatabaseError.throwSqlException(150);
            }
        } else if (n == 2) {
            if (string3 == null) {
                DatabaseError.throwSqlException(150);
            }
        } else if (n == 3) {
            if (object == null) {
                DatabaseError.throwSqlException(150);
            }
            try {
                byte[] byArray = (byte[])object;
            }
            catch (ClassCastException classCastException) {
                DatabaseError.throwSqlException(150);
            }
        } else {
            DatabaseError.throwSqlException(150);
        }
        this.doProxySession(n, properties);
    }

    void doProxySession(int n, Properties properties) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    void cleanup() {
        this.fdo = null;
        this.conversion = null;
        this.statements = null;
        this.descriptorCache = null;
        this.map = null;
        this.javaObjectMap = null;
        this.statementHoldingLine = null;
        this.sqlObj = null;
        this.isProxy = false;
    }

    public synchronized DatabaseMetaData getMetaData() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        if (this.databaseMetaData == null) {
            this.databaseMetaData = new OracleDatabaseMetaData(this);
        }
        return this.databaseMetaData;
    }

    public void setReadOnly(boolean bl) throws SQLException {
        this.readOnly = bl;
    }

    public boolean isReadOnly() throws SQLException {
        return this.readOnly;
    }

    public void setCatalog(String string) throws SQLException {
    }

    public String getCatalog() throws SQLException {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public synchronized void setTransactionIsolation(int n) throws SQLException {
        OracleStatement oracleStatement = (OracleStatement)this.createStatement();
        try {
            switch (n) {
                case 2: {
                    oracleStatement.execute("ALTER SESSION SET ISOLATION_LEVEL = READ COMMITTED");
                    this.txnLevel = 2;
                    return;
                }
                case 8: {
                    oracleStatement.execute("ALTER SESSION SET ISOLATION_LEVEL = SERIALIZABLE");
                    this.txnLevel = 8;
                    return;
                }
                default: {
                    DatabaseError.throwSqlException(30);
                    return;
                }
            }
        }
        finally {
            oracleStatement.close();
        }
    }

    public int getTransactionIsolation() throws SQLException {
        return this.txnLevel;
    }

    public synchronized void setAutoClose(boolean bl) throws SQLException {
        if (!bl) {
            DatabaseError.throwSqlException(31);
        }
    }

    public boolean getAutoClose() throws SQLException {
        return true;
    }

    public SQLWarning getWarnings() throws SQLException {
        return this.sqlWarning;
    }

    public void clearWarnings() throws SQLException {
        this.sqlWarning = null;
    }

    public void setWarnings(SQLWarning sQLWarning) {
        this.sqlWarning = sQLWarning;
    }

    public void setDefaultRowPrefetch(int n) throws SQLException {
        if (n <= 0) {
            DatabaseError.throwSqlException(20);
        }
        this.defaultRowPrefetch = n;
    }

    public int getDefaultRowPrefetch() {
        return this.defaultRowPrefetch;
    }

    public synchronized void setDefaultExecuteBatch(int n) throws SQLException {
        if (n <= 0) {
            DatabaseError.throwSqlException(42);
        }
        this.defaultBatch = n;
    }

    public synchronized int getDefaultExecuteBatch() {
        return this.defaultBatch;
    }

    public synchronized void setRemarksReporting(boolean bl) {
        this.reportRemarks = bl;
    }

    public synchronized boolean getRemarksReporting() {
        return this.reportRemarks;
    }

    public void setIncludeSynonyms(boolean bl) {
        this.includeSynonyms = bl;
    }

    public synchronized String[] getEndToEndMetrics() throws SQLException {
        String[] stringArray;
        if (this.endToEndValues == null) {
            stringArray = null;
        } else {
            stringArray = new String[this.endToEndValues.length];
            System.arraycopy(this.endToEndValues, 0, stringArray, 0, this.endToEndValues.length);
        }
        return stringArray;
    }

    public short getEndToEndECIDSequenceNumber() throws SQLException {
        return this.endToEndECIDSequenceNumber;
    }

    public synchronized void setEndToEndMetrics(String[] stringArray, short s) throws SQLException {
        if (!this.useDMSForEndToEnd) {
            String[] stringArray2 = new String[stringArray.length];
            System.arraycopy(stringArray, 0, stringArray2, 0, stringArray.length);
            this.setEndToEndMetricsInternal(stringArray2, s);
        }
    }

    void setEndToEndMetricsInternal(String[] stringArray, short s) throws SQLException {
        if (stringArray != this.endToEndValues) {
            String string;
            int n;
            if (stringArray.length != 4) {
                DatabaseError.throwSqlException(156);
            }
            for (n = 0; n < 4; ++n) {
                string = stringArray[n];
                if (string == null || string.length() <= endToEndMaxLength[n]) continue;
                DatabaseError.throwSqlException(159, string);
            }
            if (this.endToEndValues != null) {
                for (n = 0; n < 4; ++n) {
                    string = stringArray[n];
                    if ((string != null || this.endToEndValues[n] == null) && (string == null || string.equals(this.endToEndValues[n]))) continue;
                    this.endToEndHasChanged[n] = true;
                    this.endToEndAnyChanged = true;
                }
                this.endToEndHasChanged[0] = this.endToEndHasChanged[0] | this.endToEndHasChanged[3];
            } else {
                for (n = 0; n < 4; ++n) {
                    this.endToEndHasChanged[n] = true;
                }
                this.endToEndAnyChanged = true;
            }
            this.endToEndValues = stringArray;
        }
        this.endToEndECIDSequenceNumber = s;
    }

    void updateEndToEndMetrics() throws SQLException {
    }

    public boolean getIncludeSynonyms() {
        return this.includeSynonyms;
    }

    public void setRestrictGetTables(boolean bl) {
        this.restrictGetTables = bl;
    }

    public boolean getRestrictGetTables() {
        return this.restrictGetTables;
    }

    public void setDefaultFixedString(boolean bl) {
        this.defaultFixedString = bl;
    }

    public void setDefaultNChar(boolean bl) {
        this.defaultNChar = bl;
    }

    public boolean getDefaultFixedString() {
        return this.defaultFixedString;
    }

    public int getNlsRatio() {
        return 1;
    }

    public int getC2SNlsRatio() {
        return 1;
    }

    synchronized void addStatement(OracleStatement oracleStatement) {
        if (oracleStatement.next != null) {
            throw new Error("add_statement called twice on " + oracleStatement);
        }
        oracleStatement.next = this.statements;
        if (this.statements != null) {
            this.statements.prev = oracleStatement;
        }
        this.statements = oracleStatement;
    }

    synchronized void removeStatement(OracleStatement oracleStatement) {
        OracleStatement oracleStatement2 = oracleStatement.prev;
        OracleStatement oracleStatement3 = oracleStatement.next;
        if (oracleStatement2 == null) {
            if (this.statements != oracleStatement) {
                return;
            }
            this.statements = oracleStatement3;
        } else {
            oracleStatement2.next = oracleStatement3;
        }
        if (oracleStatement3 != null) {
            oracleStatement3.prev = oracleStatement2;
        }
        oracleStatement.next = null;
        oracleStatement.prev = null;
    }

    synchronized void closeStatements(boolean bl) throws SQLException {
        OracleStatement oracleStatement;
        if (bl && this.isStatementCacheInitialized()) {
            this.statementCache.close();
            this.statementCache = null;
            this.clearStatementMetaData = true;
        }
        OracleStatement oracleStatement2 = this.statements;
        while (oracleStatement2 != null) {
            oracleStatement = oracleStatement2.nextChild;
            if (oracleStatement2.serverCursor) {
                oracleStatement2.close();
                this.removeStatement(oracleStatement2);
            }
            oracleStatement2 = oracleStatement;
        }
        oracleStatement2 = this.statements;
        while (oracleStatement2 != null) {
            oracleStatement = oracleStatement2.next;
            oracleStatement2.close();
            this.removeStatement(oracleStatement2);
            oracleStatement2 = oracleStatement;
        }
    }

    synchronized void needLine() throws SQLException {
        if (this.statementHoldingLine != null) {
            this.statementHoldingLine.freeLine();
        }
    }

    synchronized void holdLine(oracle.jdbc.internal.OracleStatement oracleStatement) {
        this.holdLine((OracleStatement)oracleStatement);
    }

    synchronized void holdLine(OracleStatement oracleStatement) {
        this.statementHoldingLine = oracleStatement;
    }

    synchronized void releaseLine() {
        this.releaseLineForCancel();
    }

    void releaseLineForCancel() {
        this.statementHoldingLine = null;
    }

    public synchronized void startup(String string, int n) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        DatabaseError.throwSqlException(23);
    }

    public synchronized void shutdown(int n) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        DatabaseError.throwSqlException(23);
    }

    public synchronized void archive(int n, int n2, String string) throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        DatabaseError.throwSqlException(23);
    }

    public synchronized void registerSQLType(String string, String string2) throws SQLException {
        if (string == null || string2 == null) {
            DatabaseError.throwSqlException(68);
        }
        try {
            this.registerSQLType(string, Class.forName(string2));
        }
        catch (ClassNotFoundException classNotFoundException) {
            DatabaseError.throwSqlException(1, "Class not found: " + string2);
        }
    }

    public synchronized void registerSQLType(String string, Class clazz) throws SQLException {
        if (string == null || clazz == null) {
            DatabaseError.throwSqlException(68);
        }
        this.ensureClassMapExists();
        this.map.put(string, clazz);
        this.map.put(clazz.getName(), string);
    }

    void ensureClassMapExists() {
        if (this.map == null) {
            this.initializeClassMap();
        }
    }

    void initializeClassMap() {
        Hashtable hashtable = new Hashtable(10);
        this.addDefaultClassMapEntriesTo(hashtable);
        this.map = hashtable;
    }

    public synchronized String getSQLType(Object object) throws SQLException {
        if (object != null && this.map != null) {
            String string = object.getClass().getName();
            return (String)this.map.get(string);
        }
        return null;
    }

    public synchronized Object getJavaObject(String string) throws SQLException {
        Object var2_2 = null;
        try {
            if (string != null && this.map != null) {
                Class clazz = (Class)this.map.get(string);
                var2_2 = clazz.newInstance();
            }
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
        }
        catch (InstantiationException instantiationException) {
            instantiationException.printStackTrace();
        }
        return var2_2;
    }

    public synchronized void putDescriptor(String string, Object object) throws SQLException {
        if (string != null && object != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            ((TypeDescriptor)object).fixupConnection(this);
            this.descriptorCache.put(string, object);
        } else {
            DatabaseError.throwSqlException(68);
        }
    }

    public synchronized Object getDescriptor(String string) {
        Object var2_2 = null;
        if (string != null && this.descriptorCache != null) {
            var2_2 = this.descriptorCache.get(string);
        }
        return var2_2;
    }

    public synchronized void removeDecriptor(String string) {
        this.removeDescriptor(string);
    }

    public synchronized void removeDescriptor(String string) {
        if (string != null && this.descriptorCache != null) {
            this.descriptorCache.remove(string);
        }
    }

    public synchronized void removeAllDescriptor() {
        if (this.descriptorCache != null) {
            this.descriptorCache.clear();
        }
    }

    public int numberOfDescriptorCacheEntries() {
        if (this.descriptorCache != null) {
            return this.descriptorCache.size();
        }
        return 0;
    }

    public Enumeration descriptorCacheKeys() {
        if (this.descriptorCache != null) {
            return this.descriptorCache.keys();
        }
        return null;
    }

    public synchronized void putDescriptor(byte[] byArray, Object object) throws SQLException {
        if (byArray != null && object != null) {
            if (this.descriptorCache == null) {
                this.descriptorCache = new Hashtable(10);
            }
            this.descriptorCache.put(new ByteArrayKey(byArray), object);
        } else {
            DatabaseError.throwSqlException(68);
        }
    }

    public synchronized Object getDescriptor(byte[] byArray) {
        Object var2_2 = null;
        if (byArray != null && this.descriptorCache != null) {
            var2_2 = this.descriptorCache.get(new ByteArrayKey(byArray));
        }
        return var2_2;
    }

    public synchronized void removeDecriptor(byte[] byArray) {
        if (byArray != null && this.descriptorCache != null) {
            this.descriptorCache.remove(new ByteArrayKey(byArray));
        }
    }

    public short getJdbcCsId() throws SQLException {
        if (this.conversion == null) {
            DatabaseError.throwSqlException(65);
        }
        return this.conversion.getClientCharSet();
    }

    public short getDbCsId() throws SQLException {
        if (this.conversion == null) {
            DatabaseError.throwSqlException(65);
        }
        return this.conversion.getServerCharSetId();
    }

    public short getNCsId() throws SQLException {
        if (this.conversion == null) {
            DatabaseError.throwSqlException(65);
        }
        return this.conversion.getNCharSetId();
    }

    public short getStructAttrCsId() throws SQLException {
        return this.getDbCsId();
    }

    public short getStructAttrNCsId() throws SQLException {
        return this.getNCsId();
    }

    public synchronized Map getTypeMap() {
        this.ensureClassMapExists();
        return this.map;
    }

    public synchronized void setTypeMap(Map map) {
        this.addDefaultClassMapEntriesTo(map);
        this.map = map;
    }

    void addDefaultClassMapEntriesTo(Map map) {
        if (map != null) {
            this.addClassMapEntry("SYS.XMLTYPE", "oracle.xdb.XMLTypeFactory", map);
        }
    }

    void addClassMapEntry(String string, String string2, Map map) {
        if (PhysicalConnection.containsKey(map, string)) {
            return;
        }
        try {
            Class clazz = this.safelyGetClassForName(string2);
            map.put(string, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }

    public synchronized void setUsingXAFlag(boolean bl) {
        this.usingXA = bl;
    }

    public synchronized boolean getUsingXAFlag() {
        return this.usingXA;
    }

    public synchronized void setXAErrorFlag(boolean bl) {
        this.xaWantsError = bl;
    }

    public synchronized boolean getXAErrorFlag() {
        return this.xaWantsError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void initUserName() throws SQLException {
        ResultSet resultSet;
        Statement statement;
        block7: {
            if (this.user != null) {
                return;
            }
            statement = null;
            resultSet = null;
            try {
                statement = this.createStatement();
                ((OracleStatement)statement).setRowPrefetch(1);
                resultSet = statement.executeQuery("SELECT USER FROM DUAL");
                if (resultSet.next()) {
                    this.user = resultSet.getString(1);
                }
                Object var4_3 = null;
                if (resultSet == null) break block7;
            }
            catch (Throwable throwable) {
                Object var4_4 = null;
                if (resultSet != null) {
                    resultSet.close();
                }
                if (statement != null) {
                    statement.close();
                }
                resultSet = null;
                statement = null;
                throw throwable;
            }
            resultSet.close();
        }
        if (statement != null) {
            statement.close();
        }
        resultSet = null;
        statement = null;
    }

    public synchronized String getUserName() throws SQLException {
        if (this.user == null) {
            this.initUserName();
        }
        return this.user;
    }

    public synchronized void setStartTime(long l) throws SQLException {
        DatabaseError.throwSqlException(152);
    }

    public synchronized long getStartTime() throws SQLException {
        DatabaseError.throwSqlException(152);
        return -1L;
    }

    void registerHeartbeat() throws SQLException {
        if (this.logicalConnectionAttached != null) {
            this.logicalConnectionAttached.registerHeartbeat();
        }
    }

    public int getHeartbeatNoChangeCount() throws SQLException {
        DatabaseError.throwSqlException(152);
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized byte[] getFDO(boolean bl) throws SQLException {
        if (this.fdo == null && bl) {
            CallableStatement callableStatement;
            block4: {
                callableStatement = null;
                try {
                    callableStatement = this.prepareCall("begin ? := dbms_pickler.get_format (?); end;");
                    callableStatement.registerOutParameter(1, 2);
                    callableStatement.registerOutParameter(2, -4);
                    callableStatement.execute();
                    this.fdo = callableStatement.getBytes(2);
                    Object var4_3 = null;
                    if (callableStatement == null) break block4;
                }
                catch (Throwable throwable) {
                    Object var4_4 = null;
                    if (callableStatement != null) {
                        callableStatement.close();
                    }
                    callableStatement = null;
                    throw throwable;
                }
                callableStatement.close();
            }
            callableStatement = null;
            {
            }
        }
        return this.fdo;
    }

    public synchronized void setFDO(byte[] byArray) throws SQLException {
        this.fdo = byArray;
    }

    public synchronized boolean getBigEndian() throws SQLException {
        if (this.bigEndian == null) {
            int[] nArray = Util.toJavaUnsignedBytes(this.getFDO(true));
            int n = nArray[6 + nArray[5] + nArray[6] + 5];
            int n2 = n & 0x10;
            if (n2 < 0) {
                n2 += 256;
            }
            this.bigEndian = n2 > 0 ? new Boolean(true) : new Boolean(false);
        }
        return this.bigEndian;
    }

    public void setHoldability(int n) throws SQLException {
    }

    public int getHoldability() throws SQLException {
        return 1;
    }

    public synchronized Savepoint setSavepoint() throws SQLException {
        return this.oracleSetSavepoint();
    }

    public synchronized Savepoint setSavepoint(String string) throws SQLException {
        return this.oracleSetSavepoint(string);
    }

    public synchronized void rollback(Savepoint savepoint) throws SQLException {
        this.disallowGlobalTxnMode(122);
        if (this.autoCommitSet) {
            DatabaseError.throwSqlException(121);
        }
        if (this.savepointStatement == null || ((OracleStatement)this.savepointStatement).closed) {
            this.savepointStatement = this.createStatement();
        }
        String string = null;
        try {
            string = savepoint.getSavepointName();
        }
        catch (SQLException sQLException) {
            string = "ORACLE_SVPT_" + savepoint.getSavepointId();
        }
        this.savepointStatement.executeUpdate("ROLLBACK TO " + string);
    }

    public synchronized void releaseSavepoint(Savepoint savepoint) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        return this.createStatement(n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return this.prepareStatement(string, n, n2);
    }

    public CallableStatement prepareCall(String string, int n, int n2, int n3) throws SQLException {
        return this.prepareCall(string, n, n2);
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        if (n == 2 || !AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.prepareStatement(string);
        }
        if (n != 1) {
            DatabaseError.throwSqlException(68);
        }
        AutoKeyInfo autoKeyInfo = new AutoKeyInfo(string);
        String string2 = autoKeyInfo.getNewSql();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.prepareStatement(string2);
        oraclePreparedStatement.isAutoGeneratedKey = true;
        oraclePreparedStatement.autoKeyInfo = autoKeyInfo;
        oraclePreparedStatement.registerReturnParamsForAutoKey();
        return oraclePreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.prepareStatement(string);
        }
        if (nArray == null || nArray.length == 0) {
            DatabaseError.throwSqlException(68);
        }
        AutoKeyInfo autoKeyInfo = new AutoKeyInfo(string, nArray);
        this.doDescribeTable(autoKeyInfo);
        String string2 = autoKeyInfo.getNewSql();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.prepareStatement(string2);
        oraclePreparedStatement.isAutoGeneratedKey = true;
        oraclePreparedStatement.autoKeyInfo = autoKeyInfo;
        oraclePreparedStatement.registerReturnParamsForAutoKey();
        return oraclePreparedStatement;
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        if (!AutoKeyInfo.isInsertSqlStmt(string)) {
            return this.prepareStatement(string);
        }
        if (stringArray == null || stringArray.length == 0) {
            DatabaseError.throwSqlException(68);
        }
        AutoKeyInfo autoKeyInfo = new AutoKeyInfo(string, stringArray);
        this.doDescribeTable(autoKeyInfo);
        String string2 = autoKeyInfo.getNewSql();
        OraclePreparedStatement oraclePreparedStatement = (OraclePreparedStatement)this.prepareStatement(string2);
        oraclePreparedStatement.isAutoGeneratedKey = true;
        oraclePreparedStatement.autoKeyInfo = autoKeyInfo;
        oraclePreparedStatement.registerReturnParamsForAutoKey();
        return oraclePreparedStatement;
    }

    public synchronized OracleSavepoint oracleSetSavepoint() throws SQLException {
        this.disallowGlobalTxnMode(117);
        if (this.autoCommitSet) {
            DatabaseError.throwSqlException(120);
        }
        if (this.savepointStatement == null || ((OracleStatement)this.savepointStatement).closed) {
            this.savepointStatement = this.createStatement();
        }
        oracle.jdbc.driver.OracleSavepoint oracleSavepoint = new oracle.jdbc.driver.OracleSavepoint();
        String string = "SAVEPOINT ORACLE_SVPT_" + oracleSavepoint.getSavepointId();
        this.savepointStatement.executeUpdate(string);
        return oracleSavepoint;
    }

    public synchronized OracleSavepoint oracleSetSavepoint(String string) throws SQLException {
        this.disallowGlobalTxnMode(117);
        if (this.autoCommitSet) {
            DatabaseError.throwSqlException(120);
        }
        if (this.savepointStatement == null || ((OracleStatement)this.savepointStatement).closed) {
            this.savepointStatement = this.createStatement();
        }
        oracle.jdbc.driver.OracleSavepoint oracleSavepoint = new oracle.jdbc.driver.OracleSavepoint(string);
        String string2 = "SAVEPOINT " + oracleSavepoint.getSavepointName();
        this.savepointStatement.executeUpdate(string2);
        return oracleSavepoint;
    }

    public synchronized void oracleRollback(OracleSavepoint oracleSavepoint) throws SQLException {
        this.disallowGlobalTxnMode(115);
        if (this.autoCommitSet) {
            DatabaseError.throwSqlException(121);
        }
        if (this.savepointStatement == null || ((OracleStatement)this.savepointStatement).closed) {
            this.savepointStatement = this.createStatement();
        }
        String string = null;
        try {
            string = oracleSavepoint.getSavepointName();
        }
        catch (SQLException sQLException) {
            string = "ORACLE_SVPT_" + oracleSavepoint.getSavepointId();
        }
        this.savepointStatement.executeUpdate("ROLLBACK TO " + string);
    }

    public synchronized void oracleReleaseSavepoint(OracleSavepoint oracleSavepoint) throws SQLException {
        DatabaseError.throwUnsupportedFeatureSqlException();
    }

    void disallowGlobalTxnMode(int n) throws SQLException {
        if (this.txnMode == 1) {
            DatabaseError.throwSqlException(n);
        }
    }

    public void setTxnMode(int n) {
        this.txnMode = n;
    }

    public int getTxnMode() {
        return this.txnMode;
    }

    public synchronized Object getClientData(Object object) {
        if (this.clientData == null) {
            return null;
        }
        return this.clientData.get(object);
    }

    public synchronized Object setClientData(Object object, Object object2) {
        if (this.clientData == null) {
            this.clientData = new Hashtable();
        }
        return this.clientData.put(object, object2);
    }

    public synchronized Object removeClientData(Object object) {
        if (this.clientData == null) {
            return null;
        }
        return this.clientData.remove(object);
    }

    public BlobDBAccess createBlobDBAccess() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public ClobDBAccess createClobDBAccess() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public BfileDBAccess createBfileDBAccess() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public void printState() {
        try {
            short s = this.getJdbcCsId();
            short s2 = this.getDbCsId();
            short s3 = this.getStructAttrCsId();
        }
        catch (SQLException sQLException) {
            sQLException.printStackTrace();
        }
    }

    public String getProtocolType() {
        return this.protocol;
    }

    public String getURL() {
        return this.url;
    }

    public synchronized void setStmtCacheSize(int n) throws SQLException {
        this.setStatementCacheSize(n);
        this.setImplicitCachingEnabled(true);
        this.setExplicitCachingEnabled(true);
    }

    public synchronized void setStmtCacheSize(int n, boolean bl) throws SQLException {
        this.setStatementCacheSize(n);
        this.setImplicitCachingEnabled(true);
        this.setExplicitCachingEnabled(true);
        this.clearStatementMetaData = bl;
    }

    public synchronized int getStmtCacheSize() {
        int n = 0;
        try {
            n = this.getStatementCacheSize();
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
        if (n == -1) {
            n = 0;
        }
        return n;
    }

    public synchronized void setStatementCacheSize(int n) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(n);
        } else {
            this.statementCache.resize(n);
        }
    }

    public synchronized int getStatementCacheSize() throws SQLException {
        if (this.statementCache == null) {
            return -1;
        }
        return this.statementCache.getCacheSize();
    }

    public synchronized void setImplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(0);
        }
        this.statementCache.setImplicitCachingEnabled(bl);
    }

    public synchronized boolean getImplicitCachingEnabled() throws SQLException {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getImplicitCachingEnabled();
    }

    public synchronized void setExplicitCachingEnabled(boolean bl) throws SQLException {
        if (this.statementCache == null) {
            this.statementCache = new LRUStatementCache(0);
        }
        this.statementCache.setExplicitCachingEnabled(bl);
    }

    public synchronized boolean getExplicitCachingEnabled() throws SQLException {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getExplicitCachingEnabled();
    }

    public synchronized void purgeImplicitCache() throws SQLException {
        if (this.statementCache != null) {
            this.statementCache.purgeImplicitCache();
        }
    }

    public synchronized void purgeExplicitCache() throws SQLException {
        if (this.statementCache != null) {
            this.statementCache.purgeExplicitCache();
        }
    }

    public synchronized PreparedStatement getStatementWithKey(String string) throws SQLException {
        if (this.statementCache != null) {
            OracleStatement oracleStatement = this.statementCache.searchExplicitCache(string);
            if (oracleStatement == null || oracleStatement.statementType == 1) {
                return (PreparedStatement)((Object)oracleStatement);
            }
            DatabaseError.throwSqlException(125);
            return null;
        }
        return null;
    }

    public synchronized CallableStatement getCallWithKey(String string) throws SQLException {
        if (this.statementCache != null) {
            OracleStatement oracleStatement = this.statementCache.searchExplicitCache(string);
            if (oracleStatement == null || oracleStatement.statementType == 2) {
                return (CallableStatement)((Object)oracleStatement);
            }
            DatabaseError.throwSqlException(125);
            return null;
        }
        return null;
    }

    public synchronized void cacheImplicitStatement(OraclePreparedStatement oraclePreparedStatement, String string, int n, int n2) throws SQLException {
        if (this.statementCache == null) {
            DatabaseError.throwSqlException(95);
        } else {
            this.statementCache.addToImplicitCache(oraclePreparedStatement, string, n, n2);
        }
    }

    public synchronized void cacheExplicitStatement(OraclePreparedStatement oraclePreparedStatement, String string) throws SQLException {
        if (this.statementCache == null) {
            DatabaseError.throwSqlException(95);
        } else {
            this.statementCache.addToExplicitCache(oraclePreparedStatement, string);
        }
    }

    public synchronized boolean isStatementCacheInitialized() {
        if (this.statementCache == null) {
            return false;
        }
        return this.statementCache.getCacheSize() != 0;
    }

    public void setDefaultAutoRefetch(boolean bl) throws SQLException {
        this.defaultAutoRefetch = bl;
    }

    public boolean getDefaultAutoRefetch() throws SQLException {
        return this.defaultAutoRefetch;
    }

    public synchronized void registerTAFCallback(OracleOCIFailover oracleOCIFailover, Object object) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    public String getDatabaseProductVersion() throws SQLException {
        if (this.databaseProductVersion == uninitializedMarker) {
            this.needLine();
            this.databaseProductVersion = this.doGetDatabaseProductVersion();
        }
        return this.databaseProductVersion;
    }

    public synchronized boolean getReportRemarks() {
        return this.reportRemarks;
    }

    public synchronized short getVersionNumber() throws SQLException {
        if (this.versionNumber == -1) {
            this.needLine();
            this.versionNumber = this.doGetVersionNumber();
        }
        return this.versionNumber;
    }

    public synchronized void registerCloseCallback(OracleCloseCallback oracleCloseCallback, Object object) {
        this.closeCallback = oracleCloseCallback;
        this.privateData = object;
    }

    public void setCreateStatementAsRefCursor(boolean bl) {
    }

    public boolean getCreateStatementAsRefCursor() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int pingDatabase(int n) throws SQLException {
        if (this.lifecycle != 1) {
            return -1;
        }
        Statement statement = null;
        try {
            statement = this.createStatement();
            ((OracleStatement)statement).defineColumnType(1, 12, 1);
            statement.executeQuery("SELECT 'x' FROM DUAL");
        }
        catch (SQLException sQLException) {
            int n2 = -1;
            return n2;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        return 0;
    }

    public synchronized Map getJavaObjectTypeMap() {
        return this.javaObjectMap;
    }

    public synchronized void setJavaObjectTypeMap(Map map) {
        this.javaObjectMap = map;
    }

    public void clearClientIdentifier(String string) throws SQLException {
        String[] stringArray;
        if (!this.useDMSForEndToEnd && string != null && string != uninitializedMarker && (stringArray = this.getEndToEndMetrics()) != null && string.equals(stringArray[1])) {
            stringArray[1] = null;
            this.setEndToEndMetrics(stringArray, this.getEndToEndECIDSequenceNumber());
        }
    }

    public void setClientIdentifier(String string) throws SQLException {
        if (!this.useDMSForEndToEnd) {
            String[] stringArray = this.getEndToEndMetrics();
            if (stringArray == null) {
                stringArray = new String[4];
            }
            stringArray[1] = string;
            this.setEndToEndMetrics(stringArray, this.getEndToEndECIDSequenceNumber());
        }
    }

    public void setSessionTimeZone(String string) throws SQLException {
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = this.createStatement();
            statement.executeUpdate("ALTER SESSION SET TIME_ZONE = '" + string + "'");
            resultSet = statement.executeQuery("SELECT DBTIMEZONE FROM DUAL");
            resultSet.next();
            String string2 = resultSet.getString(1);
            this.setDbTzCalendar(string2);
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
        this.sessionTimeZone = string;
    }

    public String getSessionTimeZone() {
        return this.sessionTimeZone;
    }

    void setDbTzCalendar(String string) {
        char c = string.charAt(0);
        string = c == '-' || c == '+' ? "GMT" + string : "GMT+" + string;
        TimeZone timeZone = TimeZone.getTimeZone(string);
        this.dbTzCalendar = new GregorianCalendar(timeZone);
    }

    public Calendar getDbTzCalendar() {
        return this.dbTzCalendar;
    }

    public void setAccumulateBatchResult(boolean bl) {
        this.accumulateBatchResult = bl;
    }

    public boolean isAccumulateBatchResult() {
        return this.accumulateBatchResult;
    }

    public void setJ2EE13Compliant(boolean bl) {
        this.j2ee13Compliant = bl;
    }

    public boolean getJ2EE13Compliant() {
        return this.j2ee13Compliant;
    }

    public Class classForNameAndSchema(String string, String string2) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public Class safelyGetClassForName(String string) throws ClassNotFoundException {
        return Class.forName(string);
    }

    public int getHeapAllocSize() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        DatabaseError.throwSqlException(23);
        return -1;
    }

    public int getOCIEnvHeapAllocSize() throws SQLException {
        if (this.lifecycle != 1) {
            DatabaseError.throwSqlException(8);
        }
        DatabaseError.throwSqlException(23);
        return -1;
    }

    public static OracleConnection unwrapCompletely(oracle.jdbc.OracleConnection oracleConnection) {
        oracle.jdbc.OracleConnection oracleConnection2;
        oracle.jdbc.OracleConnection oracleConnection3 = oracleConnection2 = oracleConnection;
        while (oracleConnection3 != null) {
            oracleConnection2 = oracleConnection3;
            oracleConnection3 = oracleConnection2.unwrap();
        }
        return (OracleConnection)oracleConnection2;
    }

    public void setWrapper(oracle.jdbc.OracleConnection oracleConnection) {
        this.wrapper = oracleConnection;
    }

    public oracle.jdbc.OracleConnection unwrap() {
        return null;
    }

    public oracle.jdbc.OracleConnection getWrapper() {
        if (this.wrapper != null) {
            return this.wrapper;
        }
        return this;
    }

    static oracle.jdbc.internal.OracleConnection _physicalConnectionWithin(Connection connection) {
        OracleConnection oracleConnection = null;
        if (connection != null) {
            oracleConnection = PhysicalConnection.unwrapCompletely((oracle.jdbc.OracleConnection)connection);
        }
        return oracleConnection;
    }

    public oracle.jdbc.internal.OracleConnection physicalConnectionWithin() {
        return this;
    }

    public long getTdoCState(String string, String string2) throws SQLException {
        return 0L;
    }

    public void getOracleTypeADT(OracleTypeADT oracleTypeADT) throws SQLException {
    }

    public Datum toDatum(CustomDatum customDatum) throws SQLException {
        return customDatum.toDatum(this);
    }

    public short getNCharSet() {
        return this.conversion.getNCharSetId();
    }

    public ResultSet newArrayDataResultSet(Datum[] datumArray, long l, int n, Map map) throws SQLException {
        return new ArrayDataResultSet((OracleConnection)this, datumArray, l, n, map);
    }

    public ResultSet newArrayDataResultSet(ARRAY aRRAY, long l, int n, Map map) throws SQLException {
        return new ArrayDataResultSet((OracleConnection)this, aRRAY, l, n, map);
    }

    public ResultSet newArrayLocatorResultSet(ArrayDescriptor arrayDescriptor, byte[] byArray, long l, int n, Map map) throws SQLException {
        return new ArrayLocatorResultSet(this, arrayDescriptor, byArray, l, n, map);
    }

    public ResultSetMetaData newStructMetaData(StructDescriptor structDescriptor) throws SQLException {
        return new StructMetaData(structDescriptor);
    }

    public int CHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int[] nArray = new int[]{n};
        return this.conversion.CHARBytesToJavaChars(byArray, 0, cArray, 0, nArray, cArray.length);
    }

    public int NCHARBytesToJavaChars(byte[] byArray, int n, char[] cArray) throws SQLException {
        int[] nArray = new int[1];
        return this.conversion.NCHARBytesToJavaChars(byArray, 0, cArray, 0, nArray, cArray.length);
    }

    public boolean IsNCharFixedWith() {
        return this.conversion.IsNCharFixedWith();
    }

    public short getDriverCharSet() {
        return this.conversion.getClientCharSet();
    }

    public int getMaxCharSize() throws SQLException {
        DatabaseError.throwSqlException(58);
        return -1;
    }

    public int getMaxCharbyteSize() {
        return this.conversion.getMaxCharbyteSize();
    }

    public int getMaxNCharbyteSize() {
        return this.conversion.getMaxNCharbyteSize();
    }

    public boolean isCharSetMultibyte(short s) {
        return DBConversion.isCharSetMultibyte(s);
    }

    public int javaCharsToCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.conversion.javaCharsToCHARBytes(cArray, n, byArray);
    }

    public int javaCharsToNCHARBytes(char[] cArray, int n, byte[] byArray) throws SQLException {
        return this.conversion.javaCharsToNCHARBytes(cArray, n, byArray);
    }

    public abstract void getPropertyForPooledConnection(OraclePooledConnection var1) throws SQLException;

    final void getPropertyForPooledConnection(OraclePooledConnection oraclePooledConnection, String string) throws SQLException {
        Hashtable<String, Map> hashtable = new Hashtable<String, Map>();
        hashtable.put("obj_type_map", this.javaObjectMap);
        Properties properties = new Properties();
        properties.put("user", this.user);
        properties.put("password", string);
        properties.put("connection_url", this.url);
        properties.put("connect_auto_commit", uninitializedMarker + this.autoCommitSet);
        properties.put("trans_isolation", uninitializedMarker + this.txnLevel);
        if (this.getStatementCacheSize() != -1) {
            properties.put("stmt_cache_size", uninitializedMarker + this.getStatementCacheSize());
            properties.put("implicit_cache_enabled", uninitializedMarker + this.getImplicitCachingEnabled());
            properties.put("explict_cache_enabled", uninitializedMarker + this.getExplicitCachingEnabled());
        }
        properties.put("defaultExecuteBatch", uninitializedMarker + this.defaultBatch);
        properties.put("prefetch", uninitializedMarker + this.defaultRowPrefetch);
        properties.put("remarks", uninitializedMarker + this.reportRemarks);
        properties.put("AccumulateBatchResult", uninitializedMarker + this.accumulateBatchResult);
        properties.put("oracle.jdbc.J2EE13Compliant", uninitializedMarker + this.j2ee13Compliant);
        properties.put("processEscapes", uninitializedMarker + this.processEscapes);
        properties.put("restrictGetTables", uninitializedMarker + this.restrictGetTables);
        properties.put("synonyms", uninitializedMarker + this.includeSynonyms);
        properties.put("fixedString", uninitializedMarker + this.defaultFixedString);
        hashtable.put("connection_properties", properties);
        oraclePooledConnection.setProperties(hashtable);
    }

    public Properties getDBAccessProperties() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public Properties getOCIHandles() throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    abstract void logon() throws SQLException;

    void logoff() throws SQLException {
    }

    abstract void open(OracleStatement var1) throws SQLException;

    abstract void doCancel() throws SQLException;

    abstract void doSetAutoCommit(boolean var1) throws SQLException;

    abstract void doCommit() throws SQLException;

    abstract void doRollback() throws SQLException;

    abstract String doGetDatabaseProductVersion() throws SQLException;

    abstract short doGetVersionNumber() throws SQLException;

    int getDefaultStreamChunkSize() {
        return this.streamChunkSize;
    }

    abstract OracleStatement RefCursorBytesToStatement(byte[] var1, OracleStatement var2) throws SQLException;

    public oracle.jdbc.internal.OracleStatement refCursorCursorToStatement(int n) throws SQLException {
        DatabaseError.throwSqlException(23);
        return null;
    }

    public Connection getLogicalConnection(OraclePooledConnection oraclePooledConnection, boolean bl) throws SQLException {
        LogicalConnection logicalConnection;
        if (this.logicalConnectionAttached != null || oraclePooledConnection.getPhysicalHandle() != this) {
            DatabaseError.throwSqlException(143);
        }
        this.logicalConnectionAttached = logicalConnection = new LogicalConnection(oraclePooledConnection, this, bl);
        return logicalConnection;
    }

    public void getForm(OracleTypeADT oracleTypeADT, OracleTypeCLOB oracleTypeCLOB, int n) throws SQLException {
    }

    public CLOB createClob(byte[] byArray) throws SQLException {
        return new CLOB(this, byArray);
    }

    public CLOB createClob(byte[] byArray, short s) throws SQLException {
        return new CLOB(this, byArray, s);
    }

    public BLOB createBlob(byte[] byArray) throws SQLException {
        return new BLOB(this, byArray);
    }

    public BFILE createBfile(byte[] byArray) throws SQLException {
        return new BFILE(this, byArray);
    }

    public boolean isDescriptorSharable(oracle.jdbc.internal.OracleConnection oracleConnection) throws SQLException {
        PhysicalConnection physicalConnection = this;
        PhysicalConnection physicalConnection2 = (PhysicalConnection)oracleConnection.getPhysicalConnection();
        return physicalConnection == physicalConnection2 || physicalConnection.url.equals(physicalConnection2.url) || physicalConnection2.protocol != null && physicalConnection2.protocol.equals("kprb");
    }

    boolean useLittleEndianSetCHARBinder() throws SQLException {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setPlsqlWarnings(String string) throws SQLException {
        if (string == null) {
            DatabaseError.throwSqlException(68);
        }
        if (string != null && (string = string.trim()).length() > 0 && !OracleSql.isValidPlsqlWarning(string)) {
            DatabaseError.throwSqlException(68);
        }
        String string2 = "ALTER SESSION SET PLSQL_WARNINGS=" + string;
        String string3 = "ALTER SESSION SET EVENTS='10933 TRACE NAME CONTEXT LEVEL 32768'";
        Statement statement = null;
        try {
            statement = this.createStatement(-1, -1);
            statement.execute(string2);
            if (string.equals("'DISABLE:ALL'")) {
                this.plsqlCompilerWarnings = false;
            } else {
                statement.execute(string3);
                this.plsqlCompilerWarnings = true;
            }
        }
        finally {
            if (statement != null) {
                statement.close();
            }
        }
    }

    void internalClose() throws SQLException {
        this.lifecycle = 4;
    }

    public XAResource getXAResource() throws SQLException {
        DatabaseError.throwSqlException(164);
        return null;
    }

    protected void doDescribeTable(AutoKeyInfo autoKeyInfo) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    public void setApplicationContext(String string, String string2, String string3) throws SQLException {
        if (string == null || string2 == null || string3 == null) {
            throw new NullPointerException();
        }
        if (string.equals(uninitializedMarker)) {
            DatabaseError.throwSqlException(170);
        }
        if (string.compareToIgnoreCase("CLIENTCONTEXT") != 0) {
            DatabaseError.throwSqlException(174);
        }
        if (string2.length() > 30) {
            DatabaseError.throwSqlException(171);
        }
        if (string3.length() > 4000) {
            DatabaseError.throwSqlException(172);
        }
        this.doSetApplicationContext(string, string2, string3);
    }

    void doSetApplicationContext(String string, String string2, String string3) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    public void clearAllApplicationContext(String string) throws SQLException {
        if (string == null) {
            throw new NullPointerException();
        }
        if (string.equals(uninitializedMarker)) {
            DatabaseError.throwSqlException(170);
        }
        this.doClearAllApplicationContext(string);
    }

    void doClearAllApplicationContext(String string) throws SQLException {
        DatabaseError.throwSqlException(23);
    }

    public boolean isV8Compatible() throws SQLException {
        return this.v8Compatible;
    }

    static {
        PhysicalConnection.endToEndMaxLength[0] = 32;
        PhysicalConnection.endToEndMaxLength[1] = 64;
        PhysicalConnection.endToEndMaxLength[2] = 64;
        PhysicalConnection.endToEndMaxLength[3] = 48;
        _Copyright_2004_Oracle_All_Rights_Reserved_ = null;
    }
}

