/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.stream.input.FileImageInputStreamExt;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.text.Format;
import java.text.NumberFormat;
import java.text.SimpleDateFormat;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.logging.Level;
import java.util.logging.Logger;
import ucar.ma2.DataType;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.Group;
import ucar.nc2.Variable;
import ucar.nc2.VariableIF;
import ucar.nc2.constants.AxisType;
import ucar.nc2.dataset.CoordinateAxis1D;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

public class NetCDFUtilities {
    private static final Logger LOGGER = Logger.getLogger(NetCDFUtilities.class.toString());
    public static final String LOWER_LEFT_LONGITUDE = "lower_left_longitude";
    public static final String LOWER_LEFT_LATITUDE = "lower_left_latitude";
    public static final String UPPER_RIGHT_LONGITUDE = "upper_right_longitude";
    public static final String UPPER_RIGHT_LATITUDE = "upper_right_latitude";
    public static final String COORDSYS = "latLonCoordSys";
    public static final String LATITUDE = "latitude";
    public static final String LAT = "lat";
    public static final String LONGITUDE = "longitude";
    public static final String LON = "lon";
    public static final String DEPTH = "depth";
    public static final String ZETA = "z";
    private static final String BOUNDS = "bounds";
    private static final String BNDS = "bnds";
    public static final String HEIGHT = "height";
    public static final String TIME = "time";
    public static final String COORDINATE_AXIS_TYPE = "_CoordinateAxisType";
    public static final String POSITIVE = "positive";
    public static final String UNITS = "units";
    public static final String NAME = "name";
    public static final String LONG_NAME = "long_name";
    public static final int X_DIMENSION = 1;
    public static final int Y_DIMENSION = 2;
    public static final int Z_DIMENSION = 3;
    public static final Set<DataType> VALID_TYPES = new HashSet<DataType>(12);

    private NetCDFUtilities() {
    }

    public static int getTIndex(Variable var, Range range, int imageIndex) {
        int rank = var.getRank();
        if (rank > 2) {
            if (rank == 3) {
                return imageIndex - range.first();
            }
            return (int)Math.ceil((imageIndex - range.first()) / NetCDFUtilities.getZDimensionLength(var));
        }
        return -1;
    }

    private static int getZDimensionLength(Variable var) {
        int rank = var.getRank();
        if (rank > 2) {
            return var.getDimension(rank - 3).getLength();
        }
        return 0;
    }

    public static int getZIndex(Variable var, Range range, int imageIndex) {
        int rank = var.getRank();
        if (rank > 2) {
            if (rank == 3) {
                return imageIndex - range.first();
            }
            return (imageIndex - range.first()) % NetCDFUtilities.getZDimensionLength(var);
        }
        return -1;
    }

    public static int getRawDataType(VariableIF variable) {
        VariableDS ds = (VariableDS)variable;
        DataType type = ds.getOriginalDataType();
        return NetCDFUtilities.transcodeNetCDFDataType(type, variable.isUnsigned());
    }

    public static int transcodeNetCDFDataType(DataType type, boolean unsigned) {
        if (DataType.BOOLEAN.equals((Object)type) || DataType.BYTE.equals((Object)type)) {
            return 0;
        }
        if (DataType.CHAR.equals((Object)type)) {
            return 1;
        }
        if (DataType.SHORT.equals((Object)type)) {
            return unsigned ? 1 : 2;
        }
        if (DataType.INT.equals((Object)type)) {
            return 3;
        }
        if (DataType.FLOAT.equals((Object)type)) {
            return 4;
        }
        if (DataType.LONG.equals((Object)type) || DataType.DOUBLE.equals((Object)type)) {
            return 5;
        }
        return 32;
    }

    public static DataType transcodeDataType(int dataType) {
        switch (dataType) {
            case 0: {
                return DataType.BYTE;
            }
            case 5: {
                return DataType.DOUBLE;
            }
            case 4: {
                return DataType.FLOAT;
            }
            case 3: {
                return DataType.INT;
            }
            case 2: {
                return DataType.SHORT;
            }
            case 1: {
                return DataType.SHORT;
            }
        }
        throw new IllegalArgumentException("Invalid input data type:" + dataType);
    }

    public static String getAttributesAsString(Attribute attr) {
        return NetCDFUtilities.getAttributesAsString(attr, false);
    }

    public static String getAttributesAsString(Variable var, String attributeName) {
        Attribute attribute;
        String value = "";
        if (var != null && (attribute = var.findAttribute(attributeName)) != null) {
            value = NetCDFUtilities.getAttributesAsString(attribute, false);
        }
        return value;
    }

    public static Number getAttributesAsNumber(Variable var, String attributeName) {
        Attribute attribute;
        Number value = null;
        if (var != null && (attribute = var.findAttribute(attributeName)) != null) {
            value = attribute.getNumericValue();
        }
        return value;
    }

    public static String getAttributesAsString(Attribute attr, boolean isUnsigned) {
        String[] values = null;
        if (attr != null) {
            int i;
            int nValues = attr.getLength();
            values = new String[nValues];
            DataType datatype = attr.getDataType();
            if (datatype == DataType.BYTE) {
                if (isUnsigned) {
                    for (i = 0; i < nValues; ++i) {
                        byte val = attr.getNumericValue(i).byteValue();
                        int myByte = 0xFF & val;
                        short anUnsignedByte = (short)myByte;
                        values[i] = Short.toString(anUnsignedByte);
                    }
                } else {
                    for (i = 0; i < nValues; ++i) {
                        byte val = attr.getNumericValue(i).byteValue();
                        values[i] = Byte.toString(val);
                    }
                }
            } else if (datatype == DataType.SHORT) {
                for (i = 0; i < nValues; ++i) {
                    short val = attr.getNumericValue(i).shortValue();
                    values[i] = Short.toString(val);
                }
            } else if (datatype == DataType.INT) {
                for (i = 0; i < nValues; ++i) {
                    int val = attr.getNumericValue(i).intValue();
                    values[i] = Integer.toString(val);
                }
            } else if (datatype == DataType.LONG) {
                for (i = 0; i < nValues; ++i) {
                    long val = attr.getNumericValue(i).longValue();
                    values[i] = Long.toString(val);
                }
            } else if (datatype == DataType.DOUBLE) {
                for (i = 0; i < nValues; ++i) {
                    double val = attr.getNumericValue(i).doubleValue();
                    values[i] = Double.toString(val);
                }
            } else if (datatype == DataType.FLOAT) {
                for (i = 0; i < nValues; ++i) {
                    float val = attr.getNumericValue(i).floatValue();
                    values[i] = Float.toString(val);
                }
            } else if (datatype == DataType.STRING) {
                for (i = 0; i < nValues; ++i) {
                    values[i] = attr.getStringValue(i);
                }
            } else if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Unhandled Attribute datatype " + attr.getDataType().getClassType().toString());
            }
        }
        String value = "";
        if (values != null) {
            int j;
            StringBuffer sb = new StringBuffer();
            for (j = 0; j < values.length - 1; ++j) {
                sb.append(values[j]).append(",");
            }
            sb.append(values[j]);
            value = sb.toString();
        }
        return value;
    }

    public static boolean isVariableAccepted(Variable var, CheckType checkType) {
        if (var instanceof CoordinateAxis1D) {
            return false;
        }
        if (checkType == CheckType.NOSCALARS) {
            List dimensions = var.getDimensions();
            if (dimensions.size() < 2) {
                return false;
            }
            DataType dataType = var.getDataType();
            if (dataType == DataType.CHAR) {
                return false;
            }
            return NetCDFUtilities.isVariableAccepted(var.getName(), CheckType.NONE);
        }
        if (checkType == CheckType.ONLYGEOGRIDS) {
            List dimensions = var.getDimensions();
            if (dimensions.size() < 2) {
                return false;
            }
            for (Dimension dimension : dimensions) {
                CoordinateAxis1D axis;
                AxisType axisType;
                String dimName = dimension.getName();
                Group group = dimension.getGroup();
                Variable dimVariable = group.findVariable(dimName);
                if (dimVariable == null) {
                    return false;
                }
                if (!(dimVariable instanceof CoordinateAxis1D) || (axisType = (axis = (CoordinateAxis1D)dimVariable).getAxisType()) != null) continue;
                return false;
            }
            DataType dataType = var.getDataType();
            if (dataType == DataType.CHAR) {
                return false;
            }
            return NetCDFUtilities.isVariableAccepted(var.getName(), CheckType.NONE);
        }
        return NetCDFUtilities.isVariableAccepted(var.getName(), checkType);
    }

    public static boolean isVariableAccepted(String name, CheckType checkType) {
        if (checkType == CheckType.NONE) {
            return !name.equalsIgnoreCase(LATITUDE) && !name.equalsIgnoreCase(LONGITUDE) && !name.equalsIgnoreCase(LON) && !name.equalsIgnoreCase(LAT) && !name.equalsIgnoreCase(TIME) && !name.equalsIgnoreCase(DEPTH) && !name.equalsIgnoreCase(ZETA) && !name.equalsIgnoreCase(HEIGHT) && !name.toLowerCase().contains(COORDSYS.toLowerCase()) && !name.endsWith(BOUNDS) && !name.endsWith(BNDS);
        }
        return true;
    }

    public static String trimFractionalPart(String value) {
        value = value.trim();
        int i = value.length();
        block4: while (--i >= 0) {
            switch (value.charAt(i)) {
                case '0': {
                    continue block4;
                }
                case '.': {
                    return value.substring(0, i);
                }
            }
            return value;
        }
        return value;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static NetcdfDataset getDataset(Object input) throws IOException {
        NetcdfDataset dataset = null;
        if (input instanceof File) {
            File file = (File)input;
            if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
            return NetcdfDataset.openDataset((String)file.getPath());
        }
        if (input instanceof String) {
            File file = new File((String)input);
            if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
            return NetcdfDataset.openDataset((String)file.getPath());
        }
        if (input instanceof URL) {
            URL tempURL = (URL)input;
            String protocol = tempURL.getProtocol();
            if (protocol.equalsIgnoreCase("file")) {
                File file = ImageIOUtilities.urlToFile((URL)tempURL);
                if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
                return NetcdfDataset.openDataset((String)file.getPath());
            }
            if (protocol.equalsIgnoreCase("http")) return NetcdfDataset.openDataset((String)tempURL.toExternalForm());
            if (!protocol.equalsIgnoreCase("dods")) return dataset;
            return NetcdfDataset.openDataset((String)tempURL.toExternalForm());
        }
        if (input instanceof URIImageInputStream) {
            URIImageInputStream uriInStream = (URIImageInputStream)input;
            return NetcdfDataset.openDataset((String)uriInStream.getUri().toString());
        }
        if (!(input instanceof FileImageInputStreamExt)) return dataset;
        File file = ((FileImageInputStreamExt)input).getFile();
        if (file.isDirectory()) throw new IllegalArgumentException("Error occurred during NetCDF file reading: The input file is a Directory.");
        return NetcdfDataset.openDataset((String)file.getPath());
    }

    public static Format getAxisFormat(AxisType type, String prototype) {
        if (!type.equals((Object)AxisType.Time)) {
            return NumberFormat.getNumberInstance(Locale.CANADA);
        }
        char dateSeparator = '-';
        boolean yearLast = false;
        boolean namedMonth = false;
        boolean addT = false;
        boolean appendZ = false;
        int dateLength = 0;
        if (prototype != null) {
            char c;
            int field = 1;
            int digitCount = 0;
            int length = prototype.length();
            for (int i = 0; i < length && !Character.isWhitespace(c = prototype.charAt(i)); ++i) {
                if (Character.isDigit(c)) {
                    ++digitCount;
                    ++dateLength;
                    continue;
                }
                if (field == 2 && Character.isLetter(c)) {
                    namedMonth = true;
                    continue;
                }
                if (field == 1) {
                    dateSeparator = c;
                    ++dateLength;
                }
                if (c == 'T') {
                    addT = true;
                }
                if (c == 'Z' && i == length - 1) {
                    appendZ = true;
                }
                digitCount = 0;
                ++field;
            }
            if (digitCount >= 4) {
                yearLast = true;
            }
        }
        String pattern = null;
        if (yearLast) {
            pattern = namedMonth ? "dd-MMM-yyyy" : "dd-MM-yyyy";
        } else {
            String string = pattern = namedMonth ? "yyyy-MMM-dd" : "yyyy-MM-dd";
            if (dateLength < 10) {
                pattern = pattern.substring(0, dateLength);
            }
        }
        pattern = pattern.replace('-', dateSeparator);
        int lastColon = prototype.lastIndexOf(":");
        if (lastColon != -1) {
            pattern = pattern + (addT ? "'T'" : " ");
            pattern = pattern + (prototype != null && lastColon >= 16 ? "HH:mm:ss" : "HH:mm");
        }
        pattern = pattern + (appendZ ? "'Z'" : "");
        SimpleDateFormat format = new SimpleDateFormat(pattern, Locale.CANADA);
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format;
    }

    public static CheckType getCheckType(NetcdfDataset dataset) {
        CheckType ct = CheckType.UNSET;
        if (dataset != null) {
            ct = CheckType.ONLYGEOGRIDS;
        }
        return ct;
    }

    public static String getGlobalAttributeAsString(NetcdfDataset dataset, String attributeName) {
        Attribute attrib;
        String attributeValue = "";
        if (dataset != null && (attrib = dataset.findGlobalAttribute(attributeName)) != null && attrib.getName().equals(attributeName)) {
            attributeValue = NetCDFUtilities.getAttributesAsString(attrib);
        }
        return attributeValue;
    }

    public static KeyValuePair getGlobalAttribute(NetcdfDataset dataset, int attributeIndex) throws IOException {
        Attribute attribute;
        List globalAttributes;
        KeyValuePair attributePair = null;
        if (dataset != null && (globalAttributes = dataset.getGlobalAttributes()) != null && !globalAttributes.isEmpty() && (attribute = (Attribute)globalAttributes.get(attributeIndex)) != null) {
            attributePair = new KeyValuePair(attribute.getName(), NetCDFUtilities.getAttributesAsString(attribute));
        }
        return attributePair;
    }

    public static KeyValuePair getAttribute(Variable var, int attributeIndex) {
        Attribute attribute;
        List attributes;
        KeyValuePair attributePair = null;
        if (var != null && (attributes = var.getAttributes()) != null && !attributes.isEmpty() && (attribute = (Attribute)attributes.get(attributeIndex)) != null) {
            attributePair = new KeyValuePair(attribute.getName(), NetCDFUtilities.getAttributesAsString(attribute));
        }
        return attributePair;
    }

    static {
        VALID_TYPES.add(DataType.BOOLEAN);
        VALID_TYPES.add(DataType.BYTE);
        VALID_TYPES.add(DataType.SHORT);
        VALID_TYPES.add(DataType.INT);
        VALID_TYPES.add(DataType.LONG);
        VALID_TYPES.add(DataType.FLOAT);
        VALID_TYPES.add(DataType.DOUBLE);
    }

    public static class DatasetAttribs {
        public static final String VALID_RANGE = "valid_range";
        public static final String VALID_MIN = "valid_min";
        public static final String VALID_MAX = "valid_max";
        public static final String LONG_NAME = "long_name";
        public static final String FILL_VALUE = "_FillValue";
        public static final String MISSING_VALUE = "missing_value";
        public static final String SCALE_FACTOR = "scale_factor";
        public static final String ADD_OFFSET = "add_offset";
        public static final String UNITS = "units";

        private DatasetAttribs() {
        }
    }

    public static class ProjAttribs {
        public static final String PROJECT_TO_IMAGE_AFFINE = "proj_to_image_affine";
        public static final String PROJECT_ORIGIN_LATITUDE = "proj_origin_latitude";
        public static final String PROJECT_ORIGIN_LONGITUDE = "proj_origin_longitude";
        public static final String EARTH_FLATTENING = "earth_flattening";
        public static final String EQUATORIAL_RADIUS = "equatorial_radius";
        public static final String STANDARD_PARALLEL_1 = "std_parallel_1";

        private ProjAttribs() {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum CheckType {
        NONE,
        UNSET,
        NOSCALARS,
        ONLYGEOGRIDS;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Axis {
        X,
        Y,
        Z,
        T;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class KeyValuePair
    implements Map.Entry<String, String> {
        private String key;
        private String value;

        public KeyValuePair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        @Override
        public String getKey() {
            return this.key;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        private boolean equal(Object a, Object b) {
            return a == b || a != null && a.equals(b);
        }

        @Override
        public boolean equals(Object o) {
            return o instanceof KeyValuePair && this.equal(((KeyValuePair)o).key, this.key) && this.equal(((KeyValuePair)o).value, this.value);
        }

        private static int hashCode(Object a) {
            return a == null ? 42 : a.hashCode();
        }

        @Override
        public int hashCode() {
            return KeyValuePair.hashCode(this.key) * 3 + KeyValuePair.hashCode(this.value);
        }

        public String toString() {
            return "(" + this.key + "," + this.value + ")";
        }

        @Override
        public String setValue(String value) {
            this.value = value;
            return value;
        }
    }
}

