/*
 * Decompiled with CFR 0.152.
 */
package it.geosolutions.imageio.plugins.netcdf;

import it.geosolutions.imageio.ndplugin.BaseImageReader;
import it.geosolutions.imageio.plugins.netcdf.BaseVariableWrapper;
import it.geosolutions.imageio.plugins.netcdf.NetCDFUtilities;
import it.geosolutions.imageio.stream.input.URIImageInputStream;
import it.geosolutions.imageio.utilities.ImageIOUtilities;
import java.awt.image.BufferedImage;
import java.awt.image.SampleModel;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageReadParam;
import javax.imageio.ImageTypeSpecifier;
import javax.imageio.metadata.IIOMetadata;
import javax.imageio.spi.ImageReaderSpi;
import ucar.ma2.Range;
import ucar.nc2.Attribute;
import ucar.nc2.Variable;
import ucar.nc2.dataset.CoordinateSystem;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class BaseNetCDFImageReader
extends BaseImageReader {
    protected static final Logger LOGGER = Logger.getLogger(BaseNetCDFImageReader.class.toString());
    private NetcdfDataset dataset;
    private Map<Range, ? extends BaseVariableWrapper> indexMap;
    private boolean initMap;
    private int numGlobalAttributes;

    public Map<Range, ?> getIndexMap() {
        return this.indexMap;
    }

    public synchronized void setIndexMap(Map<Range, ? extends BaseVariableWrapper> indexMap) {
        if (this.initMap) {
            throw new IllegalStateException("Map already initialized");
        }
        this.initMap = true;
        this.indexMap = indexMap;
    }

    public NetcdfDataset getDataset() {
        return this.dataset;
    }

    public void setNumGlobalAttributes(int numGlobalAttributes) {
        this.numGlobalAttributes = numGlobalAttributes;
    }

    public void setInput(Object input, boolean seekForwardOnly, boolean ignoreMetadata) {
        try {
            URL tempURL;
            String protocol;
            if (this.dataset != null) {
                this.reset();
            }
            if (input instanceof URIImageInputStream) {
                URIImageInputStream uriInStream = (URIImageInputStream)input;
                this.dataset = NetcdfDataset.openDataset((String)uriInStream.getUri().toString());
            }
            if (input instanceof URL && ((protocol = (tempURL = (URL)input).getProtocol()).equalsIgnoreCase("http") || protocol.equalsIgnoreCase("dods"))) {
                this.dataset = NetcdfDataset.openDataset((String)tempURL.toExternalForm());
            }
            if (this.dataset == null) {
                this.dataset = NetCDFUtilities.getDataset(input);
            }
            super.setInput(input, seekForwardOnly, ignoreMetadata);
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Error occurred during NetCDF file parsing", e);
        }
    }

    protected void initialize() {
        throw new UnsupportedOperationException("Implement ME");
    }

    public void setInput(Object input, boolean seekForwardOnly) {
        this.setInput(input);
    }

    public void setInput(Object input) {
        this.setInput(input, true, true);
    }

    public BaseNetCDFImageReader(ImageReaderSpi originatingProvider) {
        super(originatingProvider);
    }

    public int getHeight(int imageIndex) throws IOException {
        BaseVariableWrapper wrapper = this.getVariableWrapper(imageIndex);
        if (wrapper != null) {
            return wrapper.getHeight();
        }
        return -1;
    }

    public BaseVariableWrapper getVariableWrapper(int imageIndex) {
        this.checkImageIndex(imageIndex);
        BaseVariableWrapper wrapper = null;
        for (Range range : this.indexMap.keySet()) {
            if (!range.contains(imageIndex) || range.first() > imageIndex || imageIndex >= range.last()) continue;
            wrapper = this.indexMap.get(range);
        }
        return wrapper;
    }

    public Iterator<ImageTypeSpecifier> getImageTypes(int imageIndex) throws IOException {
        ArrayList<ImageTypeSpecifier> l = new ArrayList<ImageTypeSpecifier>();
        BaseVariableWrapper wrapper = this.getVariableWrapper(imageIndex);
        if (wrapper != null) {
            SampleModel sampleModel = wrapper.getSampleModel();
            ImageTypeSpecifier imageType = new ImageTypeSpecifier(ImageIOUtilities.createColorModel((SampleModel)sampleModel), sampleModel);
            l.add(imageType);
        }
        return l.iterator();
    }

    public int getWidth(int imageIndex) throws IOException {
        BaseVariableWrapper wrapper = this.getVariableWrapper(imageIndex);
        if (wrapper != null) {
            return wrapper.getWidth();
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        super.dispose();
        this.initMap = false;
        this.indexMap.clear();
        this.indexMap = null;
        this.numGlobalAttributes = -1;
        try {
            if (this.dataset != null) {
                this.dataset.close();
            }
        }
        catch (IOException e) {
            if (LOGGER.isLoggable(Level.WARNING)) {
                LOGGER.warning("Errors closing NetCDF dataset." + e.getLocalizedMessage());
            }
        }
        finally {
            this.dataset = null;
        }
    }

    public void reset() {
        super.setInput(null, false, false);
        this.dispose();
    }

    public String getAttributeAsString(int imageIndex, String attributeName) {
        return this.getAttributeAsString(imageIndex, attributeName, false);
    }

    public String getAttributeAsString(int imageIndex, String attributeName, boolean isUnsigned) {
        String attributeValue = "";
        BaseVariableWrapper wrapper = this.getVariableWrapper(imageIndex);
        Attribute attr = wrapper.getVariable().findAttributeIgnoreCase(attributeName);
        if (attr != null) {
            attributeValue = NetCDFUtilities.getAttributesAsString(attr, isUnsigned);
        }
        return attributeValue;
    }

    public NetCDFUtilities.KeyValuePair getAttribute(int imageIndex, int attributeIndex) throws IOException {
        NetCDFUtilities.KeyValuePair attributePair = null;
        Variable var = this.getVariable(imageIndex);
        if (var != null) {
            attributePair = NetCDFUtilities.getAttribute(var, attributeIndex);
        }
        return attributePair;
    }

    Variable getVariable(int imageIndex) {
        Variable var = null;
        BaseVariableWrapper wrapper = this.getVariableWrapper(imageIndex);
        if (wrapper != null) {
            var = wrapper.getVariable();
        }
        return var;
    }

    public String getVariableName(int imageIndex) {
        String name = "";
        BaseVariableWrapper wrapper = this.getVariableWrapper(imageIndex);
        if (wrapper != null) {
            name = wrapper.getName();
        }
        return name;
    }

    Variable getVariableByName(String varName) {
        List varList = this.dataset.getVariables();
        for (Variable var : varList) {
            if (!var.getName().equals(varName)) continue;
            return var;
        }
        return null;
    }

    CoordinateSystem getCoordinateSystem(Variable variable) {
        List systems;
        CoordinateSystem cs = null;
        if (variable != null && !(systems = ((VariableDS)variable).getCoordinateSystems()).isEmpty()) {
            cs = (CoordinateSystem)systems.get(0);
        }
        return cs;
    }

    public int getNumGlobalAttributes() {
        return this.numGlobalAttributes;
    }

    public int getNumAttributes(int imageIndex) {
        List attributes;
        int numAttribs = 0;
        Variable var = this.getVariable(imageIndex);
        if (var != null && (attributes = var.getAttributes()) != null && !attributes.isEmpty()) {
            numAttribs = attributes.size();
        }
        return numAttribs;
    }

    public NetCDFUtilities.KeyValuePair getGlobalAttribute(int attributeIndex) throws IOException {
        return NetCDFUtilities.getGlobalAttribute(this.dataset, attributeIndex);
    }

    public IIOMetadata getImageMetadata(int imageIndex) throws IOException {
        throw new UnsupportedOperationException("Implement ME");
    }

    public IIOMetadata getStreamMetadata() throws IOException {
        throw new UnsupportedOperationException("Implement ME");
    }

    public BufferedImage read(int imageIndex, ImageReadParam param) {
        throw new UnsupportedOperationException("Implement ME");
    }
}

