/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.gs.WrappingIterator;
import org.geotools.process.vector.VectorProcess;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.PropertyDescriptor;

@DescribeProcess(title="Union Feature Collections", description="Returns single feature collection containing all features from two input feature collections.  The output attribute schema is a combination of the attributes from the inputs.  Attributes with same name but different types will be converted to strings.")
public class UnionFeatureCollection
implements VectorProcess {
    static final String SCHEMA_NAME = "Union_Layer";

    @DescribeResult(name="result", description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="first", description="First input feature collection") SimpleFeatureCollection firstFeatures, @DescribeParameter(name="second", description="Second feature collection") SimpleFeatureCollection secondFeatures) throws ClassNotFoundException {
        if (!((SimpleFeature)firstFeatures.features().next()).getDefaultGeometry().getClass().equals(((SimpleFeature)secondFeatures.features().next()).getDefaultGeometry().getClass())) {
            throw new ProcessException("Different default geometries, cannot perform union");
        }
        return new UnitedFeatureCollection(firstFeatures, secondFeatures);
    }

    static class UnitedFeatureIterator
    implements SimpleFeatureIterator {
        SimpleFeatureIterator firstDelegate;
        SimpleFeatureIterator secondDelegate;
        SimpleFeatureCollection firstCollection;
        SimpleFeatureCollection secondCollection;
        SimpleFeatureBuilder fb;
        SimpleFeature next;
        int iterationIndex = 0;

        public UnitedFeatureIterator(SimpleFeatureIterator firstDelegate, SimpleFeatureCollection firstCollection, SimpleFeatureIterator secondDelegate, SimpleFeatureCollection secondCollection, SimpleFeatureType schema) {
            this.firstDelegate = firstDelegate;
            this.secondDelegate = secondDelegate;
            this.firstCollection = firstCollection;
            this.secondCollection = secondCollection;
            this.fb = new SimpleFeatureBuilder(schema);
        }

        @Override
        public void close() {
            this.firstDelegate.close();
            this.secondDelegate.close();
        }

        @Override
        public boolean hasNext() {
            SimpleFeature f;
            while (this.next == null && this.firstDelegate.hasNext()) {
                f = (SimpleFeature)this.firstDelegate.next();
                for (PropertyDescriptor property : this.fb.getFeatureType().getDescriptors()) {
                    this.fb.set(property.getName(), f.getAttribute(property.getName()));
                }
                this.next = this.fb.buildFeature(Integer.toString(this.iterationIndex));
                this.fb.reset();
                ++this.iterationIndex;
            }
            while (this.next == null && this.secondDelegate.hasNext() && !this.firstDelegate.hasNext()) {
                f = (SimpleFeature)this.secondDelegate.next();
                for (PropertyDescriptor property : this.fb.getFeatureType().getDescriptors()) {
                    this.fb.set(property.getName(), f.getAttribute(property.getName()));
                }
                this.next = this.fb.buildFeature(Integer.toString(this.iterationIndex));
                this.fb.reset();
                ++this.iterationIndex;
            }
            return this.next != null;
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("hasNext() returned false!");
            }
            SimpleFeature result = this.next;
            this.next = null;
            return result;
        }
    }

    static class UnitedFeatureCollection
    extends DecoratingSimpleFeatureCollection {
        SimpleFeatureCollection features;
        SimpleFeatureType schema;

        public UnitedFeatureCollection(SimpleFeatureCollection delegate, SimpleFeatureCollection features) throws ClassNotFoundException {
            super(delegate);
            this.features = features;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor descriptor : ((SimpleFeatureType)delegate.getSchema()).getAttributeDescriptors()) {
                if (this.sameNames((SimpleFeatureType)features.getSchema(), descriptor) && !this.sameTypes((SimpleFeatureType)features.getSchema(), descriptor)) {
                    AttributeTypeBuilder builder = new AttributeTypeBuilder();
                    builder.setName(descriptor.getLocalName());
                    builder.setNillable(descriptor.isNillable());
                    builder.setBinding(String.class);
                    builder.setMinOccurs(descriptor.getMinOccurs());
                    builder.setMaxOccurs(descriptor.getMaxOccurs());
                    builder.setDefaultValue(descriptor.getDefaultValue());
                    builder.setCRS(((SimpleFeature)this.delegate.features().next()).getFeatureType().getCoordinateReferenceSystem());
                    AttributeDescriptor attributeDescriptor = builder.buildDescriptor(descriptor.getName(), builder.buildType());
                    tb.add(attributeDescriptor);
                    continue;
                }
                tb.add(descriptor);
            }
            for (AttributeDescriptor descriptor : ((SimpleFeatureType)features.getSchema()).getAttributeDescriptors()) {
                if (this.sameNames((SimpleFeatureType)delegate.getSchema(), descriptor) || this.sameTypes((SimpleFeatureType)delegate.getSchema(), descriptor)) continue;
                tb.add(descriptor);
            }
            tb.setCRS(((SimpleFeatureType)delegate.getSchema()).getCoordinateReferenceSystem());
            tb.setNamespaceURI(((SimpleFeatureType)delegate.getSchema()).getName().getNamespaceURI());
            tb.setName(((SimpleFeatureType)delegate.getSchema()).getName());
            this.schema = tb.buildFeatureType();
        }

        public SimpleFeatureIterator features() {
            return new UnitedFeatureIterator(this.delegate.features(), this.delegate, this.features.features(), this.features, this.getSchema());
        }

        public Iterator<SimpleFeature> iterator() {
            return new WrappingIterator(this.features());
        }

        public void close(Iterator<SimpleFeature> close) {
            if (close instanceof WrappingIterator) {
                ((WrappingIterator)close).close();
            }
        }

        public SimpleFeatureType getSchema() {
            return this.schema;
        }

        private boolean sameNames(SimpleFeatureType schema, AttributeDescriptor f) {
            for (AttributeDescriptor descriptor : schema.getAttributeDescriptors()) {
                if (!descriptor.getName().equals(f.getName())) continue;
                return true;
            }
            return false;
        }

        private boolean sameTypes(SimpleFeatureType schema, AttributeDescriptor f) {
            for (AttributeDescriptor descriptor : schema.getAttributeDescriptors()) {
                if (!descriptor.getType().equals(f.getType())) continue;
                return true;
            }
            return false;
        }
    }
}

