/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.UUID;
import org.geotools.data.DataUtilities;
import org.geotools.data.store.FilteringFeatureCollection;
import org.geotools.feature.CollectionListener;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.feature.collection.SortedSimpleFeatureCollection;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.util.NullProgressListener;
import org.opengis.feature.Feature;
import org.opengis.feature.FeatureVisitor;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.FeatureType;
import org.opengis.filter.Filter;
import org.opengis.filter.sort.SortBy;
import org.opengis.util.ProgressListener;

public abstract class ProcessingCollection<T extends FeatureType, F extends Feature>
implements FeatureCollection<T, F> {
    private static final String READ_ONLY_ERROR = "This collection is read only";
    private T schema;
    private String id = this.getClass().getSimpleName() + "-" + UUID.randomUUID().toString();

    @Override
    public abstract FeatureIterator<F> features();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void accepts(FeatureVisitor visitor, ProgressListener progress) throws IOException {
        float size;
        FeatureIterator<F> iterator = null;
        float f = size = progress != null ? (float)this.size() : 0.0f;
        if (progress == null) {
            progress = new NullProgressListener();
        }
        try {
            float position = 0.0f;
            progress.started();
            iterator = this.features();
            while (iterator.hasNext()) {
                try {
                    F feature = iterator.next();
                    visitor.visit(feature);
                    if (!(size > 0.0f)) continue;
                    float f2 = position;
                    position = f2 + 1.0f;
                    progress.progress(f2 / size);
                }
                catch (Exception erp) {
                    progress.exceptionOccurred((Throwable)erp);
                    throw new IOException("Error occurred while iterating over features", erp);
                    return;
                }
            }
        }
        finally {
            progress.complete();
            this.close(iterator);
        }
    }

    @Override
    public FeatureCollection<T, F> subCollection(Filter filter) {
        return new FilteringFeatureCollection((FeatureCollection)this, filter);
    }

    @Override
    public FeatureCollection<T, F> sort(SortBy order) {
        if (this.schema instanceof SimpleFeatureType) {
            return new SortedSimpleFeatureCollection(DataUtilities.simple((FeatureCollection)this), new SortBy[]{order});
        }
        throw new UnsupportedOperationException("Cannot sort on complex features at the moment");
    }

    @Override
    public abstract ReferencedEnvelope getBounds();

    @Override
    public Iterator<F> iterator() {
        FeatureIterator<F> features = this.features();
        if (features == null) {
            return null;
        }
        return new WrappingIterator<F>(features);
    }

    protected abstract T buildTargetFeatureType();

    @Override
    public abstract int size();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int getFeatureCount() {
        FeatureIterator<F> fi = null;
        try {
            fi = this.features();
            int count = 0;
            while (fi.hasNext()) {
                fi.next();
                ++count;
            }
            int n = count;
            return n;
        }
        finally {
            this.close(fi);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ReferencedEnvelope getFeatureBounds() {
        FeatureIterator<F> fi = null;
        try {
            fi = this.features();
            ReferencedEnvelope bounds = null;
            while (fi.hasNext()) {
                F feature = fi.next();
                ReferencedEnvelope featureEnvelope = null;
                if (feature != null && feature.getBounds() != null) {
                    featureEnvelope = ReferencedEnvelope.reference(feature.getBounds());
                }
                if (featureEnvelope == null) continue;
                if (bounds == null) {
                    bounds = new ReferencedEnvelope(featureEnvelope);
                    continue;
                }
                bounds.expandToInclude(featureEnvelope);
            }
            ReferencedEnvelope referencedEnvelope = bounds;
            return referencedEnvelope;
        }
        finally {
            this.close(fi);
        }
    }

    @Override
    public void close(FeatureIterator<F> fi) {
        if (fi != null) {
            fi.close();
        }
    }

    @Override
    public void close(Iterator<F> close) {
        if (close instanceof WrappingIterator) {
            ((WrappingIterator)close).close();
        }
    }

    @Override
    public void addListener(CollectionListener listener) throws NullPointerException {
    }

    @Override
    public void removeListener(CollectionListener listener) throws NullPointerException {
    }

    @Override
    public T getSchema() {
        if (this.schema == null) {
            this.schema = this.buildTargetFeatureType();
        }
        return this.schema;
    }

    @Override
    public String getID() {
        return this.id;
    }

    @Override
    public void purge() {
    }

    @Override
    public boolean add(F obj) {
        throw new UnsupportedOperationException(READ_ONLY_ERROR);
    }

    @Override
    public boolean addAll(Collection<? extends F> collection) {
        throw new UnsupportedOperationException(READ_ONLY_ERROR);
    }

    @Override
    public boolean addAll(FeatureCollection<? extends T, ? extends F> resource) {
        throw new UnsupportedOperationException(READ_ONLY_ERROR);
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException(READ_ONLY_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean contains(Object o) {
        Iterator<F> e = null;
        try {
            e = this.iterator();
            if (o == null) {
                while (e.hasNext()) {
                    if (e.next() != null) continue;
                    boolean bl = true;
                    return bl;
                }
            } else {
                while (e.hasNext()) {
                    if (!o.equals(e.next())) continue;
                    boolean bl = true;
                    return bl;
                }
            }
            boolean bl = false;
            return bl;
        }
        finally {
            this.close(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> e = c.iterator();
        try {
            while (e.hasNext()) {
                if (this.contains(e.next())) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            if (c instanceof FeatureCollection) {
                ((FeatureCollection)((Object)c)).close(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isEmpty() {
        FeatureIterator<F> fi = null;
        try {
            fi = this.features();
            boolean bl = !fi.hasNext();
            return bl;
        }
        finally {
            this.close(fi);
        }
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException(READ_ONLY_ERROR);
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException(READ_ONLY_ERROR);
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException(READ_ONLY_ERROR);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected List<F> toList() {
        ArrayList<F> result = new ArrayList<F>();
        FeatureIterator<F> fi = null;
        try {
            fi = this.features();
            int i = 0;
            while (fi.hasNext()) {
                result.add(fi.next());
                ++i;
            }
            ArrayList<F> arrayList = result;
            return arrayList;
        }
        finally {
            this.close(fi);
        }
    }

    @Override
    public Object[] toArray() {
        return this.toList().toArray();
    }

    @Override
    public <T> T[] toArray(T[] a) {
        return this.toList().toArray(a);
    }

    private static class WrappingIterator<F extends Feature>
    implements Iterator<F> {
        FeatureIterator<F> delegate;

        public WrappingIterator(FeatureIterator<F> delegate) {
            this.delegate = delegate;
        }

        @Override
        public boolean hasNext() {
            return this.delegate.hasNext();
        }

        @Override
        public F next() {
            return this.delegate.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public void close() {
            this.delegate.close();
        }
    }
}

