/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import com.vividsolutions.jts.densify.Densifier;
import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryFactory;
import com.vividsolutions.jts.geom.GeometryFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.AttributeTypeBuilder;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.JTS;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.gs.WrappingIterator;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory2;
import org.opengis.filter.expression.Expression;
import org.opengis.filter.spatial.Intersects;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

@DescribeProcess(title="Intersection of Feature Collections", description="Spatial intersection of two feature collections, incuding combining attributes from both.")
public class IntersectionFeatureCollection
implements VectorProcess {
    private static final Logger logger = Logger.getLogger("org.geotools.process.feature.gs.IntersectionFeatureCollection");
    static final String ECKERT_IV_WKT = "PROJCS[\"World_Eckert_IV\",GEOGCS[\"GCS_WGS_1984\",DATUM[\"D_WGS_1984\",SPHEROID[\"WGS_1984\",6378137.0,298.257223563]],PRIMEM[\"Greenwich\",0.0],UNIT[\"Degree\",0.0174532925199433]],PROJECTION[\"Eckert_IV\"],PARAMETER[\"Central_Meridian\",0.0],UNIT[\"Meter\",1.0]]";

    @DescribeResult(description="Output feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="first feature collection", description="First feature collection") SimpleFeatureCollection firstFeatures, @DescribeParameter(name="second feature collection", description="Second feature collection") SimpleFeatureCollection secondFeatures, @DescribeParameter(name="first attributes to retain", collectionType=String.class, min=0, description="First feature collection attribute to include") List<String> firstAttributes, @DescribeParameter(name="second attributes to retain", collectionType=String.class, min=0, description="Second feature collection attribute to include") List<String> sndAttributes, @DescribeParameter(name="intersectionMode", min=0, description="Specifies geometry computed for intersecting features.  INTERSECTION (default) computes the spatial intersection of the inputs. FIRST copies geometry A.  SECOND copies geometry B.") IntersectionMode intersectionMode, @DescribeParameter(name="percentagesEnabled", min=0, description="Indicates whether to output feature area percentages (attributes percentageA and percentageB)") Boolean percentagesEnabled, @DescribeParameter(name="areasEnabled", min=0, description="Indicates whether to output feature areas (attributes areaA and areaB)") Boolean areasEnabled) {
        logger.fine("INTERSECTION FEATURE COLLECTION WPS STARTED");
        if (percentagesEnabled == null) {
            percentagesEnabled = false;
        }
        if (areasEnabled == null) {
            areasEnabled = false;
        }
        if (intersectionMode == null) {
            intersectionMode = IntersectionMode.INTERSECTION;
        }
        Class firstGeomType = ((SimpleFeatureType)firstFeatures.getSchema()).getGeometryDescriptor().getType().getBinding();
        Class secondGeomType = ((SimpleFeatureType)secondFeatures.getSchema()).getGeometryDescriptor().getType().getBinding();
        if (!(!percentagesEnabled.booleanValue() && !areasEnabled.booleanValue() || IntersectionFeatureCollection.isGeometryTypeIn(firstGeomType, MultiPolygon.class, Polygon.class) && IntersectionFeatureCollection.isGeometryTypeIn(secondGeomType, MultiPolygon.class, Polygon.class))) {
            throw new IllegalArgumentException("In case of opMode or areaMode are true, the features in the first and second collection must be polygonal");
        }
        if (!IntersectionFeatureCollection.isGeometryTypeIn(firstGeomType, MultiPolygon.class, Polygon.class, MultiLineString.class, LineString.class)) {
            throw new IllegalArgumentException("First feature collection must be polygonal or linear");
        }
        return new IntersectedFeatureCollection(firstFeatures, firstAttributes, secondFeatures, sndAttributes, intersectionMode, percentagesEnabled, areasEnabled);
    }

    static boolean isGeometryTypeIn(Class test, Class ... targets) {
        for (Class target : targets) {
            if (!target.isAssignableFrom(test)) continue;
            return true;
        }
        return false;
    }

    static Geometry densify(Geometry geom, CoordinateReferenceSystem crs, double maxAreaError) throws FactoryException, TransformException {
        if (maxAreaError <= 0.0) {
            throw new IllegalArgumentException("maxAreaError must be greater than 0");
        }
        if (!(geom instanceof Polygon) && !(geom instanceof MultiPolygon)) {
            throw new IllegalArgumentException("Geom must be poligonal");
        }
        if (crs == null) {
            throw new IllegalArgumentException("CRS cannot be set to null");
        }
        double previousArea = 0.0;
        CoordinateReferenceSystem targetCRS = CRS.parseWKT((String)ECKERT_IV_WKT);
        MathTransform firstTransform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)targetCRS);
        GeometryFactory geomFactory = new GeometryFactory();
        int ngeom = geom.getNumGeometries();
        Geometry densifiedGeometry = geom;
        double areaError = 1.0;
        int maxIterate = 0;
        do {
            double max = 0.0;
            ++maxIterate;
            for (int j = 0; j < ngeom; ++j) {
                Geometry geometry = densifiedGeometry.getGeometryN(j);
                Coordinate[] coordinates = geometry.getCoordinates();
                int n = coordinates.length;
                for (int i = 0; i < n - 1; ++i) {
                    Coordinate[] coords = new Coordinate[]{coordinates[i], coordinates[i + 1]};
                    LineString lineString = geomFactory.createLineString(coords);
                    if (!(lineString.getLength() > max)) continue;
                    max = lineString.getLength();
                }
            }
            densifiedGeometry = Densifier.densify(densifiedGeometry, max / 2.0);
            Geometry targetGeometry = JTS.transform(densifiedGeometry, firstTransform);
            double nextArea = targetGeometry.getArea();
            areaError = Math.abs(previousArea - nextArea) / nextArea;
            previousArea = nextArea;
        } while (areaError > maxAreaError && maxIterate < 10);
        return densifiedGeometry;
    }

    static double getIntersectionArea(Geometry first, CoordinateReferenceSystem firstCRS, Geometry second, CoordinateReferenceSystem secondCRS, boolean divideFirst) {
        if (firstCRS == null || secondCRS == null) {
            throw new IllegalArgumentException("CRS cannot be set to null");
        }
        if (!Polygon.class.isAssignableFrom(first.getClass()) && !MultiPolygon.class.isAssignableFrom(first.getClass())) {
            throw new IllegalArgumentException("first geometry must be poligonal");
        }
        if (!Polygon.class.isAssignableFrom(second.getClass()) && !MultiPolygon.class.isAssignableFrom(second.getClass())) {
            throw new IllegalArgumentException("second geometry must be poligonal");
        }
        try {
            Geometry firstTargetGeometry = IntersectionFeatureCollection.reprojectAndDensify(first, firstCRS, null);
            Geometry secondTargetGeometry = IntersectionFeatureCollection.reprojectAndDensify(second, firstCRS, null);
            double numeratorArea = firstTargetGeometry.intersection(secondTargetGeometry).getArea();
            if (divideFirst) {
                double denom = firstTargetGeometry.getArea();
                if (denom != 0.0) {
                    return numeratorArea / denom;
                }
                return 0.0;
            }
            double denom = secondTargetGeometry.getArea();
            if (denom != 0.0) {
                return numeratorArea / denom;
            }
            return 0.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return -1.0;
        }
    }

    static Geometry reprojectAndDensify(Geometry first, CoordinateReferenceSystem sourceCRS, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        if (targetCRS == null) {
            targetCRS = CRS.parseWKT((String)ECKERT_IV_WKT);
        }
        MathTransform firstTransform = CRS.findMathTransform((CoordinateReferenceSystem)sourceCRS, (CoordinateReferenceSystem)targetCRS);
        Geometry geometry = JTS.transform(IntersectionFeatureCollection.densify(first, sourceCRS, 0.01), firstTransform);
        return geometry;
    }

    static AttributeDescriptor getIntersectionType(SimpleFeatureCollection first, SimpleFeatureCollection second) {
        Class firstGeomType = ((SimpleFeatureType)first.getSchema()).getGeometryDescriptor().getType().getBinding();
        Class secondGeomType = ((SimpleFeatureType)second.getSchema()).getGeometryDescriptor().getType().getBinding();
        Class binding = IntersectionFeatureCollection.isGeometryTypeIn(secondGeomType, Point.class) ? Point.class : (IntersectionFeatureCollection.isGeometryTypeIn(secondGeomType, MultiPoint.class) ? MultiPoint.class : (IntersectionFeatureCollection.isGeometryTypeIn(secondGeomType, LineString.class, MultiLineString.class) ? MultiLineString.class : (IntersectionFeatureCollection.isGeometryTypeIn(secondGeomType, Polygon.class, MultiPolygon.class) ? (IntersectionFeatureCollection.isGeometryTypeIn(firstGeomType, Polygon.class, MultiPolygon.class) ? MultiPolygon.class : MultiLineString.class) : Geometry.class)));
        AttributeTypeBuilder builder = new AttributeTypeBuilder();
        builder.setName("the_geom");
        builder.setBinding(binding);
        builder.setCRS(((SimpleFeature)first.features().next()).getFeatureType().getCoordinateReferenceSystem());
        AttributeDescriptor descriptor = builder.buildDescriptor("the_geom");
        return descriptor;
    }

    static class GeometryFilterImpl
    implements GeometryFilter {
        GeometryFactory factory = new GeometryFactory();
        ArrayList<Geometry> collection = new ArrayList();
        Class binding = null;

        GeometryFilterImpl(Class binding) {
            this.binding = binding;
        }

        @Override
        public void filter(Geometry gmtr) {
            if (MultiPolygon.class.isAssignableFrom(this.binding) && gmtr.getArea() != 0.0 && gmtr.getGeometryType().equals("Polygon")) {
                this.collection.add(gmtr);
            }
            if (MultiLineString.class.isAssignableFrom(this.binding) && gmtr.getLength() != 0.0 && gmtr.getGeometryType().equals("LineString")) {
                this.collection.add(gmtr);
            }
            if (MultiPoint.class.isAssignableFrom(this.binding) && gmtr.getNumGeometries() > 0 && gmtr.getGeometryType().equals("Point")) {
                this.collection.add(gmtr);
            }
            if (Point.class.isAssignableFrom(this.binding) && gmtr.getGeometryType().equals("Point")) {
                this.collection.add(gmtr);
            }
        }

        public Geometry getGeometry() {
            int n = this.collection.size();
            if (MultiPolygon.class.isAssignableFrom(this.binding)) {
                Polygon[] array = new Polygon[n];
                for (int i = 0; i < n; ++i) {
                    array[i] = (Polygon)this.collection.get(i);
                }
                return this.factory.createMultiPolygon(array);
            }
            if (MultiLineString.class.isAssignableFrom(this.binding)) {
                LineString[] array = new LineString[n];
                for (int i = 0; i < n; ++i) {
                    array[i] = (LineString)this.collection.get(i);
                }
                return this.factory.createMultiLineString(array);
            }
            if (MultiPoint.class.isAssignableFrom(this.binding)) {
                Point[] array = new Point[n];
                for (int i = 0; i < n; ++i) {
                    array[i] = (Point)this.collection.get(i);
                }
                return this.factory.createMultiPoint(array);
            }
            return null;
        }
    }

    static class IntersectedFeatureIterator
    implements SimpleFeatureIterator {
        SimpleFeatureIterator delegate;
        SimpleFeatureCollection firstFeatures;
        SimpleFeatureCollection secondFeatures;
        SimpleFeatureCollection subFeatureCollection;
        SimpleFeatureBuilder fb;
        SimpleFeature next;
        SimpleFeature first;
        Integer iterationIndex = 0;
        boolean complete = true;
        boolean added = false;
        SimpleFeatureCollection intersectedGeometries;
        SimpleFeatureIterator iterator;
        String dataGeomName;
        List<String> retainAttributesFst = null;
        List<String> retainAttributesSnd = null;
        AttributeDescriptor geomType = null;
        boolean percentagesEnabled;
        boolean areasEnabled;
        IntersectionMode intersectionMode;
        int id = 0;

        public IntersectedFeatureIterator(SimpleFeatureIterator delegate, SimpleFeatureCollection firstFeatures, SimpleFeatureCollection secondFeatures, SimpleFeatureType firstFeatureCollectionSchema, SimpleFeatureType secondFeatureCollectionSchema, List<String> retainAttributesFstPar, List<String> retainAttributesSndPar, IntersectionMode intersectionMode, boolean percentagesEnabled, boolean areasEnabled, SimpleFeatureBuilder sfb) {
            this.retainAttributesFst = retainAttributesFstPar;
            this.retainAttributesSnd = retainAttributesSndPar;
            this.delegate = delegate;
            this.firstFeatures = firstFeatures;
            this.secondFeatures = secondFeatures;
            this.percentagesEnabled = percentagesEnabled;
            this.areasEnabled = areasEnabled;
            this.intersectionMode = intersectionMode;
            logger.fine("Creating schema");
            if (intersectionMode == IntersectionMode.FIRST) {
                this.geomType = firstFeatureCollectionSchema.getGeometryDescriptor();
            }
            if (intersectionMode == IntersectionMode.SECOND) {
                this.geomType = secondFeatureCollectionSchema.getGeometryDescriptor();
            }
            if (intersectionMode == IntersectionMode.INTERSECTION) {
                this.geomType = IntersectionFeatureCollection.getIntersectionType(firstFeatures, secondFeatures);
            }
            this.fb = sfb;
            this.subFeatureCollection = this.secondFeatures;
            this.dataGeomName = ((SimpleFeatureType)this.firstFeatures.getSchema()).getGeometryDescriptor().getLocalName();
            logger.fine("Schema created");
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean hasNext() {
            logger.finer("HAS NEXT");
            while (this.next == null && this.delegate.hasNext() || this.next == null && this.added) {
                if (this.complete) {
                    this.first = (SimpleFeature)this.delegate.next();
                    this.intersectedGeometries = null;
                }
                for (Object attribute : this.first.getAttributes()) {
                    if (!(attribute instanceof Geometry) || !attribute.equals(this.first.getDefaultGeometry())) continue;
                    Geometry currentGeom = (Geometry)attribute;
                    if (this.intersectedGeometries == null && !this.added) {
                        this.intersectedGeometries = this.filteredCollection(currentGeom, this.subFeatureCollection);
                        this.iterator = this.intersectedGeometries.features();
                    }
                    try {
                        while (this.iterator.hasNext()) {
                            this.added = false;
                            SimpleFeature second = (SimpleFeature)this.iterator.next();
                            if (currentGeom.getEnvelope().intersects((Geometry)second.getDefaultGeometry())) {
                                if (this.intersectionMode == IntersectionMode.INTERSECTION) {
                                    attribute = currentGeom.intersection((Geometry)second.getDefaultGeometry());
                                    GeometryFilterImpl filter = new GeometryFilterImpl(this.geomType.getType().getBinding());
                                    ((Geometry)attribute).apply(filter);
                                    attribute = filter.getGeometry();
                                } else if (this.intersectionMode == IntersectionMode.FIRST) {
                                    attribute = currentGeom;
                                } else if (this.intersectionMode == IntersectionMode.SECOND) {
                                    attribute = (Geometry)second.getDefaultGeometry();
                                }
                                if (((Geometry)attribute).getNumGeometries() > 0) {
                                    Integer n;
                                    Integer n2;
                                    this.fb.add(attribute);
                                    this.fb.set("INTERSECTION_ID", (Object)this.id++);
                                    this.addAttributeValues(this.first, this.retainAttributesFst, this.fb);
                                    this.addAttributeValues(second, this.retainAttributesSnd, this.fb);
                                    if (this.percentagesEnabled) {
                                        this.addPercentages(currentGeom, second);
                                    }
                                    if (this.areasEnabled) {
                                        this.addAreas(currentGeom, second);
                                    }
                                    this.next = this.fb.buildFeature(this.iterationIndex.toString());
                                    if (this.iterator.hasNext()) {
                                        this.complete = false;
                                        this.added = true;
                                        n2 = this.iterationIndex;
                                        n = this.iterationIndex = Integer.valueOf(this.iterationIndex + 1);
                                        boolean bl = this.next != null;
                                        return bl;
                                    }
                                    n2 = this.iterationIndex;
                                    n = this.iterationIndex = Integer.valueOf(this.iterationIndex + 1);
                                }
                            }
                            this.complete = false;
                        }
                        this.complete = true;
                    }
                    finally {
                        if (this.added) continue;
                        this.iterator.close();
                    }
                }
            }
            return this.next != null;
        }

        private void addAttributeValues(SimpleFeature feature, List<String> retained, SimpleFeatureBuilder fb) {
            for (AttributeDescriptor ad : feature.getType().getAttributeDescriptors()) {
                Object firstAttribute = feature.getAttribute(ad.getLocalName());
                if (retained != null && !retained.contains(ad.getLocalName()) || firstAttribute instanceof Geometry) continue;
                fb.add(feature.getAttribute(ad.getLocalName()));
            }
        }

        private void addAreas(Geometry currentGeom, SimpleFeature second) {
            CoordinateReferenceSystem firstCRS = ((SimpleFeatureType)this.firstFeatures.getSchema()).getCoordinateReferenceSystem();
            CoordinateReferenceSystem secondCRS = ((SimpleFeatureType)this.secondFeatures.getSchema()).getCoordinateReferenceSystem();
            try {
                double areaA = IntersectionFeatureCollection.reprojectAndDensify(currentGeom, firstCRS, null).getArea();
                double areaB = IntersectionFeatureCollection.reprojectAndDensify((Geometry)second.getDefaultGeometry(), secondCRS, null).getArea();
                this.fb.set("areaA", (Object)areaA);
                this.fb.set("areaB", (Object)areaB);
            }
            catch (Exception e) {
                System.out.println("" + e);
                this.fb.set("areaA", (Object)-1);
                this.fb.set("areaB", (Object)-1);
            }
        }

        private void addPercentages(Geometry currentGeom, SimpleFeature second) {
            CoordinateReferenceSystem firstCRS = ((SimpleFeatureType)this.firstFeatures.getSchema()).getCoordinateReferenceSystem();
            CoordinateReferenceSystem secondCRS = ((SimpleFeatureType)this.secondFeatures.getSchema()).getCoordinateReferenceSystem();
            double percentageA = IntersectionFeatureCollection.getIntersectionArea(currentGeom, firstCRS, (Geometry)second.getDefaultGeometry(), secondCRS, true);
            double percentageB = IntersectionFeatureCollection.getIntersectionArea(currentGeom, firstCRS, (Geometry)second.getDefaultGeometry(), secondCRS, false);
            this.fb.set("percentageA", (Object)percentageA);
            this.fb.set("percentageB", (Object)percentageB);
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("hasNext() returned false!");
            }
            SimpleFeature result = this.next;
            this.next = null;
            return result;
        }

        private SimpleFeatureCollection filteredCollection(Geometry currentGeom, SimpleFeatureCollection subFeatureCollection) {
            FilterFactory2 ff = CommonFactoryFinder.getFilterFactory2(null);
            Intersects intersectFilter = ff.intersects((Expression)ff.property(this.dataGeomName), (Expression)ff.literal((Object)currentGeom));
            SimpleFeatureCollection subFeatureCollectionIntersection = this.subFeatureCollection.subCollection((Filter)intersectFilter);
            if (subFeatureCollectionIntersection.size() == 0) {
                subFeatureCollectionIntersection = subFeatureCollection;
            }
            return subFeatureCollectionIntersection;
        }
    }

    static class IntersectedFeatureCollection
    extends DecoratingSimpleFeatureCollection {
        SimpleFeatureCollection features;
        List<String> firstAttributes = null;
        List<String> sndAttributes = null;
        IntersectionMode intersectionMode;
        boolean percentagesEnabled;
        boolean areasEnabled;
        SimpleFeatureBuilder fb;
        AttributeDescriptor geomType = null;

        public SimpleFeatureType getSchema() {
            return this.fb.getFeatureType();
        }

        public IntersectedFeatureCollection(SimpleFeatureCollection delegate, List<String> firstAttributes, SimpleFeatureCollection features, List<String> sndAttributes, IntersectionMode intersectionMode, boolean percentagesEnabled, boolean areasEnabled) {
            super(delegate);
            this.features = features;
            this.firstAttributes = firstAttributes;
            this.sndAttributes = sndAttributes;
            this.intersectionMode = intersectionMode;
            this.percentagesEnabled = percentagesEnabled;
            this.areasEnabled = areasEnabled;
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            SimpleFeatureType firstFeatureCollectionSchema = (SimpleFeatureType)delegate.getSchema();
            SimpleFeatureType secondFeatureCollectionSchema = (SimpleFeatureType)features.getSchema();
            if (intersectionMode == IntersectionMode.FIRST) {
                this.geomType = firstFeatureCollectionSchema.getGeometryDescriptor();
            }
            if (intersectionMode == IntersectionMode.SECOND) {
                this.geomType = secondFeatureCollectionSchema.getGeometryDescriptor();
            }
            if (intersectionMode == IntersectionMode.INTERSECTION) {
                this.geomType = IntersectionFeatureCollection.getIntersectionType(delegate, features);
            }
            tb.add(this.geomType);
            this.collectAttributes(firstFeatureCollectionSchema, firstAttributes, tb);
            this.collectAttributes(secondFeatureCollectionSchema, sndAttributes, tb);
            if (percentagesEnabled) {
                tb.add("percentageA", Double.class);
                tb.add("percentageB", Double.class);
            }
            if (areasEnabled) {
                tb.add("areaA", Double.class);
                tb.add("areaB", Double.class);
            }
            tb.add("INTERSECTION_ID", Integer.class);
            tb.setDescription(firstFeatureCollectionSchema.getDescription());
            tb.setCRS(firstFeatureCollectionSchema.getCoordinateReferenceSystem());
            tb.setAbstract(firstFeatureCollectionSchema.isAbstract());
            tb.setSuperType((SimpleFeatureType)firstFeatureCollectionSchema.getSuper());
            tb.setName(firstFeatureCollectionSchema.getName());
            this.fb = new SimpleFeatureBuilder(tb.buildFeatureType());
        }

        private void collectAttributes(SimpleFeatureType schema, List<String> retainedAttributes, SimpleFeatureTypeBuilder tb) {
            for (AttributeDescriptor descriptor : schema.getAttributeDescriptors()) {
                boolean isInRetainList = true;
                if (retainedAttributes != null) {
                    isInRetainList = retainedAttributes.contains(descriptor.getLocalName());
                    logger.fine("Checking " + descriptor.getLocalName() + " --> " + isInRetainList);
                }
                if (!isInRetainList || schema.getGeometryDescriptor() == descriptor) continue;
                AttributeTypeBuilder builder = new AttributeTypeBuilder();
                builder.setName(schema.getName().getLocalPart() + "_" + descriptor.getName());
                builder.setNillable(descriptor.isNillable());
                builder.setBinding(descriptor.getType().getBinding());
                builder.setMinOccurs(descriptor.getMinOccurs());
                builder.setMaxOccurs(descriptor.getMaxOccurs());
                builder.setDefaultValue(descriptor.getDefaultValue());
                builder.setCRS(schema.getCoordinateReferenceSystem());
                AttributeDescriptor intersectionDescriptor = builder.buildDescriptor(schema.getName().getLocalPart() + "_" + descriptor.getName(), descriptor.getType());
                tb.add(intersectionDescriptor);
                tb.addBinding(descriptor.getType());
            }
        }

        public SimpleFeatureIterator features() {
            return new IntersectedFeatureIterator(this.delegate.features(), this.delegate, this.features, (SimpleFeatureType)this.delegate.getSchema(), (SimpleFeatureType)this.features.getSchema(), this.firstAttributes, this.sndAttributes, this.intersectionMode, this.percentagesEnabled, this.areasEnabled, this.fb);
        }

        public Iterator<SimpleFeature> iterator() {
            return new WrappingIterator(this.features());
        }

        public void close(Iterator<SimpleFeature> close) {
            if (close instanceof WrappingIterator) {
                ((WrappingIterator)close).close();
            }
        }
    }

    public static enum IntersectionMode {
        INTERSECTION,
        FIRST,
        SECOND;

    }
}

