/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import java.io.IOException;
import org.geotools.feature.FeatureCollection;
import org.geotools.feature.FeatureIterator;
import org.geotools.geometry.jts.GeometryCollector;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.vector.VectorProcess;
import org.opengis.util.ProgressListener;

@DescribeProcess(title="Collect Geometries", description="Collects the deafult geometries of the input features and combines them into a single geometry collection")
public class CollectGeometries
implements VectorProcess {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @DescribeResult(name="result", description="Geometry collection of all input geometries")
    public GeometryCollection execute(@DescribeParameter(name="features", description="Input feature collection") FeatureCollection features, ProgressListener progressListener) throws IOException {
        int count = features.size();
        float done = 0.0f;
        FeatureIterator fi = null;
        GeometryCollector collector = new GeometryCollector();
        try {
            fi = features.features();
            while (fi.hasNext()) {
                Geometry g = (Geometry)fi.next().getDefaultGeometryProperty().getValue();
                collector.add(g);
                if (progressListener == null || (done += 1.0f) % 100.0f != 0.0f) continue;
                progressListener.progress(done / (float)count);
            }
        }
        finally {
            if (fi != null) {
                fi.close();
            }
        }
        return collector.collect();
    }
}

