/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.process.vector;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.GeometryCollection;
import com.vividsolutions.jts.geom.GeometryComponentFilter;
import com.vividsolutions.jts.geom.LineString;
import com.vividsolutions.jts.geom.MultiLineString;
import com.vividsolutions.jts.geom.MultiPoint;
import com.vividsolutions.jts.geom.MultiPolygon;
import com.vividsolutions.jts.geom.Point;
import com.vividsolutions.jts.geom.Polygon;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.feature.collection.DecoratingSimpleFeatureCollection;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.geometry.jts.GeometryClipper;
import org.geotools.process.ProcessException;
import org.geotools.process.factory.DescribeParameter;
import org.geotools.process.factory.DescribeProcess;
import org.geotools.process.factory.DescribeResult;
import org.geotools.process.gs.WrappingIterator;
import org.geotools.process.vector.VectorProcess;
import org.geotools.referencing.CRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.feature.type.GeometryDescriptor;
import org.opengis.filter.Filter;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.spatial.BBOX;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

@DescribeProcess(title="Clip", description="Clips (crops) features to a given geometry")
public class ClipProcess
implements VectorProcess {
    @DescribeResult(name="result", description="Clipped feature collection")
    public SimpleFeatureCollection execute(@DescribeParameter(name="features", description="Input feature collection") SimpleFeatureCollection features, @DescribeParameter(name="clip", description="Geometry to use for clipping (in same CRS as input features)") Geometry clip) throws ProcessException {
        Envelope box = clip.getEnvelopeInternal();
        FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
        String srs = null;
        if (((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem() != null) {
            srs = CRS.toSRS((CoordinateReferenceSystem)((SimpleFeatureType)features.getSchema()).getCoordinateReferenceSystem());
        }
        BBOX bboxFilter = ff.bbox("", box.getMinX(), box.getMinY(), box.getMaxX(), box.getMaxY(), srs);
        return new ClippingFeatureCollection(features.subCollection((Filter)bboxFilter), clip);
    }

    static class ClippingFeatureIterator
    implements SimpleFeatureIterator {
        SimpleFeatureIterator delegate;
        GeometryClipper clipper;
        boolean preserveTopology;
        SimpleFeatureBuilder fb;
        SimpleFeature next;
        Geometry clip;

        public ClippingFeatureIterator(SimpleFeatureIterator delegate, Geometry clip, SimpleFeatureType schema) {
            this.delegate = delegate;
            if (clip.getEnvelope().equals(clip)) {
                this.clipper = new GeometryClipper(clip.getEnvelopeInternal());
            } else {
                this.clip = clip;
            }
            this.fb = new SimpleFeatureBuilder(schema);
        }

        @Override
        public void close() {
            this.delegate.close();
        }

        @Override
        public boolean hasNext() {
            while (this.next == null && this.delegate.hasNext()) {
                boolean clippedOut = false;
                SimpleFeature f = (SimpleFeature)this.delegate.next();
                for (AttributeDescriptor ad : f.getFeatureType().getAttributeDescriptors()) {
                    Class target;
                    Object attribute = f.getAttribute(ad.getName());
                    if (ad instanceof GeometryDescriptor && (attribute = this.clipGeometry((Geometry)attribute, target = ad.getType().getBinding())) == null && f.getFeatureType().getGeometryDescriptor() == ad) {
                        this.fb.reset();
                        clippedOut = true;
                        break;
                    }
                    this.fb.add(attribute);
                }
                if (!clippedOut) {
                    this.next = this.fb.buildFeature(f.getID());
                }
                this.fb.reset();
            }
            return this.next != null;
        }

        @Override
        public SimpleFeature next() throws NoSuchElementException {
            if (!this.hasNext()) {
                throw new NoSuchElementException("hasNext() returned false!");
            }
            SimpleFeature result = this.next;
            this.next = null;
            return result;
        }

        private Object clipGeometry(Geometry geom, Class target) {
            Geometry clipped = null;
            if (this.clipper != null) {
                clipped = this.clipper.clip(geom, true);
            } else if (geom.getEnvelopeInternal().intersects(this.clip.getEnvelopeInternal())) {
                clipped = this.clip.intersection(geom);
            }
            if (clipped == null || clipped.getNumGeometries() == 0) {
                return null;
            }
            if (Point.class.isAssignableFrom(target) || MultiPoint.class.isAssignableFrom(target) || GeometryCollection.class.equals((Object)target)) {
                return clipped;
            }
            if (MultiLineString.class.isAssignableFrom(target)) {
                final ArrayList geoms = new ArrayList();
                clipped.apply(new GeometryComponentFilter(){

                    @Override
                    public void filter(Geometry geom) {
                        if (geom instanceof LineString) {
                            geoms.add((LineString)geom);
                        }
                    }
                });
                LineString[] lsArray = geoms.toArray(new LineString[geoms.size()]);
                return geom.getFactory().createMultiLineString(lsArray);
            }
            if (MultiPolygon.class.isAssignableFrom(target)) {
                final ArrayList geoms = new ArrayList();
                clipped.apply(new GeometryComponentFilter(){

                    @Override
                    public void filter(Geometry geom) {
                        if (geom instanceof Polygon) {
                            geoms.add((Polygon)geom);
                        }
                    }
                });
                Polygon[] lsArray = geoms.toArray(new Polygon[geoms.size()]);
                return geom.getFactory().createMultiPolygon(lsArray);
            }
            throw new RuntimeException("Unrecognized target type " + target.getCanonicalName());
        }
    }

    static class ClippingFeatureCollection
    extends DecoratingSimpleFeatureCollection {
        Geometry clip;
        SimpleFeatureType targetSchema;

        public ClippingFeatureCollection(SimpleFeatureCollection delegate, Geometry clip) {
            super(delegate);
            this.clip = clip;
            this.targetSchema = this.buildTargetSchema((SimpleFeatureType)delegate.getSchema());
        }

        private SimpleFeatureType buildTargetSchema(SimpleFeatureType schema) {
            SimpleFeatureTypeBuilder tb = new SimpleFeatureTypeBuilder();
            for (AttributeDescriptor ad : schema.getAttributeDescriptors()) {
                if (ad instanceof GeometryDescriptor) {
                    Class target;
                    GeometryDescriptor gd = (GeometryDescriptor)ad;
                    Class binding = ad.getType().getBinding();
                    if (Point.class.isAssignableFrom(binding) || GeometryCollection.class.isAssignableFrom(binding)) {
                        tb.add(ad);
                        continue;
                    }
                    if (LineString.class.isAssignableFrom(binding)) {
                        target = MultiLineString.class;
                    } else if (Polygon.class.isAssignableFrom(binding)) {
                        target = MultiPolygon.class;
                    } else {
                        throw new RuntimeException("Don't know how to handle geometries of type " + binding.getCanonicalName());
                    }
                    tb.minOccurs(ad.getMinOccurs());
                    tb.maxOccurs(ad.getMaxOccurs());
                    tb.nillable(ad.isNillable());
                    tb.add(ad.getLocalName(), target, gd.getCoordinateReferenceSystem());
                    continue;
                }
                tb.add(ad);
            }
            tb.setName(schema.getName());
            return tb.buildFeatureType();
        }

        public SimpleFeatureType getSchema() {
            return this.targetSchema;
        }

        public SimpleFeatureIterator features() {
            return new ClippingFeatureIterator(this.delegate.features(), this.clip, this.getSchema());
        }

        public Iterator<SimpleFeature> iterator() {
            return new WrappingIterator(this.features());
        }

        public void close(Iterator<SimpleFeature> close) {
            if (close instanceof WrappingIterator) {
                ((WrappingIterator)close).close();
            }
        }
    }
}

