/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.utils;

import eu.udig.tools.jgrass.i18n.Messages;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.LinkedList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.command.CompositeCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.EditCommandFactory;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.tool.IToolContext;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.data.DataUtilities;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;

public class OperationUtils {
    protected void showMessage(final Display display, final String title, final String msg, final MSGTYPE type) {
        display.asyncExec(new Runnable(){

            @Override
            public void run() {
                switch (type) {
                    case INFO: {
                        MessageDialog.openInformation((Shell)display.getActiveShell(), (String)title, (String)msg);
                        break;
                    }
                    case ERROR: {
                        MessageDialog.openError((Shell)display.getActiveShell(), (String)title, (String)msg);
                        break;
                    }
                    case WARNING: {
                        MessageDialog.openWarning((Shell)display.getActiveShell(), (String)title, (String)msg);
                        break;
                    }
                }
            }
        });
    }

    protected void moveFeatures(Display display, IProgressMonitor monitor, ILayer selectedLayer, boolean moveUp) throws IOException {
        CompositeCommand compositeCommand;
        SimpleFeatureType selectedSchema;
        IMap activeMap;
        List mapLayers;
        int currentPosition;
        int toPosition;
        SimpleFeatureSource featureSource = (SimpleFeatureSource)selectedLayer.getResource(FeatureSource.class, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
        if (featureSource == null) {
            return;
        }
        int delta = 1;
        if (!moveUp) {
            delta = -1;
        }
        if ((toPosition = (currentPosition = (mapLayers = (activeMap = ApplicationGIS.getActiveMap()).getMapLayers()).indexOf(selectedLayer)) + delta) < 0 || toPosition > mapLayers.size() - 1) {
            this.showMessage(display, Messages.getString("OperationUtils_warning"), Messages.getString("OperationUtils_nolayer"), MSGTYPE.WARNING);
            return;
        }
        ILayer toLayer = (ILayer)mapLayers.get(toPosition);
        SimpleFeatureType toSchema = toLayer.getSchema();
        int compare = DataUtilities.compare((SimpleFeatureType)toSchema, (SimpleFeatureType)(selectedSchema = selectedLayer.getSchema()));
        if (compare != 0) {
            this.showMessage(display, Messages.getString("OperationUtils_warning"), Messages.getString("OperationUtils_sametypeproblem"), MSGTYPE.WARNING);
            return;
        }
        SimpleFeatureCollection featureCollection = featureSource.getFeatures(selectedLayer.getQuery(true));
        if (featureCollection.size() < 1) {
            this.showMessage(display, Messages.getString("OperationUtils_warning"), Messages.getString("OperationUtils_nofeaturesproblem"), MSGTYPE.WARNING);
            return;
        }
        SimpleFeatureIterator featureIterator = featureCollection.features();
        EditCommandFactory cmdFactory = EditCommandFactory.getInstance();
        LinkedList<UndoableMapCommand> copyOverList = new LinkedList<UndoableMapCommand>();
        LinkedList<UndoableMapCommand> deleteOldList = new LinkedList<UndoableMapCommand>();
        int count = 0;
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            UndoableMapCommand addFeatureCmd = cmdFactory.createAddFeatureCommand(feature, toLayer);
            copyOverList.add(addFeatureCmd);
            UndoableMapCommand deleteFeatureCmd = cmdFactory.createDeleteFeature(feature, selectedLayer);
            deleteOldList.add(deleteFeatureCmd);
            ++count;
        }
        IToolContext toolContext = ApplicationGIS.createContext((IMap)ApplicationGIS.getActiveMap());
        try {
            compositeCommand = new CompositeCommand(copyOverList);
            toolContext.sendSyncCommand((Command)compositeCommand);
        }
        catch (Exception exception) {
            this.showMessage(display, Messages.getString("OperationUtils_error"), Messages.getString("OperationUtils_copyproblem"), MSGTYPE.ERROR);
            return;
        }
        try {
            compositeCommand = new CompositeCommand(deleteOldList);
            toolContext.sendSyncCommand((Command)compositeCommand);
            this.showMessage(display, Messages.getString("OperationUtils_info"), MessageFormat.format(Messages.getString("OperationUtils_movedinfo"), count), MSGTYPE.WARNING);
        }
        catch (Exception exception) {
            this.showMessage(display, Messages.getString("OperationUtils_error"), Messages.getString("OperationUtils_deleteproblem"), MSGTYPE.ERROR);
        }
    }

    public static enum MSGTYPE {
        INFO,
        ERROR,
        WARNING;

    }
}

