/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.utils;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.LineSegment;
import java.awt.Color;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.GeneralPath;
import net.refractions.udig.project.render.displayAdapter.IMapDisplay;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseListener;
import net.refractions.udig.project.ui.render.displayAdapter.ViewportPane;
import org.eclipse.core.runtime.IProgressMonitor;

public class ArrowDrawCommand
extends AbstractDrawCommand {
    private Coordinate start;
    private Coordinate end;
    private Rectangle validArea;
    private Color lineColor1 = new Color(255, 0, 0, 255);
    private Color lineColor2 = new Color(0, 0, 0, 255);
    private MapMouseListener mouseListener = new MapMouseListener(){

        public void mouseDoubleClicked(MapMouseEvent event) {
        }

        public void mouseEntered(MapMouseEvent event) {
        }

        public void mouseExited(MapMouseEvent event) {
            ArrowDrawCommand.this.disable((ViewportPane)event.source, this);
        }

        public void mousePressed(MapMouseEvent event) {
            ArrowDrawCommand.this.disable((ViewportPane)event.source, this);
        }

        public void mouseReleased(MapMouseEvent event) {
        }
    };

    public ArrowDrawCommand(Coordinate start, Coordinate end) {
        this.start = start;
        this.end = end;
    }

    public void run(IProgressMonitor monitor) throws Exception {
        this.display.addMouseListener(this.mouseListener);
        LineSegment l = new LineSegment(this.start, this.end);
        this.start = l.pointAlong(0.1);
        this.end = l.pointAlong(0.9);
        l = new LineSegment(this.start, this.end);
        Coordinate tmp = l.pointAlong(0.9);
        double distance = this.end.distance(tmp);
        Coordinate left = l.pointAlongOffset(0.5, distance / 2.0);
        Coordinate right = l.pointAlongOffset(0.5, -distance / 2.0);
        this.validArea = new Rectangle((int)this.start.x, (int)this.start.y, (int)(this.start.x + (this.end.x - this.start.x)), (int)(this.start.y + (this.end.y - this.start.y)));
        this.graphics.setLineWidth(3);
        this.graphics.setColor(this.lineColor2);
        this.graphics.drawLine((int)this.start.x, (int)this.start.y, (int)tmp.x, (int)tmp.y);
        this.graphics.setLineWidth(1);
        this.graphics.setColor(this.lineColor1);
        this.graphics.drawLine((int)this.start.x, (int)this.start.y, (int)tmp.x, (int)tmp.y);
        GeneralPath path = new GeneralPath();
        path.moveTo(this.end.x, this.end.y);
        path.lineTo(left.x, left.y);
        path.lineTo(right.x, right.y);
        path.closePath();
        this.graphics.fill((Shape)path);
        this.graphics.setColor(this.lineColor2);
        this.graphics.draw((Shape)path);
    }

    public Rectangle getValidArea() {
        return this.validArea;
    }

    public void setValid(boolean valid) {
        super.setValid(valid);
        this.display.removeMouseListener(this.mouseListener);
    }

    void disable(ViewportPane pane, Object listener) {
        if (!this.isValid((IMapDisplay)pane)) {
            if (listener instanceof MapMouseListener) {
                pane.removeMouseListener((MapMouseListener)listener);
            }
            return;
        }
        this.setValid(false);
        pane.repaint();
    }

    private boolean isValid(IMapDisplay source) {
        if (!this.isValid()) {
            return false;
        }
        return source == this.display;
    }
}

