/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.utils;

import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.progress.IProgressService;

public abstract class AbstractHandlerCommand
extends AbstractHandler {
    public abstract Object execute(ExecutionEvent var1) throws ExecutionException;

    protected void runOp(final IOp op, Class<?> checkClass) throws Exception {
        Object resource;
        final ILayer selectedLayer = ApplicationGIS.getActiveMap().getEditManager().getSelectedLayer();
        if (selectedLayer == null) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            MessageDialog.openWarning((Shell)shell, (String)"WARNING", (String)"No layer selected");
            return;
        }
        if (checkClass != null && (resource = selectedLayer.getResource(checkClass, (IProgressMonitor)new NullProgressMonitor())) == null) {
            Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
            MessageDialog.openWarning((Shell)shell, (String)"WARNING", (String)"The launched operation is not applicable on the selected layer.");
            return;
        }
        IWorkbench wb = PlatformUI.getWorkbench();
        IProgressService ps = wb.getProgressService();
        ps.busyCursorWhile(new IRunnableWithProgress(){

            public void run(IProgressMonitor pm) {
                try {
                    op.op(Display.getDefault(), (Object)selectedLayer, pm);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

