/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.profile;

import com.vividsolutions.jts.geom.Coordinate;
import eu.udig.tools.jgrass.profile.ProfileView;
import eu.udig.tools.jgrass.profile.borrowedfromjgrasstools.CoverageUtilities;
import eu.udig.tools.jgrass.profile.borrowedfromjgrasstools.ProfilePoint;
import eu.udig.tools.jgrass.profile.borrowedfromjgrasstools.RegionMap;
import java.awt.Color;
import java.awt.Point;
import java.awt.Rectangle;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.EditManagerEvent;
import net.refractions.udig.project.IEditManager;
import net.refractions.udig.project.IEditManagerListener;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.command.Command;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.project.ui.commands.AbstractDrawCommand;
import net.refractions.udig.project.ui.render.displayAdapter.MapMouseEvent;
import net.refractions.udig.project.ui.tool.SimpleTool;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.ViewType;
import org.geotools.geometry.jts.JTS;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class ProfileTool
extends SimpleTool
implements IEditManagerListener {
    private int currentPointNumber = 0;
    private List<Point> points = new ArrayList<Point>();
    private ProfileFeedbackCommand command;
    private Point now;
    private double latestProgessiveDistance = 0.0;
    private boolean doubleClicked = false;
    private GridCoverage2D rasterMapResource;
    private ProfileView chartView;
    private Coordinate begin;
    private double step;
    private ILayer selectedLayer;

    public ProfileTool() {
        super(3);
        IEditManager editManager = ApplicationGIS.getActiveMap().getEditManager();
        editManager.addListener((IEditManagerListener)this);
        this.selectedLayer = editManager.getSelectedLayer();
    }

    protected void onMousePressed(MapMouseEvent e) {
        super.onMousePressed(e);
        this.checkFirstActivation();
    }

    protected void onMouseMoved(MapMouseEvent e) {
        if (!this.doubleClicked) {
            this.now = e.getPoint();
            if (this.command == null || this.points.isEmpty()) {
                return;
            }
            Rectangle area = this.command.getValidArea();
            if (area != null) {
                this.getContext().getViewportPane().repaint(area.x, area.y, area.width, area.height);
            } else {
                this.getContext().getViewportPane().repaint();
            }
        }
    }

    public void onMouseReleased(MapMouseEvent e) {
        if (this.now == null) {
            return;
        }
        if (this.currentPointNumber == 0) {
            this.chartView.clearSeries();
            this.latestProgessiveDistance = 0.0;
            this.points.clear();
            this.disposeCommand();
            this.doubleClicked = false;
            this.chartView.clearMarkers();
        }
        Point current = e.getPoint();
        if (this.points.isEmpty() || !current.equals(this.points.get(this.points.size() - 1))) {
            this.points.add(current);
        }
        if (this.command == null || !this.command.isValid()) {
            this.command = new ProfileFeedbackCommand();
            this.getContext().sendASyncCommand((Command)this.command);
        }
        try {
            this.profile(null);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            String message = "An error occurred while extracting the profile from the map.";
            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)ex);
        }
    }

    protected void onMouseDoubleClicked(MapMouseEvent e) {
        this.currentPointNumber = 0;
        this.doubleClicked = true;
    }

    private void disposeCommand() {
        if (this.command != null) {
            this.command.setValid(false);
            Rectangle area = this.command.getValidArea();
            if (area != null) {
                this.getContext().getViewportPane().repaint(area.x, area.y, area.width, area.height);
            } else {
                this.getContext().getViewportPane().repaint();
            }
            this.command = null;
        }
    }

    private void profile(IProgressMonitor monitor) throws Exception {
        if (this.points.size() == this.currentPointNumber && this.points.size() > 1) {
            return;
        }
        if (!this.doubleClicked) {
            this.currentPointNumber = this.points.size();
        }
        if (this.points.size() == 1) {
            Point beforeLastPoint = this.points.get(0);
            this.begin = this.getContext().pixelToWorld(beforeLastPoint.x, beforeLastPoint.y);
        } else if (this.points.size() > 1) {
            Point lastPoint = this.points.get(this.points.size() - 1);
            Coordinate end = this.getContext().pixelToWorld(lastPoint.x, lastPoint.y);
            final List<ProfilePoint> profile = CoverageUtilities.doProfile(this.rasterMapResource, this.step, this.begin, end);
            this.begin = end;
            Display.getDefault().syncExec(new Runnable(){

                @Override
                public void run() {
                    for (ProfilePoint profilePoint : profile) {
                        double elevation = profilePoint.getElevation();
                        ProfileTool.this.chartView.addToSeries(ProfileTool.this.latestProgessiveDistance + profilePoint.getProgressive(), elevation);
                    }
                    ProfilePoint last = (ProfilePoint)profile.get(profile.size() - 1);
                    ProfileTool.this.chartView.addStopLine(ProfileTool.this.latestProgessiveDistance + last.getProgressive());
                    ProfileTool.this.chartView.setRangeToDataBounds();
                    ProfileTool profileTool = ProfileTool.this;
                    profileTool.latestProgessiveDistance = profileTool.latestProgessiveDistance + last.getProgressive();
                }
            });
        }
    }

    public void setActive(boolean active) {
        if (!active) {
            this.cleanupOnDeactivation();
            IEditManager editManager = ApplicationGIS.getActiveMap().getEditManager();
            editManager.removeListener((IEditManagerListener)this);
        }
        super.setActive(active);
    }

    private void cleanupOnDeactivation() {
        this.rasterMapResource = null;
        this.now = null;
        this.points.clear();
        this.doubleClicked = false;
        this.disposeCommand();
    }

    private void checkFirstActivation() {
        if (this.rasterMapResource == null) {
            final IGeoResource geoResource = this.selectedLayer.getGeoResource();
            if (geoResource.canResolve(GridCoverage.class)) {
                IRunnableWithProgress operation = new IRunnableWithProgress(){

                    public void run(IProgressMonitor pm) throws InvocationTargetException, InterruptedException {
                        try {
                            ProfileTool.this.rasterMapResource = (GridCoverage2D)geoResource.resolve(GridCoverage.class, (IProgressMonitor)new NullProgressMonitor());
                            ProfileTool.this.rasterMapResource = ProfileTool.this.rasterMapResource.view(ViewType.GEOPHYSICS);
                            RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(ProfileTool.this.rasterMapResource);
                            double xres = regionMap.getXres();
                            double yres = regionMap.getYres();
                            ProfileTool.this.step = Math.min(xres, yres);
                            Display.getDefault().syncExec(new Runnable(){

                                @Override
                                public void run() {
                                    IStatusLineManager statusBar = ProfileTool.this.getContext().getActionBars().getStatusLineManager();
                                    ProfileTool.this.disposeCommand();
                                    if (statusBar == null) {
                                        return;
                                    }
                                    statusBar.setErrorMessage(null);
                                    statusBar.setMessage(null);
                                    try {
                                        PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.udig.tools.jgrass.profileview");
                                    }
                                    catch (PartInitException e) {
                                        e.printStackTrace();
                                    }
                                    ProfileTool.this.chartView = (ProfileView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("eu.udig.tools.jgrass.profileview");
                                }
                            });
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            String message = "Profile tool error";
                            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e);
                        }
                    }
                };
                PlatformGIS.runInProgressDialog((String)"Reading map for profile...", (boolean)false, (IRunnableWithProgress)operation, (boolean)false);
            } else {
                this.getContext().updateUI(new Runnable(){

                    @Override
                    public void run() {
                        Shell shell = PlatformUI.getWorkbench().getDisplay().getActiveShell();
                        MessageBox msgBox = new MessageBox(shell, 1);
                        msgBox.setMessage("The selected layer can't be read by the available datastores. Unable to create a profile on it.");
                        msgBox.open();
                    }
                });
                super.setActive(false);
                return;
            }
        }
    }

    private double distance() throws TransformException {
        Coordinate end;
        Coordinate begin;
        Point current;
        if (this.points.isEmpty()) {
            return 0.0;
        }
        Iterator<Point> iter = this.points.iterator();
        Point start = iter.next();
        double distance = 0.0;
        while (iter.hasNext()) {
            current = iter.next();
            begin = this.getContext().pixelToWorld(start.x, start.y);
            end = this.getContext().pixelToWorld(current.x, current.y);
            distance += JTS.orthodromicDistance((Coordinate)begin, (Coordinate)end, (CoordinateReferenceSystem)this.getContext().getCRS());
            start = current;
        }
        if (this.now != null) {
            current = this.now;
            begin = this.getContext().pixelToWorld(start.x, start.y);
            end = this.getContext().pixelToWorld(current.x, current.y);
            distance += JTS.orthodromicDistance((Coordinate)begin, (Coordinate)end, (CoordinateReferenceSystem)this.getContext().getCRS());
        }
        return distance;
    }

    private void displayOnStatusBar(double distance) {
        final IStatusLineManager statusBar = this.getContext().getActionBars().getStatusLineManager();
        if (statusBar == null) {
            return;
        }
        final String message = this.createMessage(distance);
        this.getContext().updateUI(new Runnable(){

            @Override
            public void run() {
                statusBar.setErrorMessage(null);
                statusBar.setMessage(message);
            }
        });
    }

    private String createMessage(double distance) {
        String message = "";
        message = distance > 100000.0 ? message.concat(String.valueOf((int)(distance / 1000.0)) + " km") : (distance > 10000.0 ? message.concat(String.valueOf(this.round(distance / 1000.0, 1)) + " km") : (distance > 1000.0 ? message.concat(String.valueOf(this.round(distance / 1000.0, 2)) + " km") : (distance > 100.0 ? message.concat(String.valueOf(this.round(distance, 1)) + " m") : (distance > 1.0 ? message.concat(String.valueOf(this.round(distance, 2)) + " m") : message.concat(String.valueOf(this.round(distance * 1000.0, 1)) + " mm")))));
        return message;
    }

    private double round(double value, int decimalPlaces) {
        double divisor = Math.pow(10.0, decimalPlaces);
        double newVal = value * divisor;
        newVal = (double)Long.valueOf(Math.round(newVal)).intValue() / divisor;
        return newVal;
    }

    public void changed(EditManagerEvent event) {
        if (event.getType() == 5) {
            this.cleanupOnDeactivation();
            this.selectedLayer = (ILayer)event.getNewValue();
        }
    }

    class ProfileFeedbackCommand
    extends AbstractDrawCommand {
        ProfileFeedbackCommand() {
        }

        public Rectangle getValidArea() {
            return null;
        }

        public void run(IProgressMonitor monitor) throws Exception {
            if (ProfileTool.this.points.isEmpty()) {
                return;
            }
            this.graphics.setColor(Color.BLACK);
            Iterator iter = ProfileTool.this.points.iterator();
            Point start = (Point)iter.next();
            while (iter.hasNext()) {
                Point current = (Point)iter.next();
                this.graphics.drawLine(start.x, start.y, current.x, current.y);
                start = current;
            }
            if (start == null || ProfileTool.this.now == null) {
                return;
            }
            this.graphics.drawLine(start.x, start.y, ((ProfileTool)ProfileTool.this).now.x, ((ProfileTool)ProfileTool.this).now.y);
            double distance = ProfileTool.this.distance();
            ProfileTool.this.displayOnStatusBar(distance);
        }
    }
}

