/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.profile;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Geometry;
import eu.udig.tools.jgrass.profile.ProfileView;
import eu.udig.tools.jgrass.profile.borrowedfromjgrasstools.CoverageUtilities;
import eu.udig.tools.jgrass.profile.borrowedfromjgrasstools.ProfilePoint;
import eu.udig.tools.jgrass.profile.borrowedfromjgrasstools.RegionMap;
import java.util.List;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.style.sld.SLD;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import net.refractions.udig.ui.operations.IOp;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.opengis.coverage.grid.GridCoverage;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.GeometryDescriptor;

public class FeatureOnCoverageProfileOperation
implements IOp {
    private ProfileView chartView;
    private GridCoverage2D coverage = null;
    private SimpleFeature lineFeature = null;
    private double step;

    public void op(final Display display, Object target, IProgressMonitor monitor) throws Exception {
        ILayer[] layers;
        ILayer[] iLayerArray = layers = (ILayer[])target;
        int n = layers.length;
        int n2 = 0;
        while (n2 < n) {
            ILayer iLayer = iLayerArray[n2];
            IGeoResource geoResource = iLayer.getGeoResource();
            if (geoResource.canResolve(FeatureSource.class)) {
                SimpleFeatureSource lineSource = (SimpleFeatureSource)geoResource.resolve(FeatureSource.class, monitor);
                SimpleFeatureCollection featureCollection = lineSource.getFeatures(iLayer.getFilter());
                GeometryDescriptor geometryDescriptor = ((SimpleFeatureType)featureCollection.getSchema()).getGeometryDescriptor();
                if (!SLD.isLine((GeometryDescriptor)geometryDescriptor)) break;
                SimpleFeatureIterator featureIterator = featureCollection.features();
                if (featureIterator.hasNext()) {
                    this.lineFeature = (SimpleFeature)featureIterator.next();
                }
            }
            if (geoResource.canResolve(GridCoverage.class)) {
                this.coverage = (GridCoverage2D)geoResource.resolve(GridCoverage.class, monitor);
                RegionMap regionMap = CoverageUtilities.getRegionParamsFromGridCoverage(this.coverage);
                double xres = regionMap.getXres();
                double yres = regionMap.getYres();
                this.step = Math.min(xres, yres);
            }
            ++n2;
        }
        if (this.lineFeature == null || this.coverage == null) {
            display.asyncExec(new Runnable(){

                @Override
                public void run() {
                    MessageDialog.openWarning((Shell)display.getActiveShell(), (String)"Wrong layers error", (String)"This operation works only if a line layer and a coverage layer are selected in the layers view.");
                }
            });
            return;
        }
        display.syncExec(new Runnable(){

            @Override
            public void run() {
                try {
                    PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().showView("eu.udig.tools.jgrass.profileview");
                    FeatureOnCoverageProfileOperation.this.chartView = (ProfileView)PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().findView("eu.udig.tools.jgrass.profileview");
                    FeatureOnCoverageProfileOperation.this.chartView.clearSeries();
                    FeatureOnCoverageProfileOperation.this.chartView.clearMarkers();
                    Geometry geometry = (Geometry)FeatureOnCoverageProfileOperation.this.lineFeature.getDefaultGeometry();
                    Coordinate[] coordinates = geometry.getCoordinates();
                    List<ProfilePoint> profile = CoverageUtilities.doProfile(FeatureOnCoverageProfileOperation.this.coverage, FeatureOnCoverageProfileOperation.this.step, coordinates);
                    for (ProfilePoint profilePoint : profile) {
                        double elevation = profilePoint.getElevation();
                        if (!Double.isNaN(elevation)) {
                            FeatureOnCoverageProfileOperation.this.chartView.addToSeries(profilePoint.getProgressive(), elevation);
                            continue;
                        }
                        FeatureOnCoverageProfileOperation.this.chartView.addToSeries(profilePoint.getProgressive(), 0.0);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    String message = "An error occurred while extracting the profile data";
                    ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)"eu.udig.tools.jgrass", (Throwable)e);
                }
            }
        });
    }
}

