/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.featuremovieview;

import com.vividsolutions.jts.geom.Envelope;
import com.vividsolutions.jts.geom.Geometry;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.command.MapCommand;
import net.refractions.udig.project.command.UndoableMapCommand;
import net.refractions.udig.project.command.factory.SelectionCommandFactory;
import net.refractions.udig.project.internal.command.navigation.ZoomCommand;
import net.refractions.udig.project.ui.ApplicationGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.FeatureSource;
import org.geotools.data.simple.SimpleFeatureCollection;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class FeatureMovieView
extends ViewPart {
    private Image playImage;
    private Image stopImage;
    private Text zoomBufferText;
    private double zoomBuffer;
    private Text timerText;
    private double timer;
    private boolean isRunning = false;
    private Button playButton;
    private Label currentFeatureInfo;
    private String previousLayerName = "";
    private List<SimpleFeature> featureList;
    private int index = 0;
    private Label featureNumLabel;
    private IMap activeMap;
    private ILayer selectedLayer;
    private CoordinateReferenceSystem crs;
    private Image gotoImage;
    private Text gotoText;
    private Image nextImage;
    private Image previousImage;

    public FeatureMovieView() {
        ImageDescriptor playImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.tools.jgrass", (String)"icons/play.gif");
        this.playImage = playImageDescriptor.createImage();
        ImageDescriptor stopImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.tools.jgrass", (String)"icons/stop.gif");
        this.stopImage = stopImageDescriptor.createImage();
        ImageDescriptor gotoImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.tools.jgrass", (String)"icons/goto.gif");
        this.gotoImage = gotoImageDescriptor.createImage();
        ImageDescriptor nextImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.tools.jgrass", (String)"icons/shift_r_edit.gif");
        this.nextImage = nextImageDescriptor.createImage();
        ImageDescriptor previousImageDescriptor = AbstractUIPlugin.imageDescriptorFromPlugin((String)"eu.udig.tools.jgrass", (String)"icons/shift_l_edit.gif");
        this.previousImage = previousImageDescriptor.createImage();
    }

    public void createPartControl(Composite theparent) {
        Composite parent = new Composite(theparent, 0);
        parent.setLayoutData((Object)new GridData(4, 4, true, true));
        parent.setLayout((Layout)new GridLayout(1, true));
        Group playGroup = new Group(parent, 0);
        playGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        playGroup.setLayout((Layout)new GridLayout(2, false));
        playGroup.setText("Commands");
        this.playButton = new Button((Composite)playGroup, 8);
        this.playButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        this.playButton.setText("start");
        this.playButton.setImage(this.playImage);
        this.playButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (FeatureMovieView.this.isRunning) {
                    FeatureMovieView.this.stop();
                } else {
                    FeatureMovieView.this.start();
                    FeatureMovieView.this.activeMap = ApplicationGIS.getActiveMap();
                    FeatureMovieView.this.selectedLayer = FeatureMovieView.this.activeMap.getEditManager().getSelectedLayer();
                    if (FeatureMovieView.this.selectedLayer != null) {
                        try {
                            String name = FeatureMovieView.this.selectedLayer.getName();
                            if (FeatureMovieView.this.featureList == null || !name.equals(FeatureMovieView.this.previousLayerName)) {
                                FeatureMovieView.this.initLayer();
                            }
                            new Thread(new Runnable(){

                                @Override
                                public void run() {
                                    while (FeatureMovieView.this.index < FeatureMovieView.this.featureList.size() && FeatureMovieView.this.isRunning) {
                                        try {
                                            FeatureMovieView.this.goToFeature();
                                            Thread.sleep((long)(FeatureMovieView.this.timer * 1000.0));
                                        }
                                        catch (IOException e) {
                                            e.printStackTrace();
                                        }
                                        catch (InterruptedException e) {
                                            e.printStackTrace();
                                        }
                                    }
                                }
                            }).start();
                        }
                        catch (IOException e1) {
                            e1.printStackTrace();
                        }
                    } else {
                        FeatureMovieView.this.noProperLayerSelected();
                    }
                }
            }
        });
        this.featureNumLabel = new Label((Composite)playGroup, 0);
        this.featureNumLabel.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.featureNumLabel.setText(" - ");
        Button gotoButton = new Button((Composite)playGroup, 8);
        gotoButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        gotoButton.setText("goto");
        gotoButton.setImage(this.gotoImage);
        gotoButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                String text = FeatureMovieView.this.gotoText.getText();
                int gotoInt = 1;
                try {
                    gotoInt = Integer.parseInt(text);
                    FeatureMovieView.this.index = gotoInt - 1;
                    if (FeatureMovieView.this.selectedLayer == null) {
                        FeatureMovieView.this.initLayer();
                    }
                    int size = FeatureMovieView.this.featureList.size();
                    if (FeatureMovieView.this.index < 0 || FeatureMovieView.this.index > size - 1) {
                        MessageDialog.openWarning((Shell)FeatureMovieView.this.getSite().getShell(), (String)"Wrong feature number", (String)("The feature number range is: 1 - " + size));
                        return;
                    }
                    FeatureMovieView.this.goToFeature();
                }
                catch (Exception ex) {
                    FeatureMovieView.this.gotoText.setText("");
                    ex.printStackTrace();
                }
            }
        });
        this.gotoText = new Text((Composite)playGroup, 18436);
        GridData gotoTextGD = new GridData(4, 0x1000000, false, false);
        gotoTextGD.widthHint = 20;
        this.gotoText.setLayoutData((Object)gotoTextGD);
        this.gotoText.setText("");
        Composite nextPreviousComposite = new Composite((Composite)playGroup, 0);
        nextPreviousComposite.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        GridLayout npGL = new GridLayout(2, true);
        npGL.marginWidth = 0;
        npGL.marginHeight = 0;
        nextPreviousComposite.setLayout((Layout)npGL);
        Button previousButton = new Button(nextPreviousComposite, 8);
        previousButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        previousButton.setText("previous");
        previousButton.setImage(this.previousImage);
        previousButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (FeatureMovieView.this.index == 1) {
                        return;
                    }
                    FeatureMovieView featureMovieView = FeatureMovieView.this;
                    featureMovieView.index = featureMovieView.index - 2;
                    if (FeatureMovieView.this.selectedLayer == null) {
                        FeatureMovieView.this.initLayer();
                    }
                    int size = FeatureMovieView.this.featureList.size();
                    if (FeatureMovieView.this.index < 0) {
                        FeatureMovieView.this.index = 0;
                    }
                    if (FeatureMovieView.this.index > size - 1) {
                        FeatureMovieView.this.index = size - 1;
                    }
                    FeatureMovieView.this.goToFeature();
                }
                catch (Exception ex) {
                    FeatureMovieView.this.gotoText.setText("");
                    ex.printStackTrace();
                }
            }
        });
        Button nextButton = new Button(nextPreviousComposite, 8);
        nextButton.setLayoutData((Object)new GridData(4, 0x1000000, false, false));
        nextButton.setText("next");
        nextButton.setImage(this.nextImage);
        nextButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                try {
                    if (FeatureMovieView.this.selectedLayer == null) {
                        FeatureMovieView.this.initLayer();
                    }
                    int size = FeatureMovieView.this.featureList.size();
                    if (FeatureMovieView.this.index == size - 1) {
                        return;
                    }
                    if (FeatureMovieView.this.index < 0) {
                        FeatureMovieView.this.index = 0;
                    }
                    if (FeatureMovieView.this.index > size - 1) {
                        FeatureMovieView.this.index = size - 1;
                    }
                    FeatureMovieView.this.goToFeature();
                }
                catch (Exception ex) {
                    FeatureMovieView.this.gotoText.setText("");
                    ex.printStackTrace();
                }
            }
        });
        Group paramsGroup = new Group(parent, 0);
        paramsGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        paramsGroup.setLayout((Layout)new GridLayout(2, true));
        paramsGroup.setText("Parameters");
        Label zoomBufferLabel = new Label((Composite)paramsGroup, 0);
        zoomBufferLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        zoomBufferLabel.setText("Zoom buffer around feature");
        this.zoomBufferText = new Text((Composite)paramsGroup, 18436);
        this.zoomBufferText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.zoomBufferText.setText("");
        this.zoomBufferText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FeatureMovieView.this.updateZoomBuffer();
            }
        });
        this.updateZoomBuffer();
        Label timerLabel = new Label((Composite)paramsGroup, 0);
        timerLabel.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        timerLabel.setText("Timer interval in seconds");
        this.timerText = new Text((Composite)paramsGroup, 18436);
        this.timerText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.timerText.setText("");
        this.timerText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                FeatureMovieView.this.updateTimer();
            }
        });
        this.updateTimer();
        Group infoGroup = new Group(parent, 0);
        infoGroup.setLayoutData((Object)new GridData(4, 4, true, true));
        infoGroup.setLayout((Layout)new GridLayout(1, true));
        infoGroup.setText("Current Feature Info");
        this.currentFeatureInfo = new Label((Composite)infoGroup, 0);
        this.currentFeatureInfo.setLayoutData((Object)new GridData(4, 4, true, true));
        this.currentFeatureInfo.setText(" - ");
    }

    private void initLayer() throws IOException {
        this.activeMap = ApplicationGIS.getActiveMap();
        this.selectedLayer = this.activeMap.getEditManager().getSelectedLayer();
        SimpleFeatureSource featureSource = (SimpleFeatureSource)this.selectedLayer.getResource(FeatureSource.class, (IProgressMonitor)new SubProgressMonitor((IProgressMonitor)new NullProgressMonitor(), 1));
        if (featureSource == null) {
            this.noProperLayerSelected();
            return;
        }
        SimpleFeatureCollection featureCollection = featureSource.getFeatures();
        this.crs = ((SimpleFeatureType)featureCollection.getSchema()).getCoordinateReferenceSystem();
        this.featureList = this.featureCollectionToList(featureCollection);
        this.previousLayerName = this.selectedLayer.getName();
        this.index = 0;
    }

    private void noProperLayerSelected() {
        MessageDialog.openWarning((Shell)this.getSite().getShell(), (String)"NO LAYER SELECTED", (String)"A feature layer needs to be selected to use the tool.");
        this.stop();
    }

    private void goToFeature() throws IOException {
        if (this.featureList == null) {
            this.initLayer();
        }
        SimpleFeature currentFeature = this.featureList.get(this.index);
        SimpleFeatureType featureType = currentFeature.getFeatureType();
        List attributeDescriptors = featureType.getAttributeDescriptors();
        ArrayList<Object> attributeNames = new ArrayList<Object>();
        for (AttributeDescriptor attributeDescriptor : attributeDescriptors) {
            String name = attributeDescriptor.getLocalName();
            attributeNames.add(name);
        }
        final StringBuilder infoSb = new StringBuilder();
        for (String string : attributeNames) {
            Object attribute = currentFeature.getAttribute(string);
            if (attribute == null) continue;
            infoSb.append(string).append(" = ").append(attribute.toString()).append("\n");
        }
        final StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("  (");
        stringBuilder.append(this.index + 1);
        stringBuilder.append("/");
        stringBuilder.append(this.featureList.size());
        stringBuilder.append(")");
        ++this.index;
        if (this.index == this.featureList.size()) {
            this.index = 0;
        }
        Display.getDefault().asyncExec(new Runnable(){

            @Override
            public void run() {
                FeatureMovieView.this.currentFeatureInfo.setText(infoSb.toString());
                FeatureMovieView.this.featureNumLabel.setText(stringBuilder.toString());
            }
        });
        Geometry geometry = (Geometry)currentFeature.getDefaultGeometry();
        Envelope envelope = geometry.getEnvelopeInternal();
        envelope.expandBy(this.zoomBuffer);
        ReferencedEnvelope ref = new ReferencedEnvelope(envelope, this.crs);
        try {
            ref = ref.transform(this.activeMap.getViewportModel().getCRS(), true);
        }
        catch (Exception exception) {}
        UndoableMapCommand selectCommand = SelectionCommandFactory.getInstance().createFIDSelectCommand(this.selectedLayer, currentFeature);
        ZoomCommand zoomCommand = new ZoomCommand((Envelope)ref);
        this.activeMap.sendCommandASync((MapCommand)selectCommand);
        this.activeMap.sendCommandASync((MapCommand)zoomCommand);
        this.activeMap.getRenderManager().refresh(null);
    }

    private synchronized void start() {
        this.playButton.setImage(this.stopImage);
        this.playButton.setText("stop");
        this.isRunning = true;
    }

    private synchronized void stop() {
        this.playButton.setImage(this.playImage);
        this.playButton.setText("start");
        this.isRunning = false;
    }

    private void updateTimer() {
        String text = this.timerText.getText();
        try {
            this.timer = Double.parseDouble(text);
        }
        catch (Exception exception) {
            this.timer = 4.0;
            this.timerText.setText(String.valueOf(this.timer));
        }
    }

    private void updateZoomBuffer() {
        String text = this.zoomBufferText.getText();
        try {
            this.zoomBuffer = Double.parseDouble(text);
        }
        catch (Exception exception) {
            this.zoomBuffer = 10.0;
            this.zoomBufferText.setText(String.valueOf(this.zoomBuffer));
        }
    }

    private List<SimpleFeature> featureCollectionToList(SimpleFeatureCollection collection) {
        ArrayList<SimpleFeature> featuresList = new ArrayList<SimpleFeature>();
        if (collection == null) {
            return featuresList;
        }
        SimpleFeatureIterator featureIterator = collection.features();
        while (featureIterator.hasNext()) {
            SimpleFeature feature = (SimpleFeature)featureIterator.next();
            featuresList.add(feature);
        }
        featureIterator.close();
        return featuresList;
    }

    public void setFocus() {
    }
}

