/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass.csv;

import eu.udig.catalog.jgrass.core.ChooseCoordinateReferenceSystemDialog;
import eu.udig.tools.jgrass.csv.CsvImportWizard;
import eu.udig.tools.jgrass.i18n.Messages;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.jface.layout.TableColumnLayout;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.ComboBoxCellEditor;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICellModifier;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TextCellEditor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.KeyAdapter;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Widget;
import org.geotools.gce.grassraster.JGrassConstants;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class CsvImportWizardPage
extends WizardPage {
    public static final String ID = "CsvImportWizardPage";
    private String SEPARATOR = ",";
    private CoordinateReferenceSystem readCrs;
    private File csvFile = null;
    private List<Object[]> tableValues = new ArrayList<Object[]>();
    private TableViewer tableViewer;
    private boolean is3d = false;

    public CsvImportWizardPage(String pageName, Map<String, String> params) {
        super(ID);
        this.setTitle(pageName);
        this.setDescription(Messages.getString("CsvImportWizardPage.importasshape"));
    }

    public void createControl(Composite parent) {
        Composite fileSelectionArea = new Composite(parent, 0);
        fileSelectionArea.setLayout((Layout)new GridLayout());
        Group inputGroup = new Group(fileSelectionArea, 0);
        inputGroup.setText("Choose the CSV file");
        inputGroup.setLayout((Layout)new GridLayout(2, false));
        inputGroup.setLayoutData((Object)new GridData(768));
        GridData gridData1 = new GridData(768);
        gridData1.horizontalSpan = 2;
        final Text csvText = new Text((Composite)inputGroup, 18436);
        csvText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        csvText.setText("");
        final Button csvButton = new Button((Composite)inputGroup, 8);
        csvButton.setLayoutData((Object)new GridData(1, 0x1000000, false, false));
        csvButton.setText("...");
        csvButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                File f;
                FileDialog fileDialog = new FileDialog(csvButton.getShell(), 4096);
                String path = fileDialog.open();
                if (path != null && (f = new File(path)).exists()) {
                    csvText.setText(path);
                    CsvImportWizardPage.this.csvFile = f;
                    try {
                        CsvImportWizardPage.this.fillTableView();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                }
                CsvImportWizardPage.this.checkFinish();
            }
        });
        Group crsGroup = new Group(fileSelectionArea, 0);
        crsGroup.setLayout((Layout)new GridLayout(2, false));
        crsGroup.setLayoutData((Object)new GridData(768));
        crsGroup.setText("Coordinate reference system for the data");
        final Text crsText = new Text((Composite)crsGroup, 2048);
        crsText.setLayoutData((Object)new GridData(768));
        crsText.setEditable(false);
        Button crsButton = new Button((Composite)crsGroup, 2048);
        crsButton.setText(" Choose CRS ");
        crsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChooseCoordinateReferenceSystemDialog crsChooser = new ChooseCoordinateReferenceSystemDialog();
                crsChooser.open(new Shell(Display.getDefault()));
                CoordinateReferenceSystem crs = crsChooser.getCrs();
                if (crs == null) {
                    return;
                }
                crsText.setText(crs.getName().toString());
                CsvImportWizardPage.this.readCrs = crs;
                CsvImportWizardPage.this.checkFinish();
            }
        });
        Group separatorGroup = new Group(fileSelectionArea, 0);
        separatorGroup.setLayout((Layout)new GridLayout(2, false));
        separatorGroup.setLayoutData((Object)new GridData(768));
        separatorGroup.setText("The CSV separator string");
        final Text separatorText = new Text((Composite)separatorGroup, 18436);
        separatorText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        separatorText.setText(this.SEPARATOR);
        separatorText.addKeyListener((KeyListener)new KeyAdapter(){

            public void keyReleased(KeyEvent e) {
                String sep = separatorText.getText();
                if (sep.length() > 0) {
                    CsvImportWizardPage.this.SEPARATOR = sep;
                    try {
                        CsvImportWizardPage.this.fillTableView();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    CsvImportWizardPage.this.checkFinish();
                }
            }
        });
        this.createTableArea(fileSelectionArea);
        this.checkFinish();
        this.setControl((Control)fileSelectionArea);
    }

    private void createTableArea(Composite fileSelectionArea) {
        GridData gridData1 = new GridData();
        gridData1.horizontalSpan = 2;
        gridData1.horizontalAlignment = 4;
        gridData1.grabExcessHorizontalSpace = true;
        gridData1.grabExcessVerticalSpace = true;
        gridData1.verticalAlignment = 4;
        Composite comp = new Composite(fileSelectionArea, 0);
        comp.setLayout((Layout)new FillLayout());
        comp.setLayoutData((Object)gridData1);
        this.tableViewer = new TableViewer(comp, 2560);
        Table table = this.tableViewer.getTable();
        table.setHeaderVisible(true);
        table.setLinesVisible(true);
        TableColumn name = new TableColumn(table, 0);
        name.setText("Fieldname");
        TableColumn value = new TableColumn(table, 0);
        value.setText("Example value");
        TableColumn type = new TableColumn(table, 0);
        type.setText("Type");
        TableColumnLayout layout = new TableColumnLayout();
        layout.setColumnData((Widget)name, (ColumnLayoutData)new ColumnWeightData(40, true));
        layout.setColumnData((Widget)value, (ColumnLayoutData)new ColumnWeightData(40, true));
        layout.setColumnData((Widget)type, (ColumnLayoutData)new ColumnWeightData(20, true));
        comp.setLayout((Layout)layout);
        this.tableViewer.setColumnProperties(new String[]{"Fieldname", "Example value", "Type"});
        this.tableViewer.setCellModifier(new ICellModifier(){

            public boolean canModify(Object element, String property) {
                return !property.equals("Example value");
            }

            public Object getValue(Object element, String property) {
                Object[] e = (Object[])element;
                if (property.equals("Fieldname")) {
                    return e[0];
                }
                if (property.equals("Type")) {
                    return e[2];
                }
                return "";
            }

            public void modify(Object element, String property, Object value) {
                TableItem tabItem = (TableItem)element;
                Object[] data = (Object[])tabItem.getData();
                if (property.equals("Fieldname")) {
                    data[0] = value;
                }
                if (property.equals("Type")) {
                    data[2] = value;
                }
                CsvImportWizardPage.this.tableViewer.refresh((Object)data);
                CsvImportWizardPage.this.checkFinish();
            }
        });
        this.tableViewer.setCellEditors(new CellEditor[]{new TextCellEditor((Composite)table), new TextCellEditor((Composite)table), new ComboBoxCellEditor((Composite)table, JGrassConstants.CSVTYPESARRAY)});
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new ITableLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                Object[] e = (Object[])element;
                switch (columnIndex) {
                    case 0: {
                        return (String)e[0];
                    }
                    case 1: {
                        return (String)e[1];
                    }
                    case 2: {
                        return JGrassConstants.CSVTYPESARRAY[(Integer)e[2]];
                    }
                }
                return "";
            }

            public void addListener(ILabelProviderListener listener) {
            }

            public void dispose() {
            }

            public boolean isLabelProperty(Object element, String property) {
                return false;
            }

            public void removeListener(ILabelProviderListener listener) {
            }
        });
        this.tableViewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        this.tableViewer.setInput(this.tableValues);
    }

    private void fillTableView() throws IOException {
        if (this.SEPARATOR.length() > 0 && this.csvFile != null && this.csvFile.exists()) {
            BufferedReader bR = new BufferedReader(new FileReader(this.csvFile));
            String line = null;
            String[] lineSplit = null;
            while ((line = bR.readLine()) != null) {
                if (line.trim().length() == 0) continue;
                lineSplit = line.trim().split(this.SEPARATOR);
                break;
            }
            bR.close();
            if (lineSplit != null) {
                this.tableValues.clear();
                int i = 0;
                while (i < lineSplit.length) {
                    Object[] value = new Object[3];
                    value[0] = "Field" + i;
                    value[1] = lineSplit[i];
                    if (i == 0) {
                        try {
                            Double.parseDouble(lineSplit[i]);
                            value[2] = 0;
                        }
                        catch (NumberFormatException numberFormatException) {
                            value[2] = 3;
                        }
                    } else if (i == 1) {
                        try {
                            Double.parseDouble(lineSplit[i]);
                            value[2] = 1;
                        }
                        catch (NumberFormatException numberFormatException) {
                            value[2] = 3;
                        }
                    } else {
                        value[2] = 3;
                    }
                    this.tableValues.add(value);
                    ++i;
                }
                this.tableViewer.setInput(this.tableValues);
            }
        }
    }

    public File getCsvFile() {
        return this.csvFile;
    }

    public String getSeparator() {
        return this.SEPARATOR;
    }

    public LinkedHashMap<String, Integer> getFieldsAndTypesIndex() {
        LinkedHashMap<String, Integer> fieldNamesToTypesIndex = new LinkedHashMap<String, Integer>();
        int i = 0;
        while (i < this.tableValues.size()) {
            Object[] values = this.tableValues.get(i);
            fieldNamesToTypesIndex.put((String)values[0], (Integer)values[2]);
            ++i;
        }
        return fieldNamesToTypesIndex;
    }

    public boolean is3d() {
        return this.is3d;
    }

    public CoordinateReferenceSystem getCrs() {
        return this.readCrs;
    }

    private void checkFinish() {
        boolean hasX = false;
        boolean hasY = false;
        int i = 0;
        while (i < this.tableValues.size()) {
            Object[] values = this.tableValues.get(i);
            Integer type = (Integer)values[2];
            if (type == 0) {
                hasX = true;
            }
            if (type == 1) {
                hasY = true;
            }
            ++i;
        }
        CsvImportWizard.canFinish = hasX && hasY && this.csvFile != null && this.csvFile.exists() && this.readCrs != null && this.SEPARATOR.length() != 0;
        this.getWizard().getContainer().updateButtons();
    }
}

