/*
 * Decompiled with CFR 0.152.
 */
package eu.udig.tools.jgrass;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Collections;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ICatalog;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceFactory;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.ui.ApplicationGIS;
import net.refractions.udig.ui.ExceptionDetailsDialog;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.geotools.data.DefaultTransaction;
import org.geotools.data.FeatureStore;
import org.geotools.data.Transaction;
import org.geotools.data.shapefile.ShapefileDataStore;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.feature.FeatureCollection;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.osgi.framework.BundleContext;

public class JGrassToolsPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "eu.udig.tools.jgrass";
    private static JGrassToolsPlugin plugin;

    public void start(BundleContext context) throws Exception {
        super.start(context);
        plugin = this;
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static JGrassToolsPlugin getDefault() {
        return plugin;
    }

    public static void log(String message2, Throwable t) {
        if (JGrassToolsPlugin.getDefault() == null) {
            t.printStackTrace();
            return;
        }
        String message = message2;
        if (message == null) {
            message = "";
        }
        int status = t instanceof Exception || message != null ? 4 : 2;
        JGrassToolsPlugin.getDefault().getLog().log((IStatus)new Status(status, PLUGIN_ID, 0, message, t));
    }

    public void addServiceToCatalogAndMap(String outputFile, boolean addToCatalog, boolean addToActiveMap, IProgressMonitor progressMonitor) {
        try {
            URL fileUrl = new File(outputFile).toURI().toURL();
            if (addToCatalog) {
                IServiceFactory sFactory = CatalogPlugin.getDefault().getServiceFactory();
                ICatalog catalog = CatalogPlugin.getDefault().getLocalCatalog();
                List services = sFactory.createService(fileUrl);
                for (IService service : services) {
                    catalog.add(service);
                    if (!addToActiveMap) continue;
                    IMap activeMap = ApplicationGIS.getActiveMap();
                    int layerNum = activeMap.getMapLayers().size();
                    List members = service.members(progressMonitor);
                    for (IResolve iRes : members) {
                        if (!iRes.canResolve(IGeoResource.class)) continue;
                        IGeoResource geoResource = (IGeoResource)iRes.resolve(IGeoResource.class, progressMonitor);
                        ApplicationGIS.addLayersToMap(null, Collections.singletonList(geoResource), (int)layerNum);
                    }
                }
            }
        }
        catch (Exception e) {
            String message = "An error occurred while adding the service to the catalog.";
            ExceptionDetailsDialog.openError(null, (String)message, (int)4, (String)PLUGIN_ID, (Throwable)e);
            e.printStackTrace();
        }
    }

    public void writeToShapefile(ShapefileDataStore dataStore, FeatureCollection<SimpleFeatureType, SimpleFeature> collection) throws IOException {
        String featureName = dataStore.getTypeNames()[0];
        SimpleFeatureSource featureSource = dataStore.getFeatureSource(featureName);
        DefaultTransaction transaction = new DefaultTransaction("create");
        try {
            try {
                FeatureStore featureStore = (FeatureStore)featureSource;
                featureStore.setTransaction((Transaction)transaction);
                featureStore.addFeatures(collection);
                transaction.commit();
            }
            catch (Exception eek) {
                transaction.rollback();
                throw new IOException("The transaction could now be finished, an error orrcurred", eek);
            }
        }
        finally {
            transaction.close();
        }
    }
}

