/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.wms.basic.preferences;

import net.refractions.udig.render.wms.basic.WMSPlugin;
import net.refractions.udig.render.wms.basic.internal.Messages;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.ListEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class BasicWMSRendererPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private ImageTypeListEditor editor;
    private BooleanFieldEditor checkbox;

    public BasicWMSRendererPreferencePage() {
        super(1);
        this.setPreferenceStore(WMSPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.BasicWMSRendererPreferencePage_warning);
    }

    public void createFieldEditors() {
        this.checkbox = new BooleanFieldEditor("useDefaultOrder", Messages.BasicWMSRendererPreferencePage_useDefaults, this.getFieldEditorParent());
        this.addField((FieldEditor)this.checkbox);
        this.editor = new ImageTypeListEditor("imageTypeOrder", Messages.BasicWMSRendererPreferencePage_setOrder, this.getFieldEditorParent());
        this.editor.setEnabled(!this.getPreferenceStore().getBoolean("useDefaultOrder"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.editor);
    }

    public void init(IWorkbench workbench) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource().equals(this.checkbox)) {
            boolean useDefault = (Boolean)event.getNewValue();
            this.editor.setEnabled(!useDefault, this.getFieldEditorParent());
        }
    }

    protected class ImageTypeListEditor
    extends ListEditor {
        protected ImageTypeListEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected String createList(String[] items) {
            StringBuilder stringList = new StringBuilder();
            String[] stringArray = items;
            int n = items.length;
            int n2 = 0;
            while (n2 < n) {
                String str = stringArray[n2];
                if (stringList.length() > 0) {
                    stringList.append(',');
                }
                stringList.append(str);
                ++n2;
            }
            return stringList.toString();
        }

        protected String getNewInputObject() {
            String str = new String("image/");
            InputDialog dialog = new InputDialog(Display.getCurrent().getActiveShell(), "New Image Type", "Enter the image type", str, null);
            int result = dialog.open();
            if (result == 0) {
                str = dialog.getValue();
            }
            if ("image/".equals(str)) {
                return null;
            }
            return str;
        }

        protected String[] parseString(String stringList) {
            String[] items = stringList.split(",");
            return items;
        }
    }
}

