/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.wmsc.basic;

import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.wmsc.server.TileImageReadWriter;
import net.refractions.udig.render.internal.wmsc.basic.WMSCTileCaching;
import net.refractions.udig.render.wms.basic.internal.Messages;
import org.eclipse.jface.preference.DirectoryFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class WMSCTilePreferencesPage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private DirectoryFieldEditor diskCacheFieldEditor;
    private RadioGroupFieldEditor cachingRadioFieldEditor;
    private Button cacheClearBtn;

    public WMSCTilePreferencesPage() {
        super(1);
        this.setPreferenceStore(CatalogPlugin.getDefault().getPreferenceStore());
        this.setDescription(Messages.WMSCTilePreferencePage_pageDescription);
    }

    protected void createFieldEditors() {
        IntegerFieldEditor conRequestsFieldEditor = new IntegerFieldEditor("P_WMSCTILE_MAX_CON_REQUESTS", Messages.WMSCTilePreferencePage_maxConRequests, this.getFieldEditorParent());
        conRequestsFieldEditor.setValidRange(1, 64);
        conRequestsFieldEditor.setEmptyStringAllowed(true);
        this.addField((FieldEditor)conRequestsFieldEditor);
        this.cachingRadioFieldEditor = new RadioGroupFieldEditor("P_WMSCTILE_CACHING", Messages.WMSCTilePreferencePage_caching_desc, 1, (String[][])new String[][]{{Messages.WMSCTilePreferencePage_inmemory, WMSCTileCaching.INMEMORY.toString()}, {Messages.WMSCTilePreferencePage_ondisk, WMSCTileCaching.ONDISK.toString()}}, this.getFieldEditorParent(), true);
        this.addField((FieldEditor)this.cachingRadioFieldEditor);
        String value = CatalogPlugin.getDefault().getPreferenceStore().getString("P_WMSCTILE_CACHING");
        boolean diskOn = false;
        if (value.equals(WMSCTileCaching.ONDISK.toString())) {
            diskOn = true;
        }
        this.diskCacheFieldEditor = new DirectoryFieldEditor("P_WMSCTILE_DISKDIR", Messages.WMSCTilePreferencePage_disklabel, this.getFieldEditorParent());
        this.diskCacheFieldEditor.setEnabled(diskOn, this.getFieldEditorParent());
        this.addField((FieldEditor)this.diskCacheFieldEditor);
        this.cacheClearBtn = new Button(this.getFieldEditorParent(), 8);
        this.cacheClearBtn.setText(Messages.WMSCTilePreferencePage_clearcachebtn);
        this.cacheClearBtn.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MessageBox mb = new MessageBox(Display.getCurrent().getActiveShell(), 292);
                mb.setText(Messages.WMSCTilePreferencePage_clearcachebtn);
                mb.setMessage(Messages.WMSCTilePreferencePage_clearcacheConfirm);
                int rc = mb.open();
                if (rc == 32) {
                    boolean success = WMSCTilePreferencesPage.this.clearCache();
                    mb = new MessageBox(Display.getCurrent().getActiveShell(), 32);
                    mb.setText(Messages.WMSCTilePreferencePage_clearcachebtn);
                    if (!success) {
                        mb.setMessage(Messages.WMSCTilePreferencePage_clearcacheError);
                    } else {
                        mb.setMessage(Messages.WMSCTilePreferencePage_clearcacheSuccess);
                    }
                    rc = mb.open();
                }
            }
        });
        this.cacheClearBtn.setEnabled(diskOn);
    }

    private boolean clearCache() {
        String dir = this.diskCacheFieldEditor.getStringValue();
        String setDir = CatalogPlugin.getDefault().getPreferenceStore().getString("P_WMSCTILE_DISKDIR");
        if (dir.equals("") && setDir != null && !setDir.equals("")) {
            dir = setDir;
        } else if (dir.equals("")) {
            return false;
        }
        TileImageReadWriter tileReadWriter = new TileImageReadWriter(null, dir);
        return tileReadWriter.clearCache();
    }

    public void init(IWorkbench arg0) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        super.propertyChange(event);
        if (event.getSource().equals(this.cachingRadioFieldEditor)) {
            String value = ((String)event.getNewValue()).toString();
            boolean diskOn = false;
            if (value.equals(WMSCTileCaching.ONDISK.toString())) {
                diskOn = true;
            }
            this.diskCacheFieldEditor.setEnabled(diskOn, this.getFieldEditorParent());
            this.cacheClearBtn.setEnabled(diskOn);
        }
    }
}

