/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.wmsc.basic;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.PriorityBlockingQueue;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.internal.wms.WmsPlugin;
import net.refractions.udig.catalog.wmsc.server.Tile;
import net.refractions.udig.catalog.wmsc.server.TileListener;
import net.refractions.udig.catalog.wmsc.server.TileRangeInMemory;
import net.refractions.udig.catalog.wmsc.server.TileRangeOnDisk;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.TileWorkerQueue;
import net.refractions.udig.catalog.wmsc.server.TiledWebMapServer;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.IRenderer;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.render.internal.wmsc.basic.WMSCTileCaching;
import net.refractions.udig.render.wms.basic.WMSPlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.ows.AbstractOpenWebService;
import org.geotools.data.wms.WebMapServer;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.StyleBuilder;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class BasicWMSCRenderer
extends RendererImpl
implements IRenderer {
    private static StyleBuilder styleBuilder = new StyleBuilder();
    private TileListenerImpl listener = new TileListenerImpl();
    private static final boolean testing = false;
    private static final boolean TESTING = WMSPlugin.getDefault().isDebugging();
    private static int staticid = 0;
    private static TileWorkerQueue requestTileWorkQueue = new TileWorkerQueue();
    private static TileWorkerQueue writeTileWorkQueue = new TileWorkerQueue();
    private BlockingQueue<Tile> tilesToDraw_queue = new PriorityBlockingQueue<Tile>();

    public void render(Graphics2D graphics, IProgressMonitor monitor) throws RenderException {
        block18: {
            if (monitor == null) {
                monitor = new NullProgressMonitor();
            }
            monitor.beginTask("Render WMSC", 100);
            this.setState(32);
            IGeoResource handle = this.getContext().getLayer().findGeoResource(TileSet.class);
            try {
                ReferencedEnvelope bounds;
                TileSet tileset = (TileSet)handle.resolve(TileSet.class, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                AbstractOpenWebService server = null;
                if (handle.canResolve(WebMapServer.class)) {
                    server = (AbstractOpenWebService)handle.resolve(WebMapServer.class, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                }
                if (handle.canResolve(TiledWebMapServer.class)) {
                    server = (AbstractOpenWebService)handle.resolve(TiledWebMapServer.class, (IProgressMonitor)new SubProgressMonitor(monitor, 30));
                }
                if ((bounds = this.getRenderBounds()) == null) {
                    ReferencedEnvelope viewbounds = this.getContext().getImageBounds();
                    if (this.getContext().getCRS().equals(viewbounds.getCoordinateReferenceSystem())) {
                        bounds = viewbounds;
                    }
                }
                if (!bounds.getCoordinateReferenceSystem().equals(tileset.getCoordinateReferenceSystem())) {
                    MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)bounds.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)tileset.getCoordinateReferenceSystem());
                    bounds = new ReferencedEnvelope(JTS.transform((Envelope)bounds, (MathTransform)transform), tileset.getCoordinateReferenceSystem());
                }
                double scaleFactor = this.getContext().getViewportModel().getBounds().getWidth() / (double)this.getContext().getMapDisplay().getWidth();
                Envelope bnds = new Envelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY());
                Map tilesInRange = tileset.getTilesFromViewportScale(bnds, scaleFactor);
                Object range = null;
                String value = CatalogPlugin.getDefault().getPreferenceStore().getString("P_WMSCTILE_CACHING");
                range = value.equals(WMSCTileCaching.ONDISK.toString()) ? new TileRangeOnDisk(server, tileset, bnds, tilesInRange, requestTileWorkQueue, writeTileWorkQueue) : new TileRangeInMemory(server, tileset, bnds, tilesInRange, requestTileWorkQueue);
                RasterSymbolizer style = styleBuilder.createRasterSymbolizer();
                int tileCount = range.getTileCount();
                int tileWorth = tileCount / 100 * tileCount;
                boolean thisid = false;
                Map tiles = range.getTiles();
                HashSet<String> notRenderedTiles = new HashSet<String>();
                HashSet<String> renderedTiles = new HashSet<String>();
                for (String key : tiles.keySet()) {
                    if (monitor.isCanceled()) {
                        this.setState(64);
                        return;
                    }
                    Tile tile = (Tile)tiles.get(key);
                    if (tile != null && tile.getBufferedImage() != null && tile.getTileState() != 1) {
                        this.renderTile(graphics, tile, tileset.getCoordinateReferenceSystem(), style);
                        renderedTiles.add(key);
                        monitor.worked(tileWorth);
                        continue;
                    }
                    this.renderBlankTile(graphics, tile, tileset.getCoordinateReferenceSystem());
                    notRenderedTiles.add(key);
                }
                this.setState(2);
                if (notRenderedTiles.isEmpty()) break block18;
                if (monitor.isCanceled()) {
                    this.setState(64);
                    return;
                }
                range.addListener((TileListener)this.listener);
                range.loadTiles(monitor);
                while (!notRenderedTiles.isEmpty()) {
                    if (monitor.isCanceled()) {
                        this.setState(64);
                        this.tilesToDraw_queue.clear();
                        return;
                    }
                    Tile tile = null;
                    try {
                        tile = this.tilesToDraw_queue.take();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (monitor.isCanceled()) {
                        this.setState(64);
                        this.tilesToDraw_queue.clear();
                        return;
                    }
                    ReferencedEnvelope viewbounds = this.getContext().getImageBounds();
                    if (tile != null && tile.getBufferedImage() != null && viewbounds != null && viewbounds.intersects(tile.getBounds()) && !renderedTiles.contains(tile.getId())) {
                        this.renderTile(graphics, tile, tileset.getCoordinateReferenceSystem(), style);
                        renderedTiles.add(tile.getId());
                        monitor.worked(tileWorth);
                        this.setState(2);
                    }
                    notRenderedTiles.remove(tile.getId());
                }
            }
            catch (Exception ex) {
                WmsPlugin.log((String)"Error rendering wmsc.", (Throwable)ex);
            }
        }
        monitor.done();
        this.setState(4);
    }

    private void renderTile(Graphics2D graphics, Tile tile, CoordinateReferenceSystem crs, RasterSymbolizer style) throws FactoryException, TransformException {
        if (tile == null || tile.getBufferedImage() == null) {
            return;
        }
        Envelope bounds = tile.getBounds();
        GridCoverageFactory factory = new GridCoverageFactory();
        ReferencedEnvelope ref = new ReferencedEnvelope(bounds.getMinX(), bounds.getMaxX(), bounds.getMinY(), bounds.getMaxY(), crs);
        GridCoverage2D coverage = factory.create((CharSequence)"GridCoverage", (RenderedImage)tile.getBufferedImage(), (org.opengis.geometry.Envelope)ref);
        Envelope2D coveragebounds = coverage.getEnvelope2D();
        Envelope tilebBounds = new Envelope(coveragebounds.getMinX(), coveragebounds.getMaxX(), coveragebounds.getMinY(), coveragebounds.getMaxY());
        CoordinateReferenceSystem tileCrs = this.getContext().getCRS();
        if (!coverage.getCoordinateReferenceSystem().equals(tileCrs)) {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)coverage.getCoordinateReferenceSystem(), (CoordinateReferenceSystem)tileCrs);
            tilebBounds = JTS.transform((Envelope)tilebBounds, (MathTransform)transform);
        }
        Point upperLeft = this.getContext().worldToPixel(new Coordinate(tilebBounds.getMinX(), tilebBounds.getMinY()));
        Point bottomRight = this.getContext().worldToPixel(new Coordinate(tilebBounds.getMaxX(), tilebBounds.getMaxY()));
        Rectangle tileSize = new Rectangle(upperLeft);
        tileSize.add(bottomRight);
        try {
            AffineTransform worldToScreenTransform = RendererUtilities.worldToScreenTransform((Envelope)tilebBounds, (Rectangle)tileSize, (CoordinateReferenceSystem)tileCrs);
            GridCoverageRenderer paint = new GridCoverageRenderer(tileCrs, tilebBounds, tileSize, worldToScreenTransform);
            paint.paint(graphics, coverage, style);
            if (TESTING) {
                graphics.setColor(Color.BLACK);
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMinY(), (int)tileSize.getMinX(), (int)tileSize.getMaxY());
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMinY(), (int)tileSize.getMaxX(), (int)tileSize.getMinY());
                graphics.drawLine((int)tileSize.getMaxX(), (int)tileSize.getMinY(), (int)tileSize.getMaxX(), (int)tileSize.getMaxY());
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMaxY(), (int)tileSize.getMaxX(), (int)tileSize.getMaxY());
                graphics.drawString("pos: " + tile.getPosition(), (int)tileSize.getMaxX() - 113, (int)tileSize.getMaxY() - 113);
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            WmsPlugin.log((String)("Error Rendering tile. Painting Tile:" + (coverage != null ? coverage.getName() : "")), (Throwable)t);
        }
    }

    private void renderBlankTile(Graphics2D graphics, Tile tile, CoordinateReferenceSystem crs) throws FactoryException, TransformException {
        if (tile == null) {
            return;
        }
        Envelope bnds = tile.getBounds();
        if (!crs.equals(this.getContext().getCRS())) {
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)crs, (CoordinateReferenceSystem)this.getContext().getCRS());
            bnds = JTS.transform((Envelope)bnds, (MathTransform)transform);
        }
        Point upperLeft = this.getContext().worldToPixel(new Coordinate(bnds.getMinX(), bnds.getMinY()));
        Point bottomRight = this.getContext().worldToPixel(new Coordinate(bnds.getMaxX(), bnds.getMaxY()));
        Rectangle tileSize = new Rectangle(upperLeft);
        tileSize.add(bottomRight);
        try {
            graphics.setBackground(new Color(255, 255, 255, 0));
            graphics.clearRect(tileSize.x, tileSize.y, tileSize.width, tileSize.height);
            if (TESTING) {
                graphics.setColor(Color.BLACK);
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMinY(), (int)tileSize.getMinX(), (int)tileSize.getMaxY());
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMinY(), (int)tileSize.getMaxX(), (int)tileSize.getMinY());
                graphics.drawLine((int)tileSize.getMaxX(), (int)tileSize.getMinY(), (int)tileSize.getMaxX(), (int)tileSize.getMaxY());
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMaxY(), (int)tileSize.getMaxX(), (int)tileSize.getMaxY());
            }
        }
        catch (Throwable t) {
            t.printStackTrace();
            WmsPlugin.log((String)"Error Rendering Blank tile. Painting Tile", (Throwable)t);
        }
    }

    public void render(IProgressMonitor monitor) throws RenderException {
        Graphics2D g2 = (Graphics2D)this.context.getImage().getGraphics();
        this.render(g2, monitor);
    }

    public void dispose() {
        super.dispose();
    }

    protected class TileListenerImpl
    implements TileListener {
        public void notifyTileReady(Tile tile) {
            int currentState = BasicWMSCRenderer.this.getState();
            if (currentState == 2 || currentState == 32) {
                try {
                    BasicWMSCRenderer.this.tilesToDraw_queue.put(tile);
                }
                catch (InterruptedException e) {
                    WMSPlugin.log("Error while added tile to queue.", e);
                }
            } else {
                BasicWMSCRenderer.this.setState(16);
            }
        }
    }
}

