/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.wms.basic;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.lang.reflect.InvocationTargetException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.naming.OperationNotSupportedException;
import net.refractions.udig.catalog.util.CRSUtil;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.IMap;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.render.ViewportModel;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.ICompositeRenderContext;
import net.refractions.udig.project.render.IMultiLayerRenderer;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.render.wms.basic.WMSPlugin;
import net.refractions.udig.render.wms.basic.internal.Messages;
import net.refractions.udig.ui.PlatformGIS;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.data.Query;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.Service;
import org.geotools.data.ows.StyleImpl;
import org.geotools.data.ows.WMSCapabilities;
import org.geotools.data.wms.WebMapServer;
import org.geotools.data.wms.request.GetMapRequest;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.geometry.GeneralEnvelope;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.ows.ServiceException;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Rule;
import org.geotools.styling.Style;
import org.geotools.xml.DocumentWriter;
import org.geotools.xml.filter.FilterSchema;
import org.geotools.xml.schema.Schema;
import org.opengis.filter.Filter;
import org.opengis.geometry.MismatchedDimensionException;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.ReferenceIdentifier;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class BasicWMSRenderer2
extends RendererImpl
implements IMultiLayerRenderer {
    private static final String REFRESH_JOB = Messages.BasicWMSRenderer2_refreshJob_title;
    private static final String EPSG_4326 = "EPSG:4326";
    private static final String CRS_84 = "CRS:84";
    private static final String EPSG_4269 = "EPSG:4269";
    private static final ReferencedEnvelope NILL_BOX = new ReferencedEnvelope(0.0, 0.0, 0.0, 0.0, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84);
    private static final String EPSG_CODE = "CRS_EPSG_CODE";
    Job refreshJob = new Job(REFRESH_JOB){

        protected IStatus run(IProgressMonitor monitor) {
            BasicWMSRenderer2.this.getContext().clearImage();
            try {
                BasicWMSRenderer2.this.render(BasicWMSRenderer2.this.getContext().getImage().createGraphics(), monitor);
            }
            catch (Throwable e) {
                WMSPlugin.log(e.getLocalizedMessage(), e);
            }
            return Status.OK_STATUS;
        }
    };

    public BasicWMSRenderer2() {
        ClassLoader current = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(WebMapServer.class.getClassLoader());
            Logger logger = Logger.getLogger("org.geotools.data.ows");
            if (WMSPlugin.isDebugging("net.refractions.udig.render.wms.basic/debug/render/trace")) {
                logger.setLevel(Level.FINE);
                logger.addHandler(new Handler(){

                    @Override
                    public void publish(LogRecord record) {
                        System.err.println(record.getMessage());
                    }

                    @Override
                    public void flush() {
                        System.err.flush();
                    }

                    @Override
                    public void close() throws SecurityException {
                    }
                });
            } else {
                logger.setLevel(Level.SEVERE);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(current);
        }
    }

    public void render(Graphics2D destination, IProgressMonitor monitor) throws RenderException {
        this.render(destination, this.getContext().getImageBounds(), monitor);
    }

    public void render(IProgressMonitor monitor) throws RenderException {
        Graphics2D graphics = (Graphics2D)this.getContext().getImage().getGraphics();
        this.render(graphics, this.getRenderBounds(), monitor);
    }

    public synchronized void render(Graphics2D destination, ReferencedEnvelope bounds, IProgressMonitor monitor) throws RenderException {
        int endLayerStatus = 0;
        try {
            if (bounds == null || bounds.isNull()) {
                bounds = this.getContext().getImageBounds();
            }
            if (monitor.isCanceled()) {
                return;
            }
            this.getContext().setStatus(1);
            WebMapServer wms = this.getWMS();
            GetMapRequest request = wms.createGetMapRequest();
            WMSCapabilities capabilities = wms.getCapabilities();
            if (capabilities.getRequest().getGetMap().getFormats().contains("application/vnd.ogc.se_xml")) {
                request.setExceptions("application/vnd.ogc.se_xml");
            }
            this.setImageFormat(wms, request);
            if (monitor.isCanceled()) {
                return;
            }
            double currScale = this.getContext().getViewportModel().getScaleDenominator();
            List<ILayer> layers = this.getLayers();
            int i = layers.size() - 1;
            while (i >= 0) {
                ILayer ilayer = layers.get(i);
                double minScale = 0.0;
                double maxScale = Double.MAX_VALUE;
                Layer layer = (Layer)ilayer.getResource(Layer.class, null);
                StyleBlackboard sb = (StyleBlackboard)ilayer.getStyleBlackboard();
                Style style = (Style)sb.lookup(Style.class);
                if (style != null) {
                    Rule rule = style.getFeatureTypeStyles()[0].getRules()[0];
                    minScale = rule.getMinScaleDenominator();
                    maxScale = rule.getMaxScaleDenominator();
                }
                if (currScale >= minScale && currScale <= maxScale) {
                    StyleImpl wmsStyle = (StyleImpl)ilayer.getStyleBlackboard().get("net.refractions.udig.render.wmsStyle");
                    if (wmsStyle != null) {
                        request.addLayer(layer, wmsStyle);
                    } else {
                        request.addLayer(layer);
                    }
                }
                --i;
            }
            if (monitor.isCanceled()) {
                return;
            }
            List<Layer> wmsLayers = this.getWMSLayers();
            if (wmsLayers == null || wmsLayers.isEmpty()) {
                endLayerStatus = 4;
                return;
            }
            CoordinateReferenceSystem viewportCRS = this.getViewportCRS();
            IMap map = this.getContext().getMap();
            String requestCRScode = BasicWMSRenderer2.findRequestCRS(wmsLayers, viewportCRS, map);
            CoordinateReferenceSystem requestCRS = CRS.decode((String)requestCRScode);
            ReferencedEnvelope requestBBox = null;
            ReferencedEnvelope backprojectedBBox = null;
            requestBBox = BasicWMSRenderer2.calculateRequestBBox(wmsLayers, bounds, requestCRS, capabilities.getVersion());
            if (requestBBox == NILL_BOX) {
                endLayerStatus = 4;
                return;
            }
            assert (requestBBox.getCoordinateReferenceSystem().equals(requestCRS));
            backprojectedBBox = requestBBox.getCoordinateReferenceSystem().equals(viewportCRS) ? requestBBox : requestBBox.transform(viewportCRS, true);
            if (WMSPlugin.isDebugging("net.refractions.udig.render.wms.basic/debug/render/trace")) {
                WMSPlugin.trace("Viewport CRS: " + viewportCRS.getName());
                WMSPlugin.trace("Request CRS: " + requestCRS.getName());
                WMSPlugin.trace("Context Image bounds: " + this.getContext().getImageBounds());
                WMSPlugin.trace("Request BBox  bounds: " + requestBBox);
                WMSPlugin.trace("Backprojected request bounds: " + backprojectedBBox);
            }
            Service wmsService = capabilities.getService();
            Dimension maxDimensions = new Dimension(wmsService.getMaxWidth(), wmsService.getMaxHeight());
            Dimension imageDimensions = BasicWMSRenderer2.calculateImageDimensions(this.getContext().getImageSize(), maxDimensions, (Envelope)bounds, (Envelope)backprojectedBBox);
            if (imageDimensions.height < 1 || imageDimensions.width < 1) {
                endLayerStatus = 4;
                return;
            }
            request.setDimensions(String.valueOf(imageDimensions.width), String.valueOf(imageDimensions.height));
            Set identifiers = requestCRS.getIdentifiers();
            String srs = identifiers.isEmpty() ? EPSG_4326 : ((ReferenceIdentifier)identifiers.iterator().next()).toString();
            request.setSRS(srs);
            request.setBBox((org.opengis.geometry.Envelope)requestBBox);
            if (monitor.isCanceled()) {
                return;
            }
            this.setFilter(wms, request);
            BufferedImage image = this.readImage(wms, request, monitor);
            if (monitor.isCanceled()) {
                return;
            }
            try {
                if (image == null) {
                    RuntimeException e = new RuntimeException(Messages.BasicWMSRenderer2_unable_to_decode_image);
                    throw this.wrapException(e);
                }
                this.renderGridCoverage(destination, (Envelope)backprojectedBBox, imageDimensions, requestBBox, image);
            }
            catch (Exception e) {
                if (e instanceof RenderException) {
                    throw (RenderException)e;
                }
                throw new RenderException((Throwable)e);
            }
        }
        finally {
            this.getContext().setStatus(endLayerStatus);
            if (endLayerStatus == 0) {
                this.getContext().setStatusMessage(null);
            }
        }
    }

    private void setFilter(WebMapServer wms, GetMapRequest request) {
        Object mapFilter = null;
        HashMap<ILayer, Filter> filters = new HashMap<ILayer, Filter>();
        List layers = this.getContext().getLayers();
        for (ILayer layer : layers) {
            Object layerFilter = layer.getStyleBlackboard().get("net.refractions.udig.project.view");
            Object filter = layerFilter instanceof Query ? ((Query)layerFilter).getFilter() : (layerFilter instanceof Filter ? (Filter)layerFilter : mapFilter);
            if (filter == null || filter == Filter.INCLUDE) continue;
            filters.put(layer, (Filter)filter);
        }
        if (filters.isEmpty()) {
            return;
        }
        StringBuilder builder = new StringBuilder();
        HashMap hashMap = new HashMap();
        for (Map.Entry entry : filters.entrySet()) {
            if (entry.getValue() == null) {
                builder.append('(');
            }
            try {
                StringWriter writer = new StringWriter();
                DocumentWriter.writeDocument(entry.getValue(), (Schema)FilterSchema.getInstance(), (Writer)writer, hashMap);
                builder.append(writer.toString());
            }
            catch (OperationNotSupportedException e) {
                WMSPlugin.log("Error writing filter for layer: " + ((ILayer)entry.getKey()).getID(), e);
                builder.append("<Filter/>");
            }
            catch (IOException e) {
                assert (false);
                WMSPlugin.log("Error writing filter for layer: " + ((ILayer)entry.getKey()).getID(), e);
                builder.append("<Filter/>");
            }
            builder.append(')');
        }
        try {
            String encode = URLEncoder.encode(builder.toString(), "UTF-8");
            request.setVendorSpecificParameter("filter", encode);
        }
        catch (UnsupportedEncodingException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
    }

    private void renderGridCoverage(Graphics2D graphics, Envelope bounds, Dimension dimension, ReferencedEnvelope requestBBox, BufferedImage image) throws Exception {
        CoordinateReferenceSystem destinationCRS = this.getContext().getCRS();
        Envelope envelope = bounds;
        if (envelope == null || envelope.isNull()) {
            envelope = this.getContext().getImageBounds();
        }
        Point upperLeft = this.getContext().worldToPixel(new Coordinate(envelope.getMinX(), envelope.getMinY()));
        Point bottomRight = this.getContext().worldToPixel(new Coordinate(envelope.getMaxX(), envelope.getMaxY()));
        Rectangle screenSize = new Rectangle(upperLeft);
        screenSize.add(bottomRight);
        GridCoverage2D coverage = this.convertImageToGridCoverage(requestBBox, image);
        AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((Envelope)envelope, (Rectangle)screenSize, (CoordinateReferenceSystem)destinationCRS);
        GridCoverageRenderer paint = new GridCoverageRenderer(destinationCRS, envelope, screenSize, worldToScreen);
        RasterSymbolizer symbolizer = CommonFactoryFinder.getStyleFactory(null).createRasterSymbolizer();
        paint.paint(graphics, coverage, symbolizer);
    }

    private GridCoverage2D convertImageToGridCoverage(ReferencedEnvelope requestBBox, BufferedImage image) throws RenderException {
        ReferencedEnvelope env = requestBBox;
        GeneralEnvelope gtEnv = new GeneralEnvelope(new double[]{env.getMinX(), env.getMinY()}, new double[]{env.getMaxX(), env.getMaxY()});
        try {
            gtEnv.setCoordinateReferenceSystem(requestBBox.getCoordinateReferenceSystem());
        }
        catch (Exception e) {
            throw this.wrapException(e);
        }
        GridCoverageFactory factory = new GridCoverageFactory();
        GridCoverage2D gc = factory.create((CharSequence)"GridCoverage", (RenderedImage)image, (org.opengis.geometry.Envelope)gtEnv);
        return gc;
    }

    private void setImageFormat(WebMapServer wms, GetMapRequest request) {
        String[] preferredFormats;
        List formats = wms.getCapabilities().getRequest().getGetMap().getFormats();
        String str = this.getPreferencesStore().getBoolean("useDefaultOrder") ? this.getPreferencesStore().getDefaultString("imageTypeOrder") : this.getPreferencesStore().getString("imageTypeOrder");
        String[] stringArray = preferredFormats = str.split(",");
        int n = preferredFormats.length;
        int n2 = 0;
        while (n2 < n) {
            String format = stringArray[n2];
            if (formats.contains(format)) {
                request.setProperty("FORMAT", format);
                request.setTransparent(this.formatSupportsTransparency(format));
                break;
            }
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage readImage(final WebMapServer wms, final GetMapRequest request, IProgressMonitor monitor) throws RenderException {
        final BufferedImage[] image = new BufferedImage[1];
        final RenderException[] exception = new RenderException[1];
        final Object condition = new Object();
        Thread thread = new Thread(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Loose catch block
             */
            @Override
            public void run() {
                block38: {
                    InputStream inputStream = null;
                    try {
                        inputStream = wms.issueRequest(request).getInputStream();
                        image[0] = ImageIO.read(inputStream);
                    }
                    catch (IOException e1) {
                        exception[0] = BasicWMSRenderer2.this.wrapException(e1);
                        Object object = condition;
                        synchronized (object) {
                            condition.notify();
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e2) {
                                WMSPlugin.log("failed to close input stream!!!", e2);
                            }
                        }
                        break block38;
                    }
                    catch (ServiceException e) {
                        exception[0] = BasicWMSRenderer2.this.wrapException(e);
                        Object e2 = condition;
                        synchronized (e2) {
                            condition.notify();
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e3) {
                                WMSPlugin.log("failed to close input stream!!!", e3);
                            }
                        }
                        break block38;
                    }
                    catch (Throwable t) {
                        String message = Messages.BasicWMSRenderer2_errorObtainingImage;
                        image[0] = BasicWMSRenderer2.this.getContext().getImage();
                        exception[0] = new RenderException(message, t);
                        Object e3 = condition;
                        {
                            catch (Throwable throwable) {
                                e = condition;
                                synchronized (e) {
                                    condition.notify();
                                }
                                if (inputStream != null) {
                                    try {
                                        inputStream.close();
                                    }
                                    catch (IOException e2) {
                                        WMSPlugin.log("failed to close input stream!!!", e2);
                                    }
                                }
                                throw throwable;
                            }
                        }
                        synchronized (e3) {
                            condition.notify();
                        }
                        if (inputStream != null) {
                            try {
                                inputStream.close();
                            }
                            catch (IOException e) {
                                WMSPlugin.log("failed to close input stream!!!", e);
                            }
                        }
                        break block38;
                    }
                    Object e2 = condition;
                    synchronized (e2) {
                        condition.notify();
                    }
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException e4) {
                            WMSPlugin.log("failed to close input stream!!!", e4);
                        }
                    }
                }
            }
        };
        thread.start();
        int time = 0;
        while (image[0] == null && !monitor.isCanceled() && exception[0] == null) {
            Object object = condition;
            synchronized (object) {
                try {
                    condition.wait(200L);
                    if ((time += 200) == 1000) {
                        this.setState(2);
                        time = 0;
                    }
                }
                catch (InterruptedException e) {
                    thread.interrupt();
                    throw this.wrapException(e);
                }
            }
        }
        if (exception[0] != null) {
            throw exception[0];
        }
        return image[0];
    }

    private boolean formatSupportsTransparency(String format) {
        if (format.equalsIgnoreCase("image/png")) {
            return true;
        }
        if (format.equalsIgnoreCase("image/png8")) {
            return true;
        }
        if (format.equalsIgnoreCase("image/gif")) {
            return true;
        }
        if (format.equalsIgnoreCase("image/tiff")) {
            return true;
        }
        return format.equalsIgnoreCase("image/bmp");
    }

    public static Dimension calculateImageDimensions(Dimension displaySize, Dimension maxDimensions, Envelope viewport, Envelope request) throws RenderException {
        int maxHeight;
        double xScale = request.getWidth() / viewport.getWidth();
        double yScale = request.getHeight() / viewport.getHeight();
        int width = (int)(xScale * displaySize.getWidth());
        int height = (int)(yScale * displaySize.getHeight());
        int maxWidth = (int)maxDimensions.getWidth();
        if (maxWidth > 0 && width > maxWidth) {
            width = maxWidth;
        }
        if ((maxHeight = (int)maxDimensions.getHeight()) > 0 && height > maxHeight) {
            height = maxHeight;
        }
        WMSPlugin.trace("WMS request image dimensions: " + width + ", " + height);
        return new Dimension(width, height);
    }

    public Point calculateImageOffset(Point min, Point max) throws RenderException {
        return new Point(Math.min(min.x, max.x), max.y);
    }

    public static ReferencedEnvelope calculateRequestBBox(List<Layer> wmsLayers, ReferencedEnvelope viewport, CoordinateReferenceSystem requestCRS) throws MismatchedDimensionException, TransformException, FactoryException {
        return BasicWMSRenderer2.calculateRequestBBox(wmsLayers, viewport, requestCRS, "1.1.1");
    }

    public static ReferencedEnvelope calculateRequestBBox(List<Layer> wmsLayers, ReferencedEnvelope viewport, CoordinateReferenceSystem requestCRS, String version) throws MismatchedDimensionException, TransformException, FactoryException {
        Object interestBBox;
        ReferencedEnvelope reprojectedViewportBBox;
        ReferencedEnvelope layersBBox = BasicWMSRenderer2.getLayersBoundingBox(requestCRS, wmsLayers, version);
        if (BasicWMSRenderer2.isEnvelopeNull((Envelope)layersBBox)) {
            WMSPlugin.log("Zero width/height envelope: wmsLayers = " + layersBBox);
            layersBBox = null;
        }
        if (BasicWMSRenderer2.isEnvelopeNull((Envelope)(reprojectedViewportBBox = viewport.transform(requestCRS, true)))) {
            WMSPlugin.log("Zero width/height envelope: reprojected viewport from " + viewport + " to " + requestCRS + " returned " + reprojectedViewportBBox);
        }
        if (BasicWMSRenderer2.isEnvelopeNull((Envelope)(interestBBox = layersBBox == null ? reprojectedViewportBBox : reprojectedViewportBBox.intersection((Envelope)layersBBox)))) {
            WMSPlugin.trace("Bounds of the data are outside the bounds of the viewscreen.");
            return NILL_BOX;
        }
        ReferencedEnvelope requestBBox = new ReferencedEnvelope((Envelope)interestBBox, requestCRS);
        return requestBBox;
    }

    private static boolean isEnvelopeNull(Envelope bbox) {
        return bbox.getWidth() <= 0.0 || bbox.getHeight() <= 0.0;
    }

    private static ReferencedEnvelope swapAxis(ReferencedEnvelope envelope) {
        double min0 = envelope.getLowerCorner().getOrdinate(0);
        double min1 = envelope.getLowerCorner().getOrdinate(1);
        double max0 = envelope.getUpperCorner().getOrdinate(0);
        double max1 = envelope.getUpperCorner().getOrdinate(1);
        ReferencedEnvelope swap = new ReferencedEnvelope(min1, max1, min0, max0, envelope.getCoordinateReferenceSystem());
        return swap;
    }

    public static ReferencedEnvelope getLayersBoundingBox(CoordinateReferenceSystem crs, List<Layer> layers, String version) {
        ReferencedEnvelope envelope = null;
        for (Layer layer : layers) {
            GeneralEnvelope temp = layer.getEnvelope(crs);
            if (temp == null) continue;
            ReferencedEnvelope jtsTemp = ReferencedEnvelope.reference((org.opengis.geometry.Envelope)temp);
            if (envelope == null) {
                envelope = jtsTemp;
                continue;
            }
            envelope.expandToInclude((Envelope)jtsTemp);
        }
        return envelope;
    }

    public static String findRequestCRS(List<Layer> layers, CoordinateReferenceSystem viewportCRS, IMap map) {
        String match;
        String requestCRS = null;
        if (layers == null || layers.isEmpty()) {
            return null;
        }
        Collection<String> viewportEPSG = BasicWMSRenderer2.extractEPSG(map, viewportCRS);
        if (viewportEPSG != null && (match = BasicWMSRenderer2.matchEPSG(layers, viewportEPSG)) != null) {
            return match;
        }
        if (BasicWMSRenderer2.matchEPSG(layers, CRS_84)) {
            return CRS_84;
        }
        if (BasicWMSRenderer2.matchEPSG(layers, EPSG_4326)) {
            return EPSG_4326;
        }
        if (BasicWMSRenderer2.matchEPSG(layers, EPSG_4269)) {
            return EPSG_4269;
        }
        Layer firstLayer = layers.get(0);
        for (Object object : firstLayer.getSrs()) {
            String epsgCode = (String)object;
            try {
                CoordinateReferenceSystem check = CRS.decode((String)epsgCode);
                if (check == null) {
                    continue;
                }
            }
            catch (NoSuchAuthorityCodeException noSuchAuthorityCodeException) {
                continue;
            }
            catch (FactoryException e) {
                e.printStackTrace();
            }
            if (!BasicWMSRenderer2.matchEPSG(layers, epsgCode)) continue;
            requestCRS = epsgCode;
            return requestCRS;
        }
        if (requestCRS == null) {
            WMSPlugin.log("ERROR: Illegal State: Basic WMS Renderer contains layers with no common CRS. Unable to perform request.");
            return null;
        }
        return requestCRS;
    }

    private static String matchEPSG(List<Layer> layers, Collection<String> epsgCodes) {
        for (String epsg : epsgCodes) {
            if (!BasicWMSRenderer2.matchEPSG(layers, epsg)) continue;
            return epsg;
        }
        return null;
    }

    private static Collection<String> extractEPSG(final IMap map, final CoordinateReferenceSystem crs) {
        boolean search;
        final ArrayList<String> codes = new ArrayList<String>();
        if (CRS.equalsIgnoreMetadata((Object)crs, (Object)DefaultGeographicCRS.WGS84)) {
            codes.add(CRS_84);
            codes.add(EPSG_4326);
            return codes;
        }
        codes.addAll(CRSUtil.extractAuthorityCodes((CoordinateReferenceSystem)crs));
        boolean bl = search = map.getBlackboard().get(EPSG_CODE) != "DONT_FIND";
        if (codes.isEmpty() && search) {
            PlatformGIS.syncInDisplayThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    Shell shell = Display.getCurrent().getActiveShell();
                    ProgressMonitorDialog dialog = new ProgressMonitorDialog(shell);
                    try {
                        dialog.run(false, true, new IRunnableWithProgress(){

                            public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                                CoordinateReferenceSystem found = CRSUtil.findEPSGCode((CoordinateReferenceSystem)crs, (IProgressMonitor)monitor);
                                if (found == null) {
                                    return;
                                }
                                ViewportModel model = (ViewportModel)map.getViewportModel();
                                model.eSetDeliver(false);
                                try {
                                    model.setCRS(found);
                                    codes.addAll(CRSUtil.extractAuthorityCodes((CoordinateReferenceSystem)found));
                                }
                                finally {
                                    model.eSetDeliver(true);
                                }
                            }
                        });
                    }
                    catch (InvocationTargetException e) {
                        WMSPlugin.log("Error tracking down EPSG Code", e);
                        BasicWMSRenderer2.dontFind(map, "DONT_FIND");
                    }
                    catch (InterruptedException e) {
                        WMSPlugin.log("Error tracking down EPSG Code", e);
                        BasicWMSRenderer2.dontFind(map, "DONT_FIND");
                    }
                    BasicWMSRenderer2.dontFind(map, "DONT_FIND");
                }
            });
        }
        return codes;
    }

    private static void dontFind(IMap map, String DONT_FIND) {
        map.getBlackboard().put(EPSG_CODE, (Object)DONT_FIND);
    }

    private static boolean matchEPSG(List<Layer> layers, String epsgCode) {
        boolean match = true;
        for (Layer layer : layers) {
            Set srs = layer.getSrs();
            if (srs.contains(epsgCode)) continue;
            match = false;
            break;
        }
        return match;
    }

    private List<ILayer> getLayers() {
        ArrayList<ILayer> layers = new ArrayList<ILayer>();
        ICompositeRenderContext context1 = this.getContext();
        IRenderContext[] contexts = context1.getContexts().toArray(new IRenderContext[context1.getContexts().size()]);
        if (contexts.length == 0) {
            throw new RuntimeException(Messages.BasicWMSRenderer2_no_layers_to_render);
        }
        IRenderContext[] iRenderContextArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            IRenderContext renderContext = iRenderContextArray[n2];
            if (renderContext.getLayer().isVisible()) {
                layers.add(renderContext.getLayer());
            }
            ++n2;
        }
        if (layers.isEmpty()) {
            WMSPlugin.log("WARNING: WMS Renderer contains no layers.");
        }
        return layers;
    }

    private List<Layer> getWMSLayers() throws IOException {
        ArrayList<Layer> layers = new ArrayList<Layer>();
        for (ILayer iLayer : this.getLayers()) {
            Layer layer = (Layer)iLayer.getResource(Layer.class, null);
            layers.add(layer);
        }
        return layers;
    }

    private WebMapServer getWMS() throws IOException {
        return (WebMapServer)this.getContext().getLayer().getResource(WebMapServer.class, null);
    }

    public void dispose() {
    }

    public void refreshImage() throws RenderException {
        if (this.needRefresh()) {
            this.refreshJob.schedule();
            try {
                this.refreshJob.join();
            }
            catch (InterruptedException interruptedException) {}
        }
    }

    protected boolean needRefresh() {
        return false;
    }

    public RenderException wrapException(Throwable t) {
        this.getContext().setStatus(2);
        RenderException renderException = new RenderException(t.getLocalizedMessage());
        renderException.initCause(t);
        return renderException;
    }

    public ICompositeRenderContext getContext() {
        return (ICompositeRenderContext)super.getContext();
    }

    private CoordinateReferenceSystem getViewportCRS() {
        return this.getContext().getViewportModel().getCRS();
    }

    private IPreferenceStore getPreferencesStore() {
        return WMSPlugin.getDefault().getPreferenceStore();
    }
}

