/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.wms.basic;

import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import net.refractions.udig.render.internal.wms.basic.BasicWMSMetrics2;
import net.refractions.udig.render.internal.wms.basic.BasicWMSRenderer2;
import org.geotools.data.ows.Layer;
import org.geotools.data.wms.WebMapServer;
import org.geotools.referencing.CRS;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.NoSuchAuthorityCodeException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;

public class BasicWMSMetricsFactory2
implements IRenderMetricsFactory {
    Map<String, CoordinateReferenceSystem> crsCache = new HashMap<String, CoordinateReferenceSystem>();
    Map<Pair, MathTransform> transformCache = new HashMap<Pair, MathTransform>();
    Map<Layer, Set<CoordinateReferenceSystem>> legalCRSCache = new HashMap<Layer, Set<CoordinateReferenceSystem>>();

    public boolean canRender(IRenderContext toolkit) {
        Layer layer;
        if (!toolkit.getLayer().hasResource(WebMapServer.class)) {
            return false;
        }
        CoordinateReferenceSystem crs = toolkit.getViewportModel().getCRS();
        if (crs == null) {
            return true;
        }
        try {
            layer = (Layer)toolkit.getLayer().getResource(Layer.class, null);
        }
        catch (IOException iOException) {
            return false;
        }
        if (layer == null) {
            return false;
        }
        Set<CoordinateReferenceSystem> crss = this.legalCRSCache.get(layer);
        if (crss != null && crss.contains(crs)) {
            return true;
        }
        if (this.searchForCRSMatch(crs, layer)) {
            if (crss == null) {
                crss = new HashSet<CoordinateReferenceSystem>();
                this.legalCRSCache.put(layer, crss);
            }
            crss.add(crs);
            return true;
        }
        return false;
    }

    private boolean searchForCRSMatch(CoordinateReferenceSystem crs, Layer layer) {
        Set srs = layer.getSrs();
        Iterator i = srs.iterator();
        while (i.hasNext()) {
            CoordinateReferenceSystem rs;
            block4: {
                try {
                    String epsgCode = (String)i.next();
                    rs = this.getCRS(epsgCode);
                    if (!rs.equals(crs)) break block4;
                    return true;
                }
                catch (Throwable throwable) {}
            }
            MathTransform transform = this.getMathTransform(crs, rs);
            if (transform == null) continue;
            return true;
        }
        return false;
    }

    private synchronized MathTransform getMathTransform(CoordinateReferenceSystem from, CoordinateReferenceSystem to) throws FactoryException {
        Pair pair = new Pair(from, to);
        MathTransform result = this.transformCache.get(pair);
        if (result == null) {
            result = CRS.findMathTransform((CoordinateReferenceSystem)from, (CoordinateReferenceSystem)to, (boolean)true);
            this.transformCache.put(pair, result);
        }
        return result;
    }

    private synchronized CoordinateReferenceSystem getCRS(String epsgCode) throws NoSuchAuthorityCodeException {
        CoordinateReferenceSystem result = this.crsCache.get(epsgCode);
        if (result == null) {
            try {
                result = CRS.decode((String)epsgCode);
            }
            catch (FactoryException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
            this.crsCache.put(epsgCode, result);
        }
        return result;
    }

    public AbstractRenderMetrics createMetrics(IRenderContext context) {
        return new BasicWMSMetrics2(context, this);
    }

    public Class getRendererType() {
        return BasicWMSRenderer2.class;
    }

    private class Pair {
        final CoordinateReferenceSystem from;
        final CoordinateReferenceSystem to;

        public Pair(CoordinateReferenceSystem from, CoordinateReferenceSystem to) {
            this.from = from;
            this.to = to;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.from == null ? 0 : this.from.hashCode());
            result = 31 * result + (this.to == null ? 0 : this.to.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            Pair other = (Pair)obj;
            if (this.from == null ? other.from != null : !this.from.equals(other.from)) {
                return false;
            }
            return !(this.to == null ? other.to != null : !this.to.equals(other.to));
        }
    }
}

