/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.wms.basic;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.render.Renderer;
import net.refractions.udig.project.render.AbstractRenderMetrics;
import net.refractions.udig.project.render.ICompositeRenderContext;
import net.refractions.udig.project.render.IRenderContext;
import net.refractions.udig.project.render.IRenderMetricsFactory;
import net.refractions.udig.render.internal.wms.basic.BasicWMSMetricsFactory2;
import net.refractions.udig.render.internal.wms.basic.BasicWMSRenderer2;
import net.refractions.udig.render.wms.basic.WMSPlugin;
import net.refractions.udig.ui.ProgressManager;
import net.refractions.udig.ui.graphics.SLDs;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.ows.Layer;
import org.geotools.data.ows.StyleImpl;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.Style;
import org.geotools.util.Range;

public class BasicWMSMetrics2
extends AbstractRenderMetrics {
    private static List<String> listExpectedStyleIds() {
        ArrayList<String> styleIds = new ArrayList<String>();
        styleIds.add("net.refractions.udig.render.wmsStyle");
        styleIds.add("net.refractions.udig.style.sld");
        styleIds.add("net.refractions.udig.project.view");
        return styleIds;
    }

    public BasicWMSMetrics2(IRenderContext context2, BasicWMSMetricsFactory2 factory) {
        super(context2, (IRenderMetricsFactory)factory, BasicWMSMetrics2.listExpectedStyleIds());
    }

    public Renderer createRenderer() {
        BasicWMSRenderer2 renderer = new BasicWMSRenderer2();
        renderer.setContext(this.context);
        return renderer;
    }

    public IRenderContext getRenderContext() {
        return this.context;
    }

    public IRenderMetricsFactory getRenderMetricsFactory() {
        return this.factory;
    }

    public boolean canAddLayer(ILayer layer) {
        IService currentService;
        if (!layer.hasResource(Layer.class)) {
            return false;
        }
        try {
            if (!layer.findGeoResource(Layer.class).parent(ProgressManager.instance().get(new Object[0])).equals(this.getRenderContext().getGeoResource().parent(ProgressManager.instance().get(new Object[0])))) {
                return false;
            }
        }
        catch (IOException iOException) {
            return false;
        }
        double opacity = Double.NaN;
        ICompositeRenderContext context1 = (ICompositeRenderContext)this.context;
        Object[] contexts = context1.getContexts().toArray(new IRenderContext[context1.getContexts().size()]);
        Arrays.sort(contexts);
        ArrayList<Layer> owsLayers = new ArrayList<Layer>();
        try {
            owsLayers.add((Layer)layer.getResource(Layer.class, (IProgressMonitor)new NullProgressMonitor()));
            currentService = (IService)layer.getResource(IService.class, null);
        }
        catch (IOException e1) {
            WMSPlugin.log("", e1);
            return false;
        }
        Object[] objectArray = contexts;
        int n = contexts.length;
        int n2 = 0;
        while (n2 < n) {
            Object renderContext = objectArray[n2];
            ILayer previousLayer = renderContext.getLayer();
            try {
                owsLayers.add((Layer)previousLayer.getResource(Layer.class, (IProgressMonitor)new NullProgressMonitor()));
                IService previousService = (IService)previousLayer.getResource(IService.class, null);
                if (currentService != previousService) {
                    return false;
                }
            }
            catch (IOException e) {
                WMSPlugin.log("Error while retrieving service.", e);
                return false;
            }
            if (BasicWMSRenderer2.findRequestCRS(owsLayers, this.context.getCRS(), this.context.getMap()) == null) {
                return false;
            }
            Style style = (Style)previousLayer.getStyleBlackboard().get("net.refractions.udig.style.sld");
            if (style != null) {
                opacity = SLDs.rasterOpacity((RasterSymbolizer)SLDs.rasterSymbolizer((Style)style));
            }
            ++n2;
        }
        Style style = (Style)layer.getStyleBlackboard().get("net.refractions.udig.style.sld");
        if (style == null && Double.isNaN(opacity)) {
            return true;
        }
        double result = SLDs.rasterOpacity((RasterSymbolizer)SLDs.rasterSymbolizer((Style)style));
        return result == opacity;
    }

    public boolean canStyle(String SyleID, Object value) {
        if (value == null) {
            return false;
        }
        if (value instanceof Style) {
            return !Double.isNaN(SLDs.rasterOpacity((Style)((Style)value)));
        }
        if (value instanceof StyleImpl && this.getRenderContext().getGeoResource().canResolve(Layer.class)) {
            try {
                Layer layer = (Layer)this.getRenderContext().getGeoResource().resolve(Layer.class, ProgressManager.instance().get(new Object[0]));
                return layer.getStyles().contains(value);
            }
            catch (IOException iOException) {
                return false;
            }
        }
        return false;
    }

    public boolean isOptimized() {
        return false;
    }

    public Set<Range<Double>> getValidScaleRanges() {
        HashSet<Range<Double>> ranges = new HashSet<Range<Double>>();
        try {
            Layer layer = (Layer)this.context.getGeoResource().resolve(Layer.class, ProgressManager.instance().get(new Object[0]));
            double min = layer.getScaleDenominatorMin();
            double max = layer.getScaleDenominatorMax();
            if (this.invalidScale(min) && this.invalidScale(max)) {
                return ranges;
            }
            if (this.invalidScale(min)) {
                min = Double.MIN_VALUE;
            }
            if (this.invalidScale(max)) {
                max = Double.MAX_VALUE;
            }
            if (min < max) {
                ranges.add((Range<Double>)new Range(Double.class, (Comparable)Double.valueOf(min), (Comparable)Double.valueOf(max)));
            } else {
                ranges.add((Range<Double>)new Range(Double.class, (Comparable)Double.valueOf(max), (Comparable)Double.valueOf(min)));
            }
        }
        catch (IOException e) {
            throw (RuntimeException)new RuntimeException().initCause(e);
        }
        return ranges;
    }

    private boolean invalidScale(double value) {
        return Double.isInfinite(value) || Double.isNaN(value);
    }
}

