/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.postgis.ui;

import java.io.IOException;
import java.io.Serializable;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.refractions.udig.catalog.PostgisServiceExtension2;
import net.refractions.udig.catalog.internal.postgis.PostgisPlugin;
import net.refractions.udig.catalog.internal.postgis.ui.PostgisServiceDialect;
import net.refractions.udig.catalog.service.database.LookUpSchemaRunnable;
import net.refractions.udig.catalog.service.database.TableDescriptor;
import net.refractions.udig.core.Pair;
import org.apache.commons.dbcp.BasicDataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.DataSourceException;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class PostgisLookUpSchemaRunnable
implements LookUpSchemaRunnable {
    private final String host;
    private final int port;
    private final String username;
    private final String password;
    private final String database;
    private final Set<TableDescriptor> tables = new HashSet<TableDescriptor>();
    private volatile String error;
    private volatile boolean ran = false;

    public PostgisLookUpSchemaRunnable(String host, int port, String username, String password, String database) {
        this.host = host;
        this.port = port;
        this.username = username;
        this.password = password;
        this.database = database;
    }

    public void run(IProgressMonitor monitor) {
        monitor.beginTask("Loading Database tables", 3);
        monitor.worked(1);
        try {
            this.loadTableDescriptors();
        }
        catch (SQLException e) {
            this.error = "An error occurred while looking up list of tables.  Check that you entered the correct username and database name.";
            PostgisPlugin.log("error", e);
        }
        catch (DataSourceException e) {
            this.error = "An error occurred while looking up list of tables.  Check that you entered the correct username and database name.";
            PostgisPlugin.log("error", e);
        }
        monitor.done();
        this.ran = true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void loadTableDescriptors() throws SQLException, DataSourceException {
        PostgisNGDataStoreFactory factory = PostgisServiceExtension2.getFactory();
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put(JDBCDataStoreFactory.DBTYPE.key, (Serializable)JDBCDataStoreFactory.DBTYPE.sample);
        params.put(JDBCDataStoreFactory.HOST.key, this.host);
        params.put(PostgisNGDataStoreFactory.PORT.key, this.port);
        params.put(JDBCDataStoreFactory.USER.key, this.username);
        params.put(JDBCDataStoreFactory.PASSWD.key, this.password);
        params.put(JDBCDataStoreFactory.DATABASE.key, this.database);
        BasicDataSource dataSource = null;
        Connection connection = null;
        try {
            dataSource = factory.createDataSource(params);
            connection = dataSource.getConnection();
            Statement statement = connection.createStatement();
            if (!this.hasWritableTable("geometry_columns", "f_geometry_column", statement)) {
                this.error = "Database is not a Postgis Database.\nThe 'geometry_columns' table is either missing or not accessible";
                return;
            }
            try {
                if (!this.hasWritableTable("spatial_ref_sys", "srid", statement)) {
                    this.error = "Database is not a Postgis Database.\nThe 'srid' table is either missing or not accessible";
                    return;
                }
                ArrayList<Pair<String, String>> tableNames = new ArrayList<Pair<String, String>>();
                ResultSet resultSet = statement.executeQuery("SELECT schemaname, tablename FROM pg_tables ORDER BY schemaname, tablename;");
                while (resultSet.next()) {
                    String schema = resultSet.getString("schemaname");
                    String table = resultSet.getString("tablename");
                    tableNames.add((Pair<String, String>)Pair.create((Object)schema, (Object)table));
                }
                Set<TableDescriptor> results = this.lookupGeometryColumn(tableNames, connection);
                this.tables.addAll(results);
                statement.close();
                return;
            }
            catch (SQLException e) {
                this.error = "An error occurred when querying the database about the data it contains. Please talk to the administrator: " + e.getMessage();
                return;
            }
            catch (IOException io) {
                this.error = "An error occurred when querying the database about the data it contains. Please talk to the administrator: " + io.getMessage();
            }
            return;
        }
        finally {
            if (connection != null) {
                connection.close();
            }
            if (dataSource != null) {
                dataSource.close();
            }
        }
    }

    private boolean hasWritableTable(String tablename, String column, Statement statement) {
        try {
            StringBuilder stringBuilder = new StringBuilder();
            stringBuilder.append("select ");
            stringBuilder.append(column);
            stringBuilder.append(" from ");
            stringBuilder.append(tablename);
            stringBuilder.append(" limit 0;");
            statement.executeQuery(stringBuilder.toString());
            return true;
        }
        catch (SQLException sQLException) {
            return false;
        }
    }

    private Set<TableDescriptor> lookupGeometryColumn(List<Pair<String, String>> tablenames, Connection connection) throws SQLException {
        PostgisServiceDialect dialect = new PostgisServiceDialect();
        Statement statement = connection.createStatement();
        try {
            StringBuilder where = new StringBuilder();
            for (Pair<String, String> pair : tablenames) {
                if (where.length() > 0) {
                    where.append(" or ");
                }
                String schema = (String)pair.left();
                String table = (String)pair.right();
                where.append(MessageFormat.format(" ( {0}=''{1}'' AND {2}=''{3}'')", "f_table_name", table, "f_table_schema", schema));
            }
            ResultSet results = statement.executeQuery(MessageFormat.format("SELECT {0}, {1}, {2}, {3}, {4} FROM geometry_columns WHERE {5};", "f_geometry_column", "type", "srid", "f_table_name", "f_table_schema", where));
            while (results.next()) {
                String srid = results.getString("srid");
                String geomType = results.getString("type");
                String geom = results.getString("f_geometry_column");
                String table = results.getString("f_table_name");
                String schema = results.getString("f_table_schema");
                boolean broken = this.isBroken(connection, table, schema, geom, geomType);
                this.tables.add(new TableDescriptor(table, dialect.toGeomClass(geomType), schema, geom, srid, broken));
            }
            Set<TableDescriptor> set = this.tables;
            return set;
        }
        finally {
            statement.close();
        }
    }

    private boolean isBroken(Connection connection, String table, String schema, String geom, String type) throws SQLException {
        Statement statement = connection.createStatement();
        try {
            String sql = "select " + geom + " from " + schema + "." + table + " limit 0";
            ResultSet results = statement.executeQuery(sql);
            String columnType = results.getMetaData().getColumnTypeName(1);
            boolean bl = !columnType.equalsIgnoreCase(type) && !columnType.equalsIgnoreCase("geometry") && !columnType.equalsIgnoreCase("geometry[]") && !columnType.equalsIgnoreCase("point") && !columnType.equalsIgnoreCase("point[]") && !columnType.equalsIgnoreCase("line") && !columnType.equalsIgnoreCase("line[]") && !columnType.equalsIgnoreCase("polygon") && !columnType.equalsIgnoreCase("polygon[]");
            return bl;
        }
        catch (SQLException sQLException) {
            return false;
        }
        finally {
            statement.close();
        }
    }

    public String getError() throws IllegalStateException {
        if (!this.ran) {
            throw new IllegalStateException("run must complete running before this method is called.");
        }
        return this.error;
    }

    public Set<TableDescriptor> getTableDescriptors() {
        return this.tables;
    }
}

