/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.postgis.ui;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.refractions.udig.catalog.PostgisServiceExtension2;
import net.refractions.udig.catalog.internal.postgis.PostgisPlugin;
import net.refractions.udig.catalog.internal.postgis.ui.PostgisServiceDialect;
import net.refractions.udig.catalog.service.database.DatabaseConnectionRunnable;
import org.apache.commons.dbcp.BasicDataSource;
import org.eclipse.core.runtime.IProgressMonitor;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class PostgisDatabaseConnectionRunnable
implements DatabaseConnectionRunnable {
    private volatile boolean ran = false;
    private volatile String result = null;
    private final Set<String> databaseNames = new HashSet<String>();
    private final String host;
    private final int port;
    private final String username;
    private final String password;

    public PostgisDatabaseConnectionRunnable(String host2, int port2, String username2, String password2) {
        this.host = host2;
        this.port = port2;
        this.username = username2;
        this.password = password2;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        try {
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put(JDBCDataStoreFactory.DBTYPE.key, new PostgisServiceDialect().dbType);
            params.put(JDBCDataStoreFactory.HOST.key, this.host);
            params.put(PostgisNGDataStoreFactory.PORT.key, this.port);
            params.put(JDBCDataStoreFactory.USER.key, this.username);
            params.put(JDBCDataStoreFactory.PASSWD.key, this.password);
            params.put(JDBCDataStoreFactory.DATABASE.key, "template1");
            BasicDataSource source = PostgisServiceExtension2.getFactory().createDataSource(params);
            Connection connection = source.getConnection();
            try {
                Statement statement = connection.createStatement();
                if (statement.execute("SELECT datname FROM pg_database")) {
                    ResultSet resultSet = statement.getResultSet();
                    while (resultSet.next()) {
                        this.databaseNames.add(resultSet.getString("datname"));
                    }
                }
                statement.close();
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
                if (source != null) {
                    source.close();
                }
            }
        }
        catch (SQLException e) {
            this.checkSqlException(e);
        }
        catch (IOException e) {
            if (e.getCause() instanceof SQLException) {
                this.checkSqlException((SQLException)e.getCause());
            }
            PostgisPlugin.log("Error connecting to datasource", e);
            this.result = "Unrecognized connection failure.  Check parameters and database.";
        }
        this.ran = true;
    }

    private void checkSqlException(SQLException e) {
        if (!e.getMessage().contains("FATAL: no pg_hba.conf entry for host") || !e.getMessage().contains("template1")) {
            if (e.getMessage().contains("FATAL: role") && e.getMessage().contains("does not exist")) {
                this.result = "Username or password is incorrect";
            } else {
                PostgisPlugin.log("Error connecting to database template1", e);
                this.result = "Unrecognized connection failure.  Check parameters and database.";
            }
        }
    }

    public String canConnect() throws IllegalStateException {
        if (!this.ran) {
            throw new IllegalStateException("run must complete running before this method is called.");
        }
        return this.result;
    }

    public String[] getDatabaseNames() {
        return this.databaseNames.toArray(new String[0]);
    }
}

