/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.postgis.ui;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.PostgisGeoResource2;
import net.refractions.udig.catalog.PostgisSchemaFolder;
import net.refractions.udig.catalog.PostgisService2;
import net.refractions.udig.catalog.PostgisServiceExtension2;
import net.refractions.udig.catalog.internal.postgis.PostgisPlugin;
import net.refractions.udig.catalog.ui.UDIGConnectionFactory;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStoreFactory;

public class PostGisConnectionFactory
extends UDIGConnectionFactory {
    public boolean canProcess(Object context) {
        return this.toCapabilitiesURL(context) != null;
    }

    public Map<String, Serializable> createConnectionParameters(Object context) {
        if (context instanceof PostgisService2) {
            PostgisService2 postgis = (PostgisService2)((Object)context);
            return postgis.getConnectionParams();
        }
        URL url = this.toCapabilitiesURL(context);
        if (url == null) {
            ID sample = ID.cast((Object)context);
            URL uRL = url = sample != null ? sample.toURL() : null;
        }
        if (url != null && PostgisServiceExtension2.isPostGIS(url)) {
            List list = CatalogPlugin.getDefault().getLocalCatalog().find(url, null);
            for (IResolve resolve : list) {
                if (resolve instanceof PostgisService2) {
                    PostgisService2 postgisService = (PostgisService2)((Object)context);
                    return postgisService.getConnectionParams();
                }
                if (resolve instanceof PostgisSchemaFolder) {
                    PostgisSchemaFolder postgisFolder = (PostgisSchemaFolder)resolve;
                    return postgisFolder.getService((IProgressMonitor)new NullProgressMonitor()).getConnectionParams();
                }
                if (!(resolve instanceof PostgisGeoResource2)) continue;
                PostgisGeoResource2 layer = (PostgisGeoResource2)resolve;
                try {
                    PostgisService2 postgis = (PostgisService2)layer.parent(null);
                    return postgis.getConnectionParams();
                }
                catch (IOException iOException) {
                    this.toCapabilitiesURL(layer.getIdentifier());
                }
            }
            return this.createParams(url);
        }
        return null;
    }

    public URL createConnectionURL(Object context) {
        if (context instanceof URL) {
            return (URL)context;
        }
        if (context instanceof Map) {
            Map params = (Map)context;
            try {
                return PostgisServiceExtension2.DIALECT.toURL(params);
            }
            catch (MalformedURLException malformedURLException) {
                return null;
            }
        }
        if (context instanceof String) {
            return this.toCapabilitiesURL((String)context);
        }
        return null;
    }

    protected URL toCapabilitiesURL(Object data) {
        if (data instanceof IResolve) {
            return this.toCapabilitiesURL((IResolve)data);
        }
        if (data instanceof URL) {
            return this.toCapabilitiesURL((URL)data);
        }
        if (data instanceof String) {
            return this.toCapabilitiesURL((String)data);
        }
        if (ID.cast((Object)data) != null && ID.cast((Object)data).toURL() != null) {
            return this.toCapabilitiesURL(ID.cast((Object)data).toURL());
        }
        return null;
    }

    protected URL toCapabilitiesURL(IResolve resolve) {
        if (resolve instanceof IService) {
            return this.toCapabilitiesURL((IService)resolve);
        }
        return this.toCapabilitiesURL(resolve.getIdentifier());
    }

    protected URL toCapabilitiesURL(IService resolve) {
        if (resolve instanceof PostgisService2) {
            return this.toCapabilitiesURL((PostgisService2)resolve);
        }
        return this.toCapabilitiesURL(resolve.getIdentifier());
    }

    protected URL toCapabilitiesURL(PostgisService2 postgis) {
        return postgis.getIdentifier();
    }

    protected URL toCapabilitiesURL(URL url) {
        String protocol;
        if (url == null) {
            return null;
        }
        String string = protocol = url.getProtocol() != null ? url.getProtocol().toLowerCase() : null;
        if (!("http".equals(protocol) || "https".equals(protocol) || PostgisServiceExtension2.DIALECT.urlPrefix.equals(protocol))) {
            return null;
        }
        if (url.toExternalForm().indexOf(PostgisServiceExtension2.DIALECT.urlPrefix) != -1) {
            return url;
        }
        return null;
    }

    protected URL toCapabilitiesURL(String string) {
        String the_database;
        String the_port;
        if (string == null) {
            return null;
        }
        if (!(string.contains(PostgisServiceExtension2.DIALECT.urlPrefix) || string.contains("jdbc.postgis") || string.contains("postgis"))) {
            return null;
        }
        int startindex = string.indexOf("//") + 2;
        int usernameEnd = string.indexOf(":", startindex);
        int passwordEnd = string.indexOf("@", usernameEnd);
        int hostEnd = string.indexOf(":", passwordEnd);
        int portEnd = string.indexOf("/", hostEnd);
        int databaseEnd = string.indexOf("/", portEnd + 1);
        String the_host = string.substring(passwordEnd + 1, hostEnd);
        String the_username = string.substring(startindex, usernameEnd);
        if (portEnd < 1) {
            the_port = string.substring(hostEnd + 1);
            the_database = "";
        } else {
            the_port = string.substring(hostEnd + 1, portEnd);
            the_database = string.substring(portEnd + 1, databaseEnd);
        }
        Integer intPort = !the_port.equalsIgnoreCase("") ? new Integer(the_port) : new Integer(5432);
        URL url = null;
        try {
            url = PostgisServiceExtension2.DIALECT.toURL(the_username, the_host, intPort, the_database);
        }
        catch (MalformedURLException e) {
            PostgisPlugin.log("bad url", e);
        }
        return url;
    }

    protected Map<String, Serializable> createParams(URL url) {
        PostgisServiceExtension2 serviceFactory = new PostgisServiceExtension2();
        Map<String, Serializable> params = serviceFactory.createParams(url);
        if (params != null) {
            return params;
        }
        HashMap<String, Serializable> params2 = new HashMap<String, Serializable>();
        params2.put(JDBCDataStoreFactory.DBTYPE.key, (Serializable)JDBCDataStoreFactory.DBTYPE.sample);
        params2.put(JDBCDataStoreFactory.HOST.key, (Serializable)((Object)url.getHost()));
        String dbport = Integer.valueOf(url.getPort()).toString();
        try {
            params2.put(PostgisNGDataStoreFactory.PORT.key, new Integer(dbport));
        }
        catch (NumberFormatException numberFormatException) {
            params2.put(PostgisNGDataStoreFactory.PORT.key, new Integer(5432));
        }
        String the_database = url.getPath() == null ? "" : url.getPath();
        params2.put(JDBCDataStoreFactory.DATABASE.key, (Serializable)((Object)the_database));
        String userInfo = url.getUserInfo() == null ? "" : url.getUserInfo();
        params2.put(JDBCDataStoreFactory.USER.key, (Serializable)((Object)userInfo));
        params2.put(JDBCDataStoreFactory.PASSWD.key, (Serializable)((Object)""));
        return params2;
    }
}

