/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveFolder;
import net.refractions.udig.catalog.IResolveManager;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.PostgisGeoResource2;
import net.refractions.udig.catalog.PostgisService2;
import net.refractions.udig.catalog.PostgisServiceExtension2;
import net.refractions.udig.catalog.internal.postgis.PostgisPlugin;
import net.refractions.udig.catalog.service.database.TableDescriptor;
import net.refractions.udig.core.internal.CorePlugin;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.resource.ImageDescriptor;
import org.geotools.data.postgis.PostgisNGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStore;

public class PostgisSchemaFolder
implements IResolveFolder {
    private final String schema;
    private final ArrayList<IResolve> members;
    private final PostgisService2 service;
    private final URL identifier;
    private Exception trace = new Exception("Creating folder");
    private HashMap<String, Serializable> params;
    private JDBCDataStore datastore;

    public PostgisSchemaFolder(PostgisService2 service, String schema, Collection<TableDescriptor> descriptors) {
        this.service = service;
        this.schema = schema;
        try {
            URL identifier2 = service.getIdentifier();
            this.identifier = new URL(identifier2, String.valueOf(identifier2.toExternalForm()) + "#" + schema, CorePlugin.RELAXED_HANDLER);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("The service URL must not contain a #", e);
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>(service.getConnectionParams());
        params.put(PostgisNGDataStoreFactory.SCHEMA.key, (Serializable)((Object)schema));
        this.params = params;
        this.members = new ArrayList();
        for (TableDescriptor tableDescriptor : descriptors) {
            PostgisGeoResource2 resource2 = new PostgisGeoResource2(service, this, tableDescriptor);
            this.members.add((IResolve)resource2);
        }
    }

    protected void finalize() throws Throwable {
        if (this.trace != null) {
            PostgisPlugin.log("PostgisSchemaFolder was not disposed!", this.trace);
            this.dispose((IProgressMonitor)new NullProgressMonitor());
        }
        super.finalize();
    }

    public ImageDescriptor getIcon(IProgressMonitor monitor) {
        return null;
    }

    public String getTitle() {
        return this.schema;
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        boolean isResolveFolder = adaptee.isAssignableFrom(IResolveFolder.class);
        boolean isIService = adaptee.isAssignableFrom(IService.class);
        boolean isConnection = adaptee.isAssignableFrom(Connection.class);
        boolean isDataStore = adaptee.isAssignableFrom(JDBCDataStore.class);
        IResolveManager resolveManager = CatalogPlugin.getDefault().getResolveManager();
        return isResolveFolder || isIService || isConnection || isDataStore || resolveManager.canResolve((IResolve)this, adaptee);
    }

    public void dispose(IProgressMonitor monitor) {
        this.trace = null;
        if (this.datastore != null) {
            this.datastore.dispose();
        }
    }

    public URL getIdentifier() {
        return this.identifier;
    }

    public ID getID() {
        return new ID(this.getIdentifier());
    }

    public Throwable getMessage() {
        return null;
    }

    public IResolve.Status getStatus() {
        return IResolve.Status.CONNECTED;
    }

    public List<IResolve> members(IProgressMonitor monitor) throws IOException {
        return Collections.unmodifiableList(this.members);
    }

    public IResolve parent(IProgressMonitor monitor) throws IOException {
        return this.service;
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IResolveFolder.class)) {
            return adaptee.cast(this);
        }
        if (adaptee.isAssignableFrom(IService.class)) {
            return adaptee.cast((Object)this.service);
        }
        if (adaptee.isAssignableFrom(JDBCDataStore.class)) {
            return adaptee.cast(this.getDataStore());
        }
        if (adaptee.isAssignableFrom(Connection.class)) {
            return (T)this.service.resolve(adaptee, monitor);
        }
        return (T)CatalogPlugin.getDefault().getResolveManager().resolve((IResolve)this, adaptee, monitor);
    }

    public synchronized JDBCDataStore getDataStore() throws IOException {
        if (this.datastore == null) {
            PostgisNGDataStoreFactory factory = PostgisServiceExtension2.getFactory();
            this.datastore = factory.createDataStore(this.params);
        }
        return this.datastore;
    }

    public String getSchemaName() {
        return this.schema;
    }

    public IService getService(IProgressMonitor monitor) {
        return this.service;
    }
}

