/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.PostgisGeoResource2;
import net.refractions.udig.catalog.internal.postgis.PostgisPlugin;
import net.refractions.udig.catalog.postgis.internal.Messages;
import net.refractions.udig.ui.graphics.Glyph;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Status;
import org.geotools.data.DataSourceException;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.Name;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

class PostgisResourceInfo
extends IGeoResourceInfo {
    private PostgisGeoResource2 owner;

    PostgisResourceInfo(PostgisGeoResource2 owner) throws IOException {
        this.owner = owner;
        this.name = owner.typename;
        if (owner.desc.geometryType != null) {
            this.icon = Glyph.icon((Class)owner.desc.geometryType);
        }
        this.keywords = new String[]{"teradata", owner.typename};
    }

    public synchronized ReferencedEnvelope getBounds() {
        block15: {
            if (this.bounds == null) {
                SimpleFeatureSource source = null;
                try {
                    source = this.owner.resolve(SimpleFeatureSource.class, (IProgressMonitor)new NullProgressMonitor());
                }
                catch (IOException e) {
                    PostgisPlugin.log("Could not establish bounds of dataset.", e);
                    this.bounds = new ReferencedEnvelope(new Envelope(), null);
                    return this.bounds;
                }
                try {
                    ReferencedEnvelope temp;
                    this.bounds = temp = source.getBounds();
                }
                catch (Exception e) {
                    PostgisPlugin.log("PostGIS unable to calculate bounds directly: " + e, e);
                }
                if (this.bounds == null) {
                    try {
                        CoordinateReferenceSystem crs = this.getCRS();
                        org.opengis.geometry.Envelope envelope = CRS.getEnvelope((CoordinateReferenceSystem)crs);
                        if (envelope != null) {
                            this.bounds = new ReferencedEnvelope(new Envelope(envelope.getLowerCorner().getOrdinate(0), envelope.getUpperCorner().getOrdinate(0), envelope.getLowerCorner().getOrdinate(1), envelope.getUpperCorner().getOrdinate(1)), crs);
                            break block15;
                        }
                        this.bounds = new ReferencedEnvelope(new Envelope(), crs);
                        SimpleFeatureIterator iter = source.getFeatures().features();
                        try {
                            while (iter.hasNext()) {
                                SimpleFeature element = (SimpleFeature)iter.next();
                                if (this.bounds.isNull()) {
                                    this.bounds.init(element.getBounds());
                                    continue;
                                }
                                this.bounds.include(element.getBounds());
                            }
                        }
                        finally {
                            iter.close();
                        }
                    }
                    catch (DataSourceException e) {
                        PostgisPlugin.log("Could not establish bounds of dataset.", e);
                    }
                    catch (Exception e) {
                        CatalogPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.catalog", 0, Messages.PostGISGeoResource_error_layer_bounds, (Throwable)e));
                        this.bounds = new ReferencedEnvelope(new Envelope(), null);
                    }
                }
            }
        }
        return this.bounds;
    }

    public CoordinateReferenceSystem getCRS() {
        SimpleFeatureType ft = this.getFeatureType();
        if (ft == null) {
            return DefaultGeographicCRS.WGS84;
        }
        return ft.getCoordinateReferenceSystem();
    }

    private SimpleFeatureType getFeatureType() {
        try {
            return this.owner.getSchema();
        }
        catch (IOException e) {
            if (e.getMessage().contains("permission")) {
                this.owner.setStatus(IResolve.Status.RESTRICTED_ACCESS, e);
            } else {
                this.owner.setStatus(IResolve.Status.BROKEN, e);
            }
            PostgisPlugin.log("Unable to retrieve SimpleFeatureType schema for type '" + this.owner.typename + "'.", e);
            this.keywords = new String[]{"teradata", this.owner.typename};
            return null;
        }
    }

    public String getName() {
        return this.owner.typename;
    }

    public URI getSchema() {
        SimpleFeatureType ft = this.getFeatureType();
        if (ft == null) {
            return null;
        }
        try {
            Name typeName = ft.getName();
            if (typeName.getNamespaceURI() != null) {
                return new URI(ft.getName().getNamespaceURI());
            }
            return null;
        }
        catch (URISyntaxException uRISyntaxException) {
            return null;
        }
    }

    public String getTitle() {
        return this.owner.typename;
    }
}

