/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.oracle.ui;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.oracle.OraclePlugin;
import net.refractions.udig.catalog.internal.oracle.OracleServiceExtension;
import net.refractions.udig.catalog.internal.oracle.ui.OracleSpatialPreferences;
import net.refractions.udig.catalog.oracle.internal.Messages;
import net.refractions.udig.catalog.ui.preferences.AbstractProprietaryDatastoreWizardPage;
import net.refractions.udig.catalog.ui.preferences.AbstractProprietaryJarPreferencePage;
import net.refractions.udig.catalog.ui.wizard.DataBaseConnInfo;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.ui.PlatformUI;
import org.geotools.data.oracle.OracleNGDataStoreFactory;

public class OracleSpatialWizardPage
extends AbstractProprietaryDatastoreWizardPage {
    public static final String IMAGE_KEY = "";
    private static final String ORACLE_WIZARD = "ORACLE_WIZARD";
    private static final String ORACLE_RECENT = "ORACLE_RECENT";
    private static final DataBaseConnInfo DEFAULT_ORACLE_CONN_INFO = new DataBaseConnInfo("", "1521", "", "", "", "");

    public OracleSpatialWizardPage() {
        super(Messages.OracleSpatialWizardPage_wizardTitle);
        this.settings = OraclePlugin.getDefault().getDialogSettings().getSection(ORACLE_WIZARD);
        if (this.settings == null) {
            this.settings = OraclePlugin.getDefault().getDialogSettings().addNewSection(ORACLE_WIZARD);
        }
        this.settingsArrayName = ORACLE_RECENT;
        this.defaultDBCI.setParameters(DEFAULT_ORACLE_CONN_INFO);
        this.currentDBCI.setParameters(this.defaultDBCI);
        String[] recent = this.settings.getArray(ORACLE_RECENT);
        if (recent != null) {
            String[] stringArray = recent;
            int n = recent.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                DataBaseConnInfo dbs = new DataBaseConnInfo(s);
                if (!this.storedDBCIList.contains(dbs)) {
                    this.storedDBCIList.add(dbs);
                }
                ++n2;
            }
        }
    }

    protected AbstractProprietaryJarPreferencePage getPreferencePage() {
        return new OracleSpatialPreferences();
    }

    public String getId() {
        return "net.refractions.udig.catalog.ui.oracle";
    }

    protected String getRestartMessage() {
        return Messages.OracleSpatialWizardPage_restart;
    }

    protected String getDriversMessage() {
        return Messages.OracleSpatialWizardPage_drivers;
    }

    protected void doCreateWizardPage(Composite parent) {
        ISelection tmpSelection = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getSelection();
        Object selection = null;
        selection = tmpSelection == null || !(tmpSelection instanceof IStructuredSelection) ? new StructuredSelection() : (IStructuredSelection)tmpSelection;
        String selectedText = null;
        for (Object o : selection) {
            if (!(o instanceof URL) && !(o instanceof String)) continue;
            selectedText = (String)o;
            if (selectedText.contains("jdbc:oracle:thin:@")) break;
            selectedText = null;
        }
        if (selectedText != null) {
            int startindex = selectedText.indexOf("@");
            int hostEnd = selectedText.indexOf(":", startindex);
            int portEnd = selectedText.indexOf(":", hostEnd);
            int databaseEnd = selectedText.indexOf(":", portEnd);
            String the_host = selectedText.substring(startindex, hostEnd);
            String the_port = selectedText.substring(hostEnd, portEnd);
            String the_database = selectedText.substring(portEnd, databaseEnd);
            this.currentDBCI.setHost(the_host);
            if (!the_port.equalsIgnoreCase(IMAGE_KEY)) {
                this.currentDBCI.setPort(the_port);
            }
            this.currentDBCI.setDb(the_database);
        }
    }

    public boolean canProcess(Object object) {
        return this.getOracleURL(object) != null;
    }

    protected String getOracleURL(Object data) {
        String[] strings;
        String url = null;
        if (data instanceof String && !(url = (strings = ((String)data).split("\n"))[0]).toLowerCase().contains("jdbc:oracle")) {
            url = null;
        }
        return url;
    }

    protected Group createAdvancedControl(Composite arg0) {
        return null;
    }

    protected OracleNGDataStoreFactory getDataStoreFactorySpi() {
        return OracleServiceExtension.getFactory();
    }

    public Map<String, Serializable> getParams() {
        if (!OracleSpatialPreferences.isInstalled()) {
            return null;
        }
        if (!this.couldConnect()) {
            return null;
        }
        HashMap<String, Serializable> params = new HashMap<String, Serializable>();
        params.put(OracleNGDataStoreFactory.DBTYPE.key, (Serializable)OracleNGDataStoreFactory.DBTYPE.sample);
        params.put(OracleNGDataStoreFactory.HOST.key, (Serializable)((Object)this.currentDBCI.getHostString()));
        try {
            params.put(OracleNGDataStoreFactory.PORT.key, new Integer(this.currentDBCI.getPortString()));
        }
        catch (NumberFormatException numberFormatException) {}
        params.put(OracleNGDataStoreFactory.USER.key, (Serializable)((Object)this.currentDBCI.getUserString()));
        params.put(OracleNGDataStoreFactory.PASSWD.key, (Serializable)((Object)this.currentDBCI.getPassString()));
        params.put(OracleNGDataStoreFactory.DATABASE.key, (Serializable)((Object)this.currentDBCI.getDbString()));
        params.put(OracleNGDataStoreFactory.SCHEMA.key, (Serializable)((Object)this.currentDBCI.getSchemaString()));
        return params;
    }

    protected DataSource getDataSource() {
        final String hostText = this.currentDBCI.getHostString();
        final String portText = this.currentDBCI.getPortString();
        final String userText = this.currentDBCI.getUserString();
        final String passText = this.currentDBCI.getPassString();
        final String db = this.currentDBCI.getDbString();
        if (!this.couldConnect()) {
            return null;
        }
        if (this.dataSource == null) {
            this.runInPage(new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                    if (monitor == null) {
                        monitor = new NullProgressMonitor();
                    }
                    Connection connection = null;
                    try {
                        try {
                            monitor.beginTask(Messages.OracleSpatialWizardPage_connectionTask, -1);
                            if (OracleSpatialWizardPage.this.dataSource != null) {
                                try {
                                    OracleSpatialWizardPage.this.dataSource.close();
                                }
                                catch (SQLException sQLException) {}
                            }
                            HashMap<String, Object> params = new HashMap<String, Object>();
                            params.put(OracleNGDataStoreFactory.HOST.key, hostText);
                            params.put(OracleNGDataStoreFactory.PORT.key, (Integer)OracleNGDataStoreFactory.PORT.parse(portText));
                            params.put(OracleNGDataStoreFactory.DATABASE.key, db);
                            params.put(OracleNGDataStoreFactory.USER.key, userText);
                            params.put(OracleNGDataStoreFactory.PASSWD.key, passText);
                            OracleSpatialWizardPage.this.dataSource = OracleServiceExtension.getFactory().createDataSource(params);
                            DriverManager.setLoginTimeout(3);
                            monitor.worked(1);
                            monitor.subTask("establish connection");
                            if (monitor.isCanceled()) {
                                OracleSpatialWizardPage.this.dataSource.close();
                                OracleSpatialWizardPage.this.dataSource = null;
                            }
                            connection = OracleSpatialWizardPage.this.dataSource.getConnection();
                            monitor.subTask("connected");
                            monitor.worked(1);
                        }
                        catch (Throwable shame) {
                            if (OracleSpatialWizardPage.this.dataSource != null) {
                                try {
                                    OracleSpatialWizardPage.this.dataSource.close();
                                }
                                catch (SQLException sQLException) {}
                                OracleSpatialWizardPage.this.dataSource = null;
                            }
                            throw new InvocationTargetException(shame, shame.getLocalizedMessage());
                        }
                    }
                    catch (Throwable throwable) {
                        if (connection != null) {
                            try {
                                connection.close();
                            }
                            catch (SQLException sQLException) {}
                        }
                        throw throwable;
                    }
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (SQLException sQLException) {}
                    }
                }
            });
        }
        return this.dataSource;
    }

    protected boolean dbmsUsesSchema() {
        return true;
    }

    protected boolean doIsPageComplete() {
        Map<String, Serializable> p = this.getParams();
        if (p == null) {
            return false;
        }
        boolean r = this.getDataStoreFactorySpi().canProcess(p);
        return r;
    }

    public List<IResolve> getResources(IProgressMonitor monitor) throws Exception {
        if (!this.isPageComplete()) {
            return null;
        }
        OracleServiceExtension creator = new OracleServiceExtension();
        IService service = creator.createService((URL)null, (Map)this.getParams());
        service.getInfo(monitor);
        ArrayList<IResolve> servers = new ArrayList<IResolve>();
        servers.add((IResolve)service);
        return servers;
    }
}

