/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.oracle;

import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IResolveChangeEvent;
import net.refractions.udig.catalog.IResolveDelta;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.IServiceInfo;
import net.refractions.udig.catalog.internal.CatalogImpl;
import net.refractions.udig.catalog.internal.ResolveChangeEvent;
import net.refractions.udig.catalog.internal.ResolveDelta;
import net.refractions.udig.catalog.internal.oracle.OracleGeoResource;
import net.refractions.udig.catalog.internal.oracle.OraclePlugin;
import net.refractions.udig.catalog.internal.oracle.OracleServiceExtension;
import net.refractions.udig.catalog.oracle.internal.Messages;
import net.refractions.udig.core.internal.CorePlugin;
import net.refractions.udig.ui.UDIGDisplaySafeLock;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.data.oracle.OracleNGDataStoreFactory;
import org.geotools.jdbc.JDBCDataStore;

public class OracleServiceImpl
extends IService {
    private URL url = null;
    private Map<String, Serializable> params = null;
    private Throwable msg = null;
    private volatile JDBCDataStore ds = null;
    protected Lock rLock = new UDIGDisplaySafeLock();
    private static final Lock dsLock = new UDIGDisplaySafeLock();
    private volatile List<OracleGeoResource> members = null;

    public OracleServiceImpl(URL arg1, Map<String, Serializable> arg2) {
        if (arg1 == null) {
            String jdbc_url = OracleServiceExtension.getJDBCUrl(arg2);
            try {
                this.url = new URL(null, jdbc_url, CorePlugin.RELAXED_HANDLER);
            }
            catch (MalformedURLException malformedURLException) {
                throw new NullPointerException("id provided and params could not be used to make one");
            }
        } else {
            this.url = arg1;
        }
        this.params = arg2;
        this.checkPort(this.params);
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        if (adaptee == null) {
            throw new NullPointerException("No adaptor specified");
        }
        if (adaptee.isAssignableFrom(JDBCDataStore.class)) {
            return adaptee.cast(this.getDS(monitor));
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(JDBCDataStore.class) || super.canResolve(adaptee);
    }

    public void dispose(IProgressMonitor monitor) {
        super.dispose(monitor);
        if (this.ds != null) {
            this.ds.dispose();
        }
        if (this.members != null) {
            this.members = null;
        }
    }

    public List<OracleGeoResource> resources(IProgressMonitor monitor) throws IOException {
        if (this.members == null) {
            this.rLock.lock();
            try {
                if (this.members == null) {
                    this.getDS(monitor);
                    this.members = new LinkedList<OracleGeoResource>();
                    String[] typenames = this.ds.getTypeNames();
                    if (typenames != null) {
                        int i = 0;
                        while (i < typenames.length) {
                            String typeName = typenames[i];
                            this.members.add(new OracleGeoResource(this, typeName));
                            ++i;
                        }
                    }
                }
            }
            finally {
                this.rLock.unlock();
            }
        }
        return this.members;
    }

    public IServiceOracleInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (IServiceOracleInfo)super.getInfo(monitor);
    }

    protected IServiceInfo createInfo(IProgressMonitor monitor) throws IOException {
        JDBCDataStore dataStore = this.getDS(monitor);
        if (dataStore == null) {
            return null;
        }
        this.rLock.lock();
        try {
            this.info = new IServiceOracleInfo(dataStore);
        }
        finally {
            this.rLock.unlock();
        }
        return this.info;
    }

    public Map<String, Serializable> getConnectionParams() {
        return this.params;
    }

    JDBCDataStore getDS(IProgressMonitor monitor) throws IOException {
        if (this.ds == null) {
            block7: {
                dsLock.lock();
                try {
                    if (this.ds != null) break block7;
                    OracleNGDataStoreFactory dsf = new OracleNGDataStoreFactory();
                    this.checkPort(this.params);
                    assert (this.params.get("port") instanceof String);
                    if (!dsf.canProcess(this.params)) break block7;
                    try {
                        this.ds = dsf.createDataStore(this.params);
                    }
                    catch (IOException e) {
                        this.msg = e;
                        throw e;
                    }
                }
                finally {
                    dsLock.unlock();
                }
            }
            ResolveDelta delta = new ResolveDelta((IResolve)this, IResolveDelta.Kind.CHANGED);
            ((CatalogImpl)CatalogPlugin.getDefault().getLocalCatalog()).fire((IResolveChangeEvent)new ResolveChangeEvent((Object)this, IResolveChangeEvent.Type.POST_CHANGE, (IResolveDelta)delta));
        }
        return this.ds;
    }

    public IResolve.Status getStatus() {
        if (this.ds == null) {
            return super.getStatus();
        }
        return IResolve.Status.CONNECTED;
    }

    public Throwable getMessage() {
        return this.msg;
    }

    public URL getIdentifier() {
        return this.url;
    }

    private void checkPort(Map<String, Serializable> params) {
        String portKey = OracleNGDataStoreFactory.PORT.key;
        if (params != null && params.containsKey(portKey) && params.get(portKey) instanceof Integer) {
            Integer val = (Integer)params.get(portKey);
            params.remove(portKey);
            params.put(portKey, (Serializable)((Object)val.toString()));
        }
    }

    private class IServiceOracleInfo
    extends IServiceInfo {
        IServiceOracleInfo(JDBCDataStore resource) {
            String[] tns = null;
            try {
                tns = resource.getTypeNames();
            }
            catch (IOException e) {
                OraclePlugin.log(null, e);
                tns = new String[]{};
            }
            this.keywords = new String[tns.length + 1];
            System.arraycopy(tns, 0, this.keywords, 1, tns.length);
            this.keywords[0] = "oracle";
            try {
                this.schema = new URI("jdbc://oracle/gml");
            }
            catch (URISyntaxException e) {
                OraclePlugin.log(null, e);
            }
        }

        public String getDescription() {
            return OracleServiceImpl.this.getIdentifier().toString();
        }

        public URI getSource() {
            try {
                return OracleServiceImpl.this.getIdentifier().toURI();
            }
            catch (URISyntaxException e) {
                throw (RuntimeException)new RuntimeException().initCause(e);
            }
        }

        public String getTitle() {
            return String.valueOf(Messages.OracleServiceImpl_oracle_spatial) + OracleServiceImpl.this.getIdentifier().getHost();
        }
    }
}

