/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.catalog.internal.oracle;

import com.vividsolutions.jts.geom.Envelope;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.ID;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.IGeoResourceInfo;
import net.refractions.udig.catalog.IResolve;
import net.refractions.udig.catalog.IService;
import net.refractions.udig.catalog.internal.oracle.OracleServiceImpl;
import net.refractions.udig.catalog.oracle.internal.Messages;
import net.refractions.udig.core.jts.ReferencedEnvelopeCache;
import net.refractions.udig.ui.graphics.Glyph;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.geotools.data.simple.SimpleFeatureSource;
import org.geotools.data.simple.SimpleFeatureStore;
import org.geotools.data.store.ContentFeatureSource;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.jdbc.JDBCDataStore;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class OracleGeoResource
extends IGeoResource {
    String typename = null;
    private ID id;

    public OracleGeoResource(OracleServiceImpl parent, String typename) {
        this.service = parent;
        this.typename = typename;
        this.id = new ID(this.service.getID(), typename);
    }

    OracleServiceImpl getService() {
        return (OracleServiceImpl)this.service;
    }

    public ID getID() {
        return this.id;
    }

    public URL getIdentifier() {
        return this.id.toURL();
    }

    public IResolve.Status getStatus() {
        return this.service.getStatus();
    }

    public Throwable getMessage() {
        return this.service.getMessage();
    }

    public <T> T resolve(Class<T> adaptee, IProgressMonitor monitor) throws IOException {
        if (adaptee == null) {
            return null;
        }
        if (adaptee.isAssignableFrom(IGeoResourceInfo.class)) {
            return adaptee.cast((Object)this.createInfo(monitor));
        }
        if (adaptee.isAssignableFrom(IGeoResource.class)) {
            return adaptee.cast((Object)this);
        }
        if (adaptee.isAssignableFrom(SimpleFeatureStore.class)) {
            JDBCDataStore dataStore = this.getService().getDS(monitor);
            ContentFeatureSource fs = dataStore.getFeatureSource(this.typename);
            if (fs instanceof SimpleFeatureStore) {
                return adaptee.cast(fs);
            }
            if (adaptee.isAssignableFrom(SimpleFeatureSource.class)) {
                dataStore = this.getService().getDS(monitor);
                return adaptee.cast(dataStore.getFeatureSource(this.typename));
            }
        }
        return (T)super.resolve(adaptee, monitor);
    }

    public <T> boolean canResolve(Class<T> adaptee) {
        if (adaptee == null) {
            return false;
        }
        return adaptee.isAssignableFrom(IGeoResourceInfo.class) || adaptee.isAssignableFrom(SimpleFeatureStore.class) || adaptee.isAssignableFrom(SimpleFeatureSource.class) || adaptee.isAssignableFrom(IService.class) || super.canResolve(adaptee);
    }

    public OracleResourceInfo getInfo(IProgressMonitor monitor) throws IOException {
        return (OracleResourceInfo)super.getInfo(monitor);
    }

    protected OracleResourceInfo createInfo(IProgressMonitor monitor) throws IOException {
        if (this.getStatus() == IResolve.Status.BROKEN) {
            return null;
        }
        this.getService().rLock.lock();
        try {
            OracleResourceInfo oracleResourceInfo = new OracleResourceInfo();
            return oracleResourceInfo;
        }
        finally {
            this.getService().rLock.unlock();
        }
    }

    class OracleResourceInfo
    extends IGeoResourceInfo {
        private SimpleFeatureType ft = null;

        OracleResourceInfo() throws IOException {
            JDBCDataStore dataStore = OracleGeoResource.this.getService().getDS(null);
            this.ft = dataStore.getSchema(OracleGeoResource.this.typename);
            this.title = OracleGeoResource.this.typename;
            try {
                ContentFeatureSource source = dataStore.getFeatureSource(OracleGeoResource.this.typename);
                this.ft = (SimpleFeatureType)source.getSchema();
                this.bounds = source.getBounds();
                if (this.bounds == null) {
                    ((SimpleFeatureType)source.getSchema()).getCoordinateReferenceSystem();
                    this.bounds = ReferencedEnvelopeCache.getReferencedEnvelope((CoordinateReferenceSystem)OracleGeoResource.this.info.getCRS());
                }
            }
            catch (Exception e) {
                CatalogPlugin.getDefault().getLog().log((IStatus)new Status(2, "net.refractions.udig.catalog", 0, Messages.OracleGeoResource_error_layerBounds, (Throwable)e));
                this.bounds = new ReferencedEnvelope(new Envelope(), null);
            }
            this.icon = Glyph.icon((SimpleFeatureType)this.ft);
            this.keywords = new String[]{"postgis", this.ft.getName().getLocalPart(), this.ft.getName().getNamespaceURI()};
        }

        public CoordinateReferenceSystem getCRS() {
            return this.ft.getCoordinateReferenceSystem();
        }

        public String getName() {
            return this.ft.getName().getLocalPart();
        }

        public URI getSchema() {
            try {
                return new URI(this.ft.getName().getNamespaceURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                return null;
            }
        }

        public String getTitle() {
            return this.ft.getName().getLocalPart();
        }
    }
}

