/*
 * Decompiled with CFR 0.152.
 */
package net.refractions.udig.render.internal.wmt.basic;

import com.vividsolutions.jts.geom.Coordinate;
import com.vividsolutions.jts.geom.Envelope;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.RenderedImage;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CancellationException;
import java.util.concurrent.PriorityBlockingQueue;
import java.util.concurrent.TimeUnit;
import net.refractions.udig.catalog.CatalogPlugin;
import net.refractions.udig.catalog.IGeoResource;
import net.refractions.udig.catalog.internal.wmt.WMTRenderJob;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTile;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTileImageReadWriter;
import net.refractions.udig.catalog.internal.wmt.tile.WMTTileSetWrapper;
import net.refractions.udig.catalog.internal.wmt.ui.properties.WMTLayerProperties;
import net.refractions.udig.catalog.internal.wmt.wmtsource.WMTSource;
import net.refractions.udig.catalog.wmsc.server.Tile;
import net.refractions.udig.catalog.wmsc.server.TileImageReadWriter;
import net.refractions.udig.catalog.wmsc.server.TileListener;
import net.refractions.udig.catalog.wmsc.server.TileRange;
import net.refractions.udig.catalog.wmsc.server.TileRangeInMemory;
import net.refractions.udig.catalog.wmsc.server.TileRangeOnDisk;
import net.refractions.udig.catalog.wmsc.server.TileSet;
import net.refractions.udig.catalog.wmsc.server.TileWorkerQueue;
import net.refractions.udig.project.ILayer;
import net.refractions.udig.project.internal.StyleBlackboard;
import net.refractions.udig.project.internal.render.impl.RendererImpl;
import net.refractions.udig.project.render.RenderException;
import net.refractions.udig.render.internal.wmsc.basic.WMSCTileCaching;
import net.refractions.udig.render.wmt.basic.WMTPlugin;
import net.refractions.udig.render.wmt.basic.internal.Messages;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.geotools.coverage.grid.GridCoverage2D;
import org.geotools.coverage.grid.GridCoverageFactory;
import org.geotools.geometry.Envelope2D;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.renderer.lite.RendererUtilities;
import org.geotools.renderer.lite.gridcoverage2d.GridCoverageRenderer;
import org.geotools.styling.RasterSymbolizer;
import org.geotools.styling.StyleBuilder;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class BasicWMTRenderer
extends RendererImpl {
    private static StyleBuilder styleBuilder = new StyleBuilder();
    private TileListenerImpl listener = new TileListenerImpl();
    private static final boolean testing = false;
    private static final boolean TESTING = WMTPlugin.getDefault().isDebugging();
    private static int staticid = 0;
    private static TileWorkerQueue requestTileWorkQueue = new TileWorkerQueue();
    private static TileWorkerQueue writeTileWorkQueue = new TileWorkerQueue();
    private BlockingQueue<Tile> tilesToDraw_queue = new PriorityBlockingQueue<Tile>();

    public void render(Graphics2D destination, IProgressMonitor monitor) throws RenderException {
        this.render(destination, (Envelope)this.getRenderBounds(), monitor);
    }

    public void render(IProgressMonitor monitor) throws RenderException {
        Graphics2D graphics = (Graphics2D)this.getContext().getImage().getGraphics();
        this.render(graphics, (Envelope)this.getRenderBounds(), monitor);
    }

    public void render(Graphics2D destination, Envelope bounds, IProgressMonitor monitor) throws RenderException {
        WMTPlugin.trace("[BasicWMTRender.render] is called");
        if (monitor == null) {
            monitor = new NullProgressMonitor();
        }
        monitor.beginTask("Render WMT", 100);
        this.setState(32);
        ILayer layer = null;
        try {
            layer = this.getContext().getLayer();
            layer.setStatus(0);
            layer.setStatusMessage("");
            WMTSource wmtSource = this.getWmtSourceFromLayer(layer);
            if (wmtSource == null) {
                throw new UnsupportedOperationException(Messages.Render_Error_NoSource);
            }
            WMTLayerProperties layerProperties = new WMTLayerProperties((StyleBlackboard)layer.getStyleBlackboard());
            ReferencedEnvelope mapExtent = this.getRenderBounds();
            if (mapExtent == null) {
                mapExtent = this.context.getViewportModel().getBounds();
            }
            double scale = this.getContext().getViewportModel().getScaleDenominator();
            WMTPlugin.trace("[BasicWMTRender.render] Scale: " + scale);
            WMTRenderJob renderJob = null;
            try {
                renderJob = WMTRenderJob.createRenderJob((ReferencedEnvelope)mapExtent, (double)scale, (WMTSource)wmtSource);
            }
            catch (Exception exception) {
                throw new UnsupportedOperationException(Messages.Render_Error_Projection);
            }
            int tileLimitWarning = WMTRenderJob.getTileLimitWarning();
            Map<String, Tile> tileList = wmtSource.cutExtentIntoTiles(renderJob, WMTRenderJob.getScaleFactor(), false, layerProperties, tileLimitWarning);
            if (tileList.isEmpty()) {
                throw new UnsupportedOperationException(Messages.Render_Error_NoData);
            }
            if ((tileList = this.checkTooManyTiles(layer, wmtSource, layerProperties, renderJob, tileList)).isEmpty()) {
                throw new UnsupportedOperationException(Messages.Render_Error_TooManyTiles);
            }
            TileRange range = this.createTileRange(wmtSource, renderJob, tileList);
            RasterSymbolizer style = styleBuilder.createRasterSymbolizer();
            int tileCount = range.getTileCount();
            int tileWorth = tileCount / 100 * tileCount;
            int thisid = 0;
            Map tiles = range.getTiles();
            HashSet<String> notRenderedTiles = new HashSet<String>();
            HashSet<String> renderedTiles = new HashSet<String>();
            this.renderReadyTiles(destination, monitor, renderJob, style, tileWorth, thisid, tiles, notRenderedTiles, renderedTiles);
            this.setState(2);
            if (!notRenderedTiles.isEmpty()) {
                this.renderNotRenderedTiles(destination, monitor, renderJob, range, style, tileWorth, thisid, notRenderedTiles, renderedTiles);
            }
        }
        catch (UnsupportedOperationException doneExc) {
            this.setDone(monitor);
            layer.setStatus(2);
            layer.setStatusMessage(doneExc.getMessage());
            WMTPlugin.log("[BasicWMTRenderer.render] Error: ", doneExc);
            return;
        }
        catch (CancellationException cancellationException) {
            return;
        }
        catch (Exception ex) {
            WMTPlugin.log("[BasicWMTRenderer.render] Unexpected Error: ", ex);
        }
        this.setDone(monitor);
    }

    private void renderNotRenderedTiles(Graphics2D destination, IProgressMonitor monitor, WMTRenderJob renderJob, TileRange range, RasterSymbolizer style, int tileWorth, int thisid, Set<String> notRenderedTiles, Set<String> renderedTiles) throws Exception {
        this.checkCancelState(monitor, thisid, false);
        range.addListener((TileListener)this.listener);
        range.loadTiles(monitor);
        while (!notRenderedTiles.isEmpty()) {
            this.checkCancelState(monitor, thisid, true);
            Tile tile = null;
            try {
                Tile element = null;
                while ((element = this.tilesToDraw_queue.poll(1000L, TimeUnit.MILLISECONDS)) == null) {
                    this.checkCancelState(monitor, thisid, true);
                }
                tile = element;
            }
            catch (InterruptedException element) {
                // empty catch block
            }
            this.checkCancelState(monitor, thisid, true);
            ReferencedEnvelope viewbounds = renderJob.projectMapToTileCrs(this.context.getViewportModel().getBounds());
            if (tile != null && tile.getBufferedImage() != null && viewbounds != null && viewbounds.intersects(tile.getBounds()) && !renderedTiles.contains(tile.getId()) && notRenderedTiles.contains(tile.getId())) {
                try {
                    renderedTiles.add(tile.getId());
                    this.renderTile(destination, (WMTTile)tile, style, renderJob);
                }
                catch (Exception exc) {
                    WMTPlugin.log("[BasicWMTRender.render] renderTile failed (2): " + tile.getId(), exc);
                }
                monitor.worked(tileWorth);
                this.setState(2);
            }
            notRenderedTiles.remove(tile.getId());
        }
    }

    private void checkCancelState(IProgressMonitor monitor, int thisid, boolean clearList) {
        if (monitor.isCanceled()) {
            if (clearList) {
                this.tilesToDraw_queue.clear();
            }
            throw new CancellationException();
        }
    }

    private void renderReadyTiles(Graphics2D destination, IProgressMonitor monitor, WMTRenderJob renderJob, RasterSymbolizer style, int tileWorth, int thisid, Map<String, Tile> tiles, Set<String> notRenderedTiles, Set<String> renderedTiles) throws Exception {
        for (String key : tiles.keySet()) {
            this.checkCancelState(monitor, thisid, false);
            Tile tile = tiles.get(key);
            if (tile != null && tile.getBufferedImage() != null && tile.getTileState() != 1) {
                try {
                    renderedTiles.add(key);
                    this.renderTile(destination, (WMTTile)tile, style, renderJob);
                }
                catch (Exception exc) {
                    WMTPlugin.log("[BasicWMTRender.render] renderTile failed (1): " + tile.getId(), exc);
                }
                monitor.worked(tileWorth);
                continue;
            }
            notRenderedTiles.add(key);
            this.renderBlankTile(destination, (WMTTile)tile, renderJob);
        }
    }

    private TileRange createTileRange(WMTSource wmtSource, WMTRenderJob renderJob, Map<String, Tile> tileList) {
        TileRangeInMemory range;
        WMTTileSetWrapper tileset = new WMTTileSetWrapper(wmtSource);
        String value = CatalogPlugin.getDefault().getPreferenceStore().getString("P_WMSCTILE_CACHING");
        if (value.equals(WMSCTileCaching.ONDISK.toString())) {
            String dir = CatalogPlugin.getDefault().getPreferenceStore().getString("P_WMSCTILE_DISKDIR");
            WMTTileImageReadWriter tileReadWriter = new WMTTileImageReadWriter(dir);
            range = new TileRangeOnDisk(null, (TileSet)tileset, (Envelope)renderJob.getMapExtentTileCrs(), tileList, requestTileWorkQueue, writeTileWorkQueue, (TileImageReadWriter)tileReadWriter);
        } else {
            range = new TileRangeInMemory(null, (TileSet)tileset, (Envelope)renderJob.getMapExtentTileCrs(), tileList, requestTileWorkQueue);
        }
        return range;
    }

    private Map<String, Tile> checkTooManyTiles(ILayer layer, WMTSource wmtSource, WMTLayerProperties layerProperties, WMTRenderJob renderJob, Map<String, Tile> tileList) {
        int tileLimitWarning;
        int tilesCount = tileList.size();
        if (tilesCount > (tileLimitWarning = WMTRenderJob.getTileLimitWarning())) {
            Boolean selectionAutomatic = layerProperties.getSelectionAutomatic();
            if (selectionAutomatic != null && !selectionAutomatic.booleanValue()) {
                tileList.clear();
                tileList = wmtSource.cutExtentIntoTiles(renderJob, WMTRenderJob.getScaleFactor(), true, layerProperties, tileLimitWarning);
                tilesCount = tileList.size();
            }
            layer.setStatus(4);
            layer.setStatusMessage(Messages.Render_Warning_TooManyTiles);
            WMTPlugin.trace("[BasicWMTRender.render] Set WARNING_TOO_MANY_TILES");
        }
        if (tilesCount > WMTRenderJob.getTileLimitError()) {
            WMTPlugin.trace("[BasicWMTRender.render] Set ERROR_TOO_MANY_TILES");
            return Collections.emptyMap();
        }
        return tileList;
    }

    private void setDone(IProgressMonitor monitor) {
        this.setState(4);
        monitor.done();
    }

    private WMTSource getWmtSourceFromLayer(ILayer layer) {
        IGeoResource resource = layer.findGeoResource(WMTSource.class);
        if (resource != null) {
            WMTSource wmtSource = null;
            try {
                wmtSource = (WMTSource)resource.resolve(WMTSource.class, null);
                return wmtSource;
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private void renderTile(Graphics2D graphics, WMTTile tile, RasterSymbolizer style, WMTRenderJob renderJob) throws Exception {
        if (tile == null || tile.getBufferedImage() == null) {
            return;
        }
        GridCoverageFactory factory = new GridCoverageFactory();
        ReferencedEnvelope tileBndsMercatorRef = renderJob.projectTileToTileProjectedCrs(tile.getExtent());
        GridCoverage2D coverage = factory.create((CharSequence)"GridCoverage", (RenderedImage)tile.getBufferedImage(), (org.opengis.geometry.Envelope)tileBndsMercatorRef);
        Envelope2D coveragebounds = coverage.getEnvelope2D();
        ReferencedEnvelope bnds = new ReferencedEnvelope(coveragebounds.getMinX(), coveragebounds.getMaxX(), coveragebounds.getMinY(), coveragebounds.getMaxY(), renderJob.getCrsTilesProjected());
        bnds = renderJob.projectTileProjectedToMapCrs(bnds);
        Point upperLeft = this.getContext().worldToPixel(new Coordinate(bnds.getMinX(), bnds.getMinY()));
        Point bottomRight = this.getContext().worldToPixel(new Coordinate(bnds.getMaxX(), bnds.getMaxY()));
        Rectangle tileSize = new Rectangle(upperLeft);
        tileSize.add(bottomRight);
        try {
            CoordinateReferenceSystem crs = this.getContext().getCRS();
            AffineTransform worldToScreen = RendererUtilities.worldToScreenTransform((Envelope)bnds, (Rectangle)tileSize, (CoordinateReferenceSystem)crs);
            GridCoverageRenderer paint = new GridCoverageRenderer(crs, (Envelope)bnds, tileSize, worldToScreen);
            paint.paint(graphics, coverage, style);
            if (TESTING) {
                graphics.setColor(Color.BLACK);
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMinY(), (int)tileSize.getMinX(), (int)tileSize.getMaxY());
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMinY(), (int)tileSize.getMaxX(), (int)tileSize.getMinY());
                graphics.drawLine((int)tileSize.getMaxX(), (int)tileSize.getMinY(), (int)tileSize.getMaxX(), (int)tileSize.getMaxY());
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMaxY(), (int)tileSize.getMaxX(), (int)tileSize.getMaxY());
                graphics.drawString(tile.getId(), (int)tileSize.getMaxX() - 113, (int)tileSize.getMaxY() - 113);
            }
        }
        catch (Throwable t) {
            WMTPlugin.log("Error Rendering tile. Painting Tile " + tile.getId(), t);
        }
    }

    private void renderBlankTile(Graphics2D graphics, WMTTile tile, WMTRenderJob renderJob) throws Exception {
        if (tile == null) {
            return;
        }
        ReferencedEnvelope bnds = renderJob.projectTileToMapCrs(tile.getExtent());
        Point upperLeft = this.getContext().worldToPixel(new Coordinate(bnds.getMinX(), bnds.getMinY()));
        Point bottomRight = this.getContext().worldToPixel(new Coordinate(bnds.getMaxX(), bnds.getMaxY()));
        Rectangle tileSize = new Rectangle(upperLeft);
        tileSize.add(bottomRight);
        try {
            graphics.setBackground(new Color(255, 255, 255, 0));
            graphics.clearRect(tileSize.x, tileSize.y, tileSize.width, tileSize.height);
            if (TESTING) {
                graphics.setColor(Color.BLACK);
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMinY(), (int)tileSize.getMinX(), (int)tileSize.getMaxY());
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMinY(), (int)tileSize.getMaxX(), (int)tileSize.getMinY());
                graphics.drawLine((int)tileSize.getMaxX(), (int)tileSize.getMinY(), (int)tileSize.getMaxX(), (int)tileSize.getMaxY());
                graphics.drawLine((int)tileSize.getMinX(), (int)tileSize.getMaxY(), (int)tileSize.getMaxX(), (int)tileSize.getMaxY());
            }
        }
        catch (Throwable t) {
            WMTPlugin.log("Error Rendering Blank tile. Painting Tile: " + tile.getId(), t);
        }
    }

    protected class TileListenerImpl
    implements TileListener {
        public void notifyTileReady(Tile tile) {
            int currentState = BasicWMTRenderer.this.getState();
            if (currentState == 2 || currentState == 32) {
                try {
                    BasicWMTRenderer.this.tilesToDraw_queue.put(tile);
                }
                catch (InterruptedException e) {
                    WMTPlugin.log("Error while added tile to queue.", e);
                }
            } else {
                BasicWMTRenderer.this.setState(16);
            }
        }
    }
}

