/*
 * Decompiled with CFR 0.152.
 */
package org.geowebcache.diskquota.storage;

public class TileSet
implements Comparable<TileSet> {
    private String key;
    private String layerName;
    private String gridsetId;
    private String blobFormat;
    private String parametersId;
    private transient int cachedHashCode;

    TileSet() {
    }

    public TileSet(String id) {
        this.key = id;
    }

    public TileSet(String layerName, String gridsetId, String blobFormat, String parametersId) {
        this.layerName = layerName;
        this.gridsetId = gridsetId;
        this.blobFormat = blobFormat;
        this.parametersId = parametersId;
        StringBuilder sb = new StringBuilder(128);
        TileSet.computeId(layerName, gridsetId, blobFormat, parametersId, sb);
        this.key = sb.toString();
    }

    public static void computeId(String layerName, String gridsetId, String blobFormat, String parametersId, StringBuilder idTarget) {
        idTarget.append(layerName).append('#').append(gridsetId).append('#').append(blobFormat);
        if (parametersId != null) {
            idTarget.append('#').append(parametersId);
        }
    }

    public void initFromId() {
        String[] splitted = this.key.split("#");
        if (splitted.length < 3 || splitted.length > 4) {
            throw new IllegalArgumentException("Invalid key for standard tile set, it should have the layer#gridset#format[#paramId]");
        }
        this.layerName = splitted[0];
        this.gridsetId = splitted[1];
        this.blobFormat = splitted[2];
        if (splitted.length == 4) {
            this.parametersId = splitted[3];
        }
    }

    public String getId() {
        return this.key;
    }

    public String getLayerName() {
        return this.layerName;
    }

    public String getGridsetId() {
        return this.gridsetId;
    }

    public String getBlobFormat() {
        return this.blobFormat;
    }

    public String getParametersId() {
        return this.parametersId;
    }

    public boolean equals(Object o) {
        if (!(o instanceof TileSet)) {
            return false;
        }
        TileSet t = (TileSet)o;
        boolean equals = this.key.equals(t.getId());
        return equals;
    }

    public int hashCode() {
        if (this.cachedHashCode == 0) {
            this.cachedHashCode = 17 * this.key.hashCode();
        }
        return this.cachedHashCode;
    }

    @Override
    public int compareTo(TileSet o) {
        int val = this.layerName.compareTo(o.layerName);
        if (val != 0) {
            return val;
        }
        val = this.gridsetId.compareTo(o.gridsetId);
        if (val != 0) {
            return val;
        }
        val = this.blobFormat.compareTo(o.blobFormat);
        if (val != 0) {
            return val;
        }
        if (this.parametersId == null) {
            return o.parametersId == null ? 0 : -1;
        }
        if (o.parametersId == null) {
            return 1;
        }
        return this.parametersId.compareTo(o.parametersId);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.key + "]";
    }
}

