/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.jdbc.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.geotools.util.logging.Logging;

public class SqlUtil {
    static final Logger LOGGER = Logging.getLogger(SqlUtil.class);
    private static final Pattern PROPERTY_PATTERN = Pattern.compile("\\$\\{(.+?)\\}");

    public static void runScript(InputStream stream, Connection cx) throws SQLException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
             Statement st = cx.createStatement();){
            StringBuilder buf = new StringBuilder();
            String sql = reader.readLine();
            while (sql != null) {
                if (!(sql = sql.trim()).isEmpty() && !sql.startsWith("--")) {
                    buf.append(sql).append(" ");
                    if (sql.endsWith(";")) {
                        String stmt = buf.toString();
                        boolean skipError = stmt.startsWith("?");
                        if (skipError) {
                            stmt = stmt.replaceAll("^\\? *", "");
                        }
                        LOGGER.fine(stmt);
                        st.addBatch(stmt);
                        buf.setLength(0);
                    }
                }
                sql = reader.readLine();
            }
            st.executeBatch();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public static void runScript(InputStream stream, Connection cx, Map<String, String> properties) throws SQLException {
        int insideBlock = 0;
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(stream));
             Statement st = cx.createStatement();){
            StringBuilder buf = new StringBuilder();
            String sql = reader.readLine();
            while (sql != null) {
                if (!(sql = sql.trim()).isEmpty() && !sql.startsWith("--")) {
                    buf.append(sql).append(" ");
                    if (sql.startsWith("BEGIN")) {
                        ++insideBlock;
                    } else if (insideBlock > 0 && sql.startsWith("END")) {
                        --insideBlock;
                    }
                    if (sql.endsWith(";") && insideBlock == 0) {
                        Matcher matcher = PROPERTY_PATTERN.matcher(buf);
                        while (matcher.find()) {
                            String propertyName = matcher.group(1);
                            String propertyValue = properties.get(propertyName);
                            if (propertyValue == null) {
                                throw new RuntimeException("Missing property " + propertyName + " for sql script");
                            }
                            buf.replace(matcher.start(), matcher.end(), propertyValue);
                            matcher.reset();
                        }
                        String stmt = buf.toString();
                        LOGGER.fine(stmt);
                        st.addBatch(stmt);
                        buf.setLength(0);
                    }
                }
                sql = reader.readLine();
            }
            st.executeBatch();
        }
        catch (IOException e) {
            throw new SQLException(e);
        }
    }

    public static PreparedStatementBuilder prepare(Connection conn, String sql) throws SQLException {
        return new PreparedStatementBuilder(conn, sql);
    }

    public static PreparedStatementBuilder prepare(PreparedStatement st) throws SQLException {
        return new PreparedStatementBuilder(st);
    }

    public static class PreparedStatementBuilder {
        PreparedStatement ps;
        int pos = 1;
        StringBuilder log = new StringBuilder();

        public PreparedStatementBuilder(PreparedStatement ps) throws SQLException {
            this.ps = ps;
        }

        public PreparedStatementBuilder(Connection conn, String sql) throws SQLException {
            this(conn.prepareStatement(sql));
            this.log.append(sql);
        }

        public PreparedStatementBuilder set(Long l) throws SQLException {
            this.log(l);
            this.ps.setLong(this.pos++, l);
            return this;
        }

        public PreparedStatementBuilder set(Integer i) throws SQLException {
            this.log(i);
            if (i != null) {
                this.ps.setInt(this.pos++, i);
            } else {
                this.ps.setNull(this.pos++, 4);
            }
            return this;
        }

        public PreparedStatementBuilder set(Double d) throws SQLException {
            this.log(d);
            if (d != null) {
                this.ps.setDouble(this.pos++, d);
            } else {
                this.ps.setNull(this.pos++, 8);
            }
            return this;
        }

        public PreparedStatementBuilder set(String s) throws SQLException {
            this.log(s);
            this.ps.setString(this.pos++, s);
            return this;
        }

        public PreparedStatementBuilder set(Boolean b) throws SQLException {
            this.log(b);
            this.ps.setBoolean(this.pos++, b);
            return this;
        }

        public PreparedStatementBuilder set(java.util.Date d) throws SQLException {
            this.log(d);
            this.ps.setDate(this.pos++, d != null ? new Date(d.getTime()) : null);
            return this;
        }

        public PreparedStatementBuilder set(byte[] b) throws SQLException {
            this.log(b);
            this.ps.setBytes(this.pos++, b);
            return this;
        }

        public PreparedStatementBuilder log(Level l) {
            LOGGER.log(l, this.log.toString());
            return this;
        }

        public PreparedStatement statement() {
            return this.ps;
        }

        void log(Object v) {
            this.log.append("\n").append(" ").append(this.pos).append(" = ").append(v);
        }
    }
}

