/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.data.complex.feature.xpath;

import org.apache.commons.jxpath.ri.QName;
import org.apache.commons.jxpath.ri.compiler.NodeNameTest;
import org.apache.commons.jxpath.ri.compiler.NodeTest;
import org.apache.commons.jxpath.ri.compiler.NodeTypeTest;
import org.apache.commons.jxpath.ri.model.NodeIterator;
import org.apache.commons.jxpath.ri.model.NodePointer;
import org.geotools.api.feature.Attribute;
import org.geotools.api.feature.ComplexAttribute;
import org.geotools.data.complex.feature.xpath.AttributeNodeIterator;
import org.geotools.data.complex.feature.xpath.XmlAttributeNodeIterator;
import org.geotools.data.complex.util.ComplexFeatureConstants;
import org.geotools.feature.type.Types;

public class AttributeNodePointer
extends NodePointer {
    private static final long serialVersionUID = -5637103253645991273L;
    QName name;
    Attribute feature;

    protected AttributeNodePointer(NodePointer parent, Attribute feature, QName name) {
        super(parent);
        this.name = name;
        this.feature = feature;
    }

    public boolean isLeaf() {
        return !(this.feature instanceof ComplexAttribute);
    }

    public boolean isCollection() {
        return false;
    }

    public int getLength() {
        return 1;
    }

    public QName getName() {
        return this.name;
    }

    public Object getBaseValue() {
        return null;
    }

    public Object getImmediateNode() {
        return ComplexFeatureConstants.unpack(this.feature);
    }

    public Attribute getImmediateAttribute() {
        return this.feature;
    }

    public void setValue(Object value) {
        this.feature = (Attribute)value;
    }

    public int compareChildNodePointers(NodePointer pointer1, NodePointer pointer2) {
        return 0;
    }

    public NodeIterator childIterator(NodeTest test, boolean reverse, NodePointer startWith) {
        NodeTypeTest nodeTypeTest;
        if (test instanceof NodeNameTest) {
            NodeNameTest nodeNameTest = (NodeNameTest)test;
            if (!nodeNameTest.isWildcard()) {
                String localName = nodeNameTest.getNodeName().getName();
                String nameSpace = nodeNameTest.getNamespaceURI();
                if (nameSpace == null) {
                    nameSpace = this.getNamespaceResolver().getNamespaceURI("");
                }
                return new AttributeNodeIterator(this, Types.typeName(nameSpace, localName));
            }
            return new AttributeNodeIterator(this);
        }
        if (test instanceof NodeTypeTest && (nodeTypeTest = (NodeTypeTest)test).getNodeType() == 1) {
            return new AttributeNodeIterator(this);
        }
        return super.childIterator(test, reverse, startWith);
    }

    public NodeIterator attributeIterator(QName qname) {
        return new XmlAttributeNodeIterator(this, Types.typeName(this.getNamespaceResolver().getNamespaceURI(qname.getPrefix()), qname.getName()));
    }
}

